/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.textedit.xtext.nested.editor;

import java.io.IOException;
import java.util.EventObject;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IOperationHistoryListener;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.text.IDocument;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.sasheditor.editor.IPageChangedListener;
import org.eclipse.papyrus.infra.core.sasheditor.editor.ISashWindowsContainer;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.core.utils.ServiceUtils;
import org.eclipse.papyrus.infra.emf.gmf.command.NotifyingWorkspaceCommandStack;
import org.eclipse.papyrus.infra.gmfdiag.extensionpoints.editors.configuration.ICustomDirectEditorConfiguration;
import org.eclipse.papyrus.infra.textedit.textdocument.TextDocument;
import org.eclipse.papyrus.infra.textedit.textdocument.TextDocumentPackage;
import org.eclipse.papyrus.infra.textedit.xtext.Activator;
import org.eclipse.papyrus.infra.textedit.xtext.custom.PapyrusXTextDocumentProvider;
import org.eclipse.papyrus.infra.textedit.xtext.internal.command.TextUndoRedoCommandWrapper;
import org.eclipse.papyrus.infra.textedit.xtext.internal.listeners.SaveTextOnFocusLostPageLifeCycleEventsListener;
import org.eclipse.papyrus.infra.textedit.xtext.internal.listeners.SaveTextOnFocusLostPartListener;
import org.eclipse.papyrus.infra.textedit.xtext.internal.listeners.UndoableTextChangeListener;
import org.eclipse.papyrus.infra.textedit.xtext.nested.editor.NestedXTextEditorInput;
import org.eclipse.papyrus.infra.textedit.xtext.nested.editor.NestedXTextEditorStorage;
import org.eclipse.papyrus.infra.ui.lifecycleevents.ISaveAndDirtyService;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.ISaveablePart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.model.XtextDocument;

public class PapyrusXTextEditor
extends XtextEditor {
    private CommandStackListener commandStackListener;
    private Adapter textDocumentListener;
    private IPartListener2 partListener;
    protected ServicesRegistry registry;
    protected TextDocument textDocument;
    protected TransactionalEditingDomain domain;
    protected ModelSet modelSet;
    protected ISaveAndDirtyService saveAndDirtyService;
    protected ICustomDirectEditorConfiguration editorConfiguration;
    private String fileExtension;
    private NestedXTextEditorStorage storage = null;
    private NestedXTextEditorInput input = null;
    private ISashWindowsContainer sashWindowsContainer = null;
    private SaveTextOnFocusLostPageLifeCycleEventsListener sashWindowsContainerListener = null;
    private UndoableTextChangeListener historyListener;

    protected IPartListener2 createPartListener() {
        return new SaveTextOnFocusLostPartListener(this);
    }

    public void configureXTextEditor(ServicesRegistry servicesRegistry, TextDocument textDocument, ICustomDirectEditorConfiguration editorConfiguration, String fileExtension) {
        this.registry = servicesRegistry;
        this.textDocument = textDocument;
        this.editorConfiguration = editorConfiguration;
        this.fileExtension = fileExtension;
        try {
            this.modelSet = (ModelSet)this.registry.getService(ModelSet.class);
        }
        catch (ServiceException e1) {
            Activator.log.error("We can't find the ModelSet", (Throwable)e1);
        }
        try {
            this.saveAndDirtyService = (ISaveAndDirtyService)this.registry.getService(ISaveAndDirtyService.class);
        }
        catch (ServiceException e) {
            Activator.log.error("We can find the ISaveAndDirtyService", (Throwable)e);
        }
        this.partListener = this.createPartListener();
        this.storage = new NestedXTextEditorStorage(this.editorConfiguration, this.textDocument, this.fileExtension);
        this.input = new NestedXTextEditorInput(this.storage, this.textDocument, this.editorConfiguration);
    }

    public void doSave(IProgressMonitor progressMonitor) {
        super.doSave(progressMonitor);
        try {
            this.modelSet.save(progressMonitor);
        }
        catch (IOException e) {
            Activator.log.error("We can't save the modelSet", (Throwable)e);
        }
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == EObject.class) {
            return adapter.cast(this.textDocument);
        }
        if (adapter == TextDocument.class) {
            return adapter.cast(this.textDocument);
        }
        return (T)super.getAdapter(adapter);
    }

    private void updateEditorContent() {
        PapyrusXTextDocumentProvider provider = this.getDocumentProvider();
        IXtextDocument document = provider.getDocument(this.input);
        this.historyListener.disable();
        provider.updateTextEditorContent(this.input, (IDocument)document);
        this.historyListener.enable();
    }

    public void saveTextInEditedModel() {
        this.performSave(true, (IProgressMonitor)new NullProgressMonitor());
    }

    protected void registerListeners() {
        this.commandStackListener = this.createCommandStackListener();
        if (this.commandStackListener != null) {
            this.domain.getCommandStack().addCommandStackListener(this.commandStackListener);
        }
        this.textDocumentListener = this.createTextDocumentListener();
        if (this.textDocumentListener != null) {
            this.textDocument.eAdapters().add((Object)this.textDocumentListener);
        }
        if (this.saveAndDirtyService != null) {
            this.saveAndDirtyService.registerIsaveablePart((ISaveablePart)this);
        }
        IWorkbenchPage page = this.getEditorSite().getPage();
        page.addPartListener(this.partListener);
        this.historyListener = new UndoableTextChangeListener(this.domain, this.getDocumentProvider().getDocument(this.input));
        this.getOperationHistory().addOperationHistoryListener((IOperationHistoryListener)this.historyListener);
    }

    protected void unregisterListeners() {
        this.unregisterSashWindowsContainerListener();
        this.getOperationHistory().removeOperationHistoryListener((IOperationHistoryListener)this.historyListener);
        IWorkbenchPage page = this.getEditorSite().getPage();
        page.removePartListener(this.partListener);
        if (this.commandStackListener != null) {
            this.domain.getCommandStack().removeCommandStackListener(this.commandStackListener);
        }
        if (this.textDocumentListener != null) {
            this.textDocument.eAdapters().remove((Object)this.textDocumentListener);
        }
        if (this.saveAndDirtyService != null) {
            this.saveAndDirtyService.removeIsaveablePart((ISaveablePart)this);
        }
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        Assert.isNotNull((Object)this.registry, (String)"The service registry must be set calling the method configureXTextEditor");
        try {
            this.domain = ServiceUtils.getInstance().getTransactionalEditingDomain((Object)this.registry);
        }
        catch (ServiceException e) {
            Activator.log.error("We can't find the editing domain", (Throwable)e);
        }
        super.init(site, input);
        this.registerListeners();
    }

    public void dispose() {
        this.unregisterListeners();
        this.saveTextInEditedModel();
        super.dispose();
    }

    protected void doSetInput(IEditorInput input) throws CoreException {
        if (this.textDocument != null && this.textDocument.eResource() != null) {
            super.doSetInput((IEditorInput)this.input);
            if (this.historyListener != null) {
                this.historyListener.updateXTextDocument(this.getDocumentProvider().getDocument(this.input));
            }
        }
    }

    public void setFocus() {
        IXtextDocument document;
        PapyrusXTextDocumentProvider provider = this.getDocumentProvider();
        if (provider != null && (document = provider.getDocument(this.getEditorInput())) instanceof XtextDocument) {
            ((XtextDocument)document).checkAndUpdateAnnotations();
        }
        this.registerSashWindowsContainerListener();
        super.setFocus();
    }

    protected final void registerSashWindowsContainerListener() {
        if (this.sashWindowsContainer == null) {
            try {
                this.sashWindowsContainer = (ISashWindowsContainer)this.registry.getService(ISashWindowsContainer.class);
                this.sashWindowsContainerListener = new SaveTextOnFocusLostPageLifeCycleEventsListener(this);
                this.sashWindowsContainer.addPageChangedListener((IPageChangedListener)this.sashWindowsContainerListener);
            }
            catch (ServiceException e) {
                Activator.log.warn(NLS.bind((String)"The service {0} is not yet initialized. We will retry at the next focus change.", ISashWindowsContainer.class));
            }
        }
    }

    protected final void unregisterSashWindowsContainerListener() {
        if (this.sashWindowsContainer == null && this.sashWindowsContainerListener != null) {
            this.sashWindowsContainer.removePageChangedListener((IPageChangedListener)this.sashWindowsContainerListener);
        }
        this.sashWindowsContainer = null;
        this.sashWindowsContainerListener = null;
    }

    protected void createUndoRedoActions() {
    }

    private IOperationHistory getOperationHistory() {
        return OperationHistoryFactory.getOperationHistory();
    }

    public PapyrusXTextDocumentProvider getDocumentProvider() {
        return (PapyrusXTextDocumentProvider)super.getDocumentProvider();
    }

    protected CommandStackListener createCommandStackListener() {
        return new CommandStackListener(){

            public void commandStackChanged(EventObject event) {
                NotifyingWorkspaceCommandStack stack;
                Command cmd;
                Object source = event.getSource();
                if (source instanceof NotifyingWorkspaceCommandStack && (cmd = (stack = (NotifyingWorkspaceCommandStack)source).getMostRecentCommand()) instanceof TextUndoRedoCommandWrapper) {
                    return;
                }
                PapyrusXTextEditor.this.updateEditorContent();
            }
        };
    }

    protected Adapter createTextDocumentListener() {
        return new AdapterImpl(){

            public void notifyChanged(Notification msg) {
                if (TextDocumentPackage.eINSTANCE.getTextDocument_SemanticContext().equals(msg.getFeature())) {
                    PapyrusXTextEditor.this.updateEditorContent();
                }
            }
        };
    }
}

