/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.modelrepair.internal.stereotypes;

import com.google.common.base.Predicate;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.uml2.uml.Profile;

public interface IRepairAction {
    public static final IRepairAction NO_OP = new IRepairAction(){

        @Override
        public Kind kind() {
            return Kind.NO_OP;
        }

        @Override
        public boolean isNull() {
            return false;
        }

        @Override
        public String getLabel() {
            return this.kind().displayName();
        }

        @Override
        public boolean repair(Resource resource, EPackage profileDefinition, Collection<? extends EObject> stereotypeApplications, DiagnosticChain diagnostics, IProgressMonitor monitor) {
            return true;
        }
    };
    public static final IRepairAction NULL = new IRepairAction(){

        @Override
        public Kind kind() {
            return null;
        }

        @Override
        public boolean isNull() {
            return true;
        }

        @Override
        public String getLabel() {
            return "null action";
        }

        @Override
        public boolean repair(Resource resource, EPackage profileDefinition, Collection<? extends EObject> stereotypeApplications, DiagnosticChain diagnostics, IProgressMonitor monitor) {
            throw new UnsupportedOperationException("null repair action");
        }
    };
    public static final Predicate<IRepairAction> NOT_NULL = new Predicate<IRepairAction>(){

        public boolean apply(IRepairAction input) {
            return input != null && !input.isNull();
        }
    };

    public Kind kind();

    public boolean isNull();

    public String getLabel();

    public boolean repair(Resource var1, EPackage var2, Collection<? extends EObject> var3, DiagnosticChain var4, IProgressMonitor var5);

    public static interface IApplyProfileAction {
        public Profile getAppliedProfile();

        public void setPreviousAppliedProfile(Profile var1);
    }

    public static enum Kind {
        NO_OP("Postpone"),
        APPLY_LATEST_PROFILE_DEFINITION("Migrate Profile"),
        CREATE_MARKERS("Create Markers"),
        DELETE("Delete Stereotypes");

        private final String displayName;

        private Kind(String displayName) {
            this.displayName = displayName;
        }

        public String displayName() {
            return this.displayName;
        }
    }
}

