/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.types.ui.properties.widgets;

import java.util.ArrayList;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.papyrus.infra.ui.emf.providers.EMFLabelProvider;
import org.eclipse.papyrus.infra.widgets.Activator;
import org.eclipse.papyrus.infra.widgets.editors.StringEditor;
import org.eclipse.papyrus.infra.widgets.editors.TreeSelectorDialog;
import org.eclipse.papyrus.infra.widgets.providers.FilteredContentProvider;
import org.eclipse.papyrus.uml.diagram.common.parser.PropertyLabelParser;
import org.eclipse.papyrus.uml.types.ui.properties.messages.Messages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;

public class FeatureToSetNameValueEditor
extends StringEditor {
    private static final String BROWSE_ICON = "/icons/browse_12x12.gif";
    private Button button = null;
    private Stereotype sourceStereotype;

    public FeatureToSetNameValueEditor(Composite parent, int style) {
        super(parent, style);
        ++((GridLayout)this.getLayout()).numColumns;
        this.button = factory.createButton((Composite)this, null, 8);
        this.button.setImage(Activator.getDefault().getImage(BROWSE_ICON));
        this.button.setToolTipText(Messages.StereotypeAttributesNameValueEditor_ButtonTooltip);
        this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FeatureToSetNameValueEditor.this.handleManageBrowseButtonPressed();
            }
        });
    }

    protected void handleManageBrowseButtonPressed() {
        TreeSelectorDialog dialog = new TreeSelectorDialog(this.getParent().getShell());
        dialog.setContentProvider((ITreeContentProvider)new StereotypeAttributesContentProvider());
        dialog.setLabelProvider((ILabelProvider)new StereotypeAttributesStyledLabelProvider());
        dialog.setTitle(Messages.StereotypeAttributesNameValueEditor_DialogTitile);
        dialog.setMessage(Messages.StereotypeAttributesNameValueEditor_DialogMessage);
        dialog.setInput((Object)this.sourceStereotype);
        if (dialog.open() == 0) {
            Object[] values = dialog.getResult();
            if (1 != values.length) {
                Status status = new Status(4, "org.eclipse.papyrus.infra.widgets", "");
                this.updateStatus((IStatus)status);
            } else if (values[0] instanceof Property) {
                this.setValue(((Property)values[0]).getName());
                this.notifyChange();
            }
        }
    }

    public void setReadOnly(boolean readOnly) {
        super.setReadOnly(readOnly);
        this.button.setEnabled(!readOnly);
    }

    public void setSourceStereotype(Stereotype sourceStereotype) {
        this.sourceStereotype = sourceStereotype;
    }

    protected class StereotypeAttributesContentProvider
    extends FilteredContentProvider {
        protected EClass currentEClass;

        protected StereotypeAttributesContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            ArrayList<Property> attributes = new ArrayList<Property>();
            if (inputElement instanceof Stereotype) {
                Stereotype stereotype = (Stereotype)inputElement;
                EList ownedAttributes = stereotype.getAllAttributes();
                for (Property property : ownedAttributes) {
                    if (property.getName().startsWith("base_")) continue;
                    attributes.add(property);
                }
            }
            return attributes.toArray();
        }

        public boolean isFlat() {
            return true;
        }
    }

    public class StereotypeAttributesLabelProvider
    extends EMFLabelProvider
    implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
        PropertyLabelParser labelParser = new PropertyLabelParser();

        public String getText(Object element) {
            String text = Messages.undefined;
            if (element instanceof Property) {
                text = this.labelParser.getPrintString((IAdaptable)new EObjectAdapter((EObject)element), 0);
            }
            return text != null ? text : super.getText(element);
        }

        public StyledString getStyledText(Object element) {
            String text = this.getText(element);
            StyledString styledString = new StyledString(text);
            if (element instanceof Property) {
                int offset = ((Property)element).getName().length();
                styledString.setStyle(offset, text.length() - offset, StyledString.QUALIFIER_STYLER);
            }
            return styledString;
        }
    }

    public class StereotypeAttributesStyledLabelProvider
    extends DelegatingStyledCellLabelProvider
    implements ILabelProvider {
        public StereotypeAttributesStyledLabelProvider() {
            super((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new StereotypeAttributesLabelProvider());
        }

        public String getText(Object element) {
            return this.getStyledStringProvider().getStyledText(element).getString();
        }
    }
}

