/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.validation.properties.internal.checkers;

import java.util.Map;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.papyrus.infra.properties.contexts.ContextsPackage;
import org.eclipse.papyrus.infra.properties.contexts.Property;
import org.eclipse.papyrus.infra.properties.environment.PropertyEditorType;
import org.eclipse.papyrus.infra.properties.environment.WidgetType;
import org.eclipse.papyrus.infra.properties.ui.PropertyEditor;
import org.eclipse.papyrus.infra.properties.ui.UiPackage;
import org.eclipse.papyrus.infra.properties.ui.Widget;
import org.eclipse.papyrus.toolsmiths.validation.common.checkers.CustomModelChecker;
import org.eclipse.papyrus.toolsmiths.validation.common.checkers.IPluginChecker2;
import org.eclipse.papyrus.toolsmiths.validation.properties.internal.constants.PropertiesPluginValidationConstants;
import org.eclipse.papyrus.toolsmiths.validation.properties.internal.messages.Messages;
import org.eclipse.papyrus.toolsmiths.validation.properties.internal.util.WidgetTypeHelper;

public class PropertiesUICustomValidator
extends CustomModelChecker.SwitchValidator {
    public PropertiesUICustomValidator(String nsURI) {
        super(nsURI);
    }

    public void validate(PropertyEditor propertyEditor, DiagnosticChain diagnostics, Map<Object, Object> context) {
        PropertyEditorType widgetType = propertyEditor.getWidgetType();
        Property property = propertyEditor.getProperty();
        if (widgetType instanceof PropertyEditorType && !widgetType.eIsProxy() && property != null && !property.eIsProxy()) {
            PropertyEditorType defaultEditorType;
            String message;
            WidgetTypeHelper helper = WidgetTypeHelper.getInstance((Widget)propertyEditor);
            PropertyEditorType editorType = widgetType;
            WidgetType defaultWidgetType = helper.getDefaultWidgetType(property);
            if (helper.isCoreWidgetType((WidgetType)widgetType) && defaultWidgetType instanceof PropertyEditorType && (message = this.getInconsistentTypeMessage(property, propertyEditor, editorType, defaultEditorType = (PropertyEditorType)defaultWidgetType, context)) != null) {
                diagnostics.add(this.createDiagnostic(2, (EObject)propertyEditor, (EStructuralFeature)UiPackage.Literals.PROPERTY_EDITOR__WIDGET_TYPE, message, IPluginChecker2.problem((int)16715848), new IPluginChecker2.MarkerAttribute[]{PropertiesPluginValidationConstants.objectToReference((EObject)defaultWidgetType)}));
            }
        }
    }

    private String getInconsistentTypeMessage(Property property, PropertyEditor editor, PropertyEditorType actualEditorType, PropertyEditorType defaultEditorType, Map<Object, Object> context) {
        if (actualEditorType.getType() != defaultEditorType.getType()) {
            return this.format(Messages.PropertiesUICustomValidator_0, context, new Object[]{property, actualEditorType, this.value(ContextsPackage.Literals.PROPERTY__TYPE, property.getType())});
        }
        if (actualEditorType.getMultiplicity() != defaultEditorType.getMultiplicity()) {
            return this.format(Messages.PropertiesUICustomValidator_1, context, new Object[]{property, actualEditorType, this.value(ContextsPackage.Literals.PROPERTY__MULTIPLICITY, property.getMultiplicity())});
        }
        return null;
    }
}

