/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.junit.utils;

import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;
import org.junit.Assert;

public class HandlerUtils {
    public static final IHandler getActiveHandlerFor(String commandId) {
        return HandlerUtils.getCommand(commandId).getHandler();
    }

    public static final IHandler getRealHandlerFor(String commandId) {
        throw new UnsupportedOperationException();
    }

    public static final Command getCommand(String commandId) {
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getService(ICommandService.class);
        commandService.refreshElements(commandId, null);
        Assert.assertNotNull((String)"CommandService can't be found", (Object)commandService);
        Command cmd = commandService.getCommand(commandId);
        Assert.assertNotNull((String)"Command can't be found", (Object)cmd);
        return cmd;
    }

    public static final void executeCommand(Command cmd) throws Exception {
        IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
        Assert.assertNotNull((String)"Impossible to find handler service", (Object)handlerService);
        ParameterizedCommand parameterizedCommand = new ParameterizedCommand(cmd, null);
        Assert.assertEquals((String)"Command is not executable as expected", (Object)cmd.isEnabled(), (Object)true);
        handlerService.executeCommand(parameterizedCommand, null);
    }
}

