/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.tickupdate;

public interface ITickUpdateHandler {
    public static final ITickUpdateHandler DEFAULT_TICK_UPDATE_HANDLER = new ITickUpdateHandler(){

        @Override
        public boolean isApplicableFor(Object value) {
            return value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long || value instanceof Double || value instanceof Float;
        }

        @Override
        public Object getIncrementedValue(Object currentValue) {
            return this.getIncrementedValue(currentValue, 1.0);
        }

        @Override
        public Object getIncrementedValue(Object currentValue, double incrementSize) {
            if (currentValue instanceof Byte) {
                return (byte)((Byte)currentValue + (byte)Math.abs(incrementSize));
            }
            if (currentValue instanceof Short) {
                return (short)((Short)currentValue + (short)Math.abs(incrementSize));
            }
            if (currentValue instanceof Integer) {
                return (Integer)currentValue + (int)Math.abs(incrementSize);
            }
            if (currentValue instanceof Long) {
                return (Long)currentValue + (long)Math.abs(incrementSize);
            }
            if (currentValue instanceof Double) {
                return (Double)currentValue + Math.abs(incrementSize);
            }
            if (currentValue instanceof Float) {
                return Float.valueOf(((Float)currentValue).floatValue() + (float)Math.abs(incrementSize));
            }
            return currentValue;
        }

        @Override
        public Object getDecrementedValue(Object currentValue) {
            return this.getDecrementedValue(currentValue, 1.0);
        }

        @Override
        public Object getDecrementedValue(Object currentValue, double decrementSize) {
            if (currentValue instanceof Byte) {
                return (byte)((Byte)currentValue - (byte)Math.abs(decrementSize));
            }
            if (currentValue instanceof Short) {
                return (short)((Short)currentValue - (short)Math.abs(decrementSize));
            }
            if (currentValue instanceof Integer) {
                return (Integer)currentValue - (int)Math.abs(decrementSize);
            }
            if (currentValue instanceof Long) {
                return (Long)currentValue - (long)Math.abs(decrementSize);
            }
            if (currentValue instanceof Double) {
                return (Double)currentValue - Math.abs(decrementSize);
            }
            if (currentValue instanceof Float) {
                return Float.valueOf(((Float)currentValue).floatValue() - (float)Math.abs(decrementSize));
            }
            return currentValue;
        }
    };

    public boolean isApplicableFor(Object var1);

    public Object getIncrementedValue(Object var1);

    public Object getIncrementedValue(Object var1, double var2);

    public Object getDecrementedValue(Object var1);

    public Object getDecrementedValue(Object var1, double var2);
}

