/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.validation.architecture.internal.quickfix;

import java.util.function.BiConsumer;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.papyrus.infra.core.architecture.ArchitectureContext;
import org.eclipse.papyrus.infra.core.architecture.ArchitecturePackage;
import org.eclipse.papyrus.infra.types.ElementTypeSetConfiguration;
import org.eclipse.papyrus.infra.types.ElementTypesConfigurationsPackage;
import org.eclipse.papyrus.toolsmiths.validation.architecture.constants.ArchitecturePluginValidationConstants;
import org.eclipse.papyrus.toolsmiths.validation.architecture.internal.messages.Messages;
import org.eclipse.papyrus.toolsmiths.validation.common.quickfix.CommonMarkerResolutionGenerator;
import org.eclipse.papyrus.toolsmiths.validation.common.quickfix.CommonMarkerResolutionUtils;
import org.eclipse.papyrus.toolsmiths.validation.common.quickfix.SimpleMissingExtensionMarkerResolution;
import org.eclipse.papyrus.toolsmiths.validation.common.quickfix.SimpleModelEditMarkerResolution;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.uml2.common.util.UML2Util;

public class ArchitectureMarkerResolutionGenerator
extends CommonMarkerResolutionGenerator {
    public IMarkerResolution[] getResolutions(IMarker marker) {
        if (this.hasCommonResolutions(marker)) {
            return super.getResolutions(marker);
        }
        int problemID = ArchitectureMarkerResolutionGenerator.getProblemID((IMarker)marker);
        switch (problemID) {
            case 16715840: {
                return this.only((IMarkerResolution)new SimpleMissingExtensionMarkerResolution(problemID, Messages.MissingArchitectureExtension_0, Messages.MissingArchitectureExtension_1, "org.eclipse.papyrus.infra.architecture.models", "model", new BiConsumer[]{SimpleMissingExtensionMarkerResolution.optionalAttribute((String)"path", m -> CommonMarkerResolutionUtils.getModelPath((IMarker)m).map(IPath::toPortableString))}));
            }
            case 16715841: {
                return this.only((IMarkerResolution)SimpleModelEditMarkerResolution.create((int)problemID, (String)Messages.MissingRepresentationsAdvice_0, (String)Messages.MissingRepresentationsAdvice_1, ArchitectureContext.class, this::getAddRepresentationsAdviceCommand));
            }
        }
        return this.noResolutions();
    }

    public boolean hasResolutions(IMarker marker) {
        return super.hasResolutions(marker) || this.matchProblemID(marker, 16715840, 16715903);
    }

    private Command getAddRepresentationsAdviceCommand(EditingDomain domain, ArchitectureContext context) {
        ElementTypeSetConfiguration set = (ElementTypeSetConfiguration)UML2Util.load((ResourceSet)domain.getResourceSet(), (URI)ArchitecturePluginValidationConstants.REPRESENTATIONS_ADVICE_URI, (EClass)ElementTypesConfigurationsPackage.Literals.ELEMENT_TYPE_SET_CONFIGURATION);
        return AddCommand.create((EditingDomain)domain, (Object)context, (Object)ArchitecturePackage.Literals.ARCHITECTURE_CONTEXT__ELEMENT_TYPES, (Object)set);
    }
}

