/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sirius.junit.utils.diagram.drop.checker;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.sirius.junit.utils.diagram.creation.semantic.checker.ISemanticRepresentationElementChecker;
import org.eclipse.sirius.viewpoint.DRepresentationElement;
import org.junit.Assert;

public class SemanticDropChecker
implements ISemanticRepresentationElementChecker {
    private final EObject droppedEObject;
    private final EObject semanticContainer;

    public SemanticDropChecker(EObject droppedEObject) {
        this.droppedEObject = droppedEObject;
        this.semanticContainer = this.droppedEObject.eContainer();
    }

    @Override
    public void validateRepresentationElement(DRepresentationElement createdElementRepresentation) {
        EList semanticElements = createdElementRepresentation.getSemanticElements();
        Assert.assertEquals((String)"The created element representation must have 1 associated semantic element", (long)1L, (long)semanticElements.size());
        EObject element = (EObject)semanticElements.get(0);
        Assert.assertTrue((String)"The dropped element is not associated to the created view.", (element == this.droppedEObject ? 1 : 0) != 0);
        Assert.assertTrue((String)"The semantic owner of the dropped element changed.", (this.semanticContainer == element.eContainer() ? 1 : 0) != 0);
    }

    @Override
    public void validateAfterUndo() {
    }

    @Override
    public void validateAfterRedo() {
    }
}

