/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.nattable.config.utils;

import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.painter.cell.ICellPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.decorator.CellPainterDecorator;
import org.eclipse.nebula.widgets.nattable.style.DisplayMode;
import org.eclipse.nebula.widgets.nattable.ui.util.CellEdgeEnum;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.IAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle.StyledElement;
import org.eclipse.papyrus.infra.nattable.painter.CustomImagePainter;
import org.eclipse.papyrus.infra.nattable.painter.CustomizedCellPainter;
import org.eclipse.papyrus.infra.nattable.painter.PapyrusTableCellPainter;
import org.eclipse.papyrus.infra.nattable.utils.StyleUtils;

public class CellEditorConfigurationUtils {
    private CellEditorConfigurationUtils() {
    }

    public static void configureCellPainter(IConfigRegistry configRegistry, Object axis, String configLabel) {
        CellEditorConfigurationUtils.configureCellPainter(configRegistry, axis, configLabel, false, false);
    }

    public static void configureCellPainter(IConfigRegistry configRegistry, Object axis, String configLabel, boolean wrapText, boolean autoResizeCellHeight) {
        if (configRegistry != null && axis instanceof IAxis) {
            boolean displayListOnRowsFlag = StyleUtils.getBooleanNamedStyleValue((StyledElement)((IAxis)axis), (String)"displayListOnSeparatedRows", (boolean)false);
            if (displayListOnRowsFlag) {
                PapyrusTableCellPainter tableCellPainter = new PapyrusTableCellPainter((ICellPainter)new CellPainterDecorator((ICellPainter)new CustomizedCellPainter(wrapText, autoResizeCellHeight), CellEdgeEnum.LEFT, (ICellPainter)new CustomImagePainter()));
                if (autoResizeCellHeight) {
                    tableCellPainter.setFixedSubCellHeight(-1);
                }
                configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, (Object)tableCellPainter, DisplayMode.NORMAL, configLabel);
            } else {
                configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, (Object)new CustomizedCellPainter(wrapText, autoResizeCellHeight), DisplayMode.NORMAL, configLabel);
            }
        } else {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, (Object)new CustomizedCellPainter(wrapText, autoResizeCellHeight), DisplayMode.NORMAL, configLabel);
        }
    }
}

