/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.customization.nattableconfiguration.wizards;

import org.eclipse.core.internal.resources.Resource;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.papyrus.customization.nattableconfiguration.Activator;
import org.eclipse.papyrus.customization.nattableconfiguration.pages.NattableConfigurationFileCreationPage;
import org.eclipse.papyrus.customization.nattableconfiguration.wizards.EditTableConfigurationWizard;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.NattableaxisconfigurationFactory;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.TableHeaderAxisConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableconfiguration.NattableconfigurationFactory;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableconfiguration.TableConfiguration;
import org.eclipse.ui.IWorkbench;

public class CreateAndEditTableConfigurationWizard
extends EditTableConfigurationWizard {
    private NattableConfigurationFileCreationPage page = null;
    private Object firstSelectedElement;

    @Override
    protected void addEditNattableConfigurationPage() {
        this.page = new NattableConfigurationFileCreationPage(this.helper);
        this.addPage((IWizardPage)this.page);
    }

    @Override
    protected TableConfiguration getEditedTableConfiguration(org.eclipse.emf.ecore.resource.Resource resource) {
        TableConfiguration configuration = NattableconfigurationFactory.eINSTANCE.createTableConfiguration();
        TableHeaderAxisConfiguration rowHeaderAxisConfiguration = NattableaxisconfigurationFactory.eINSTANCE.createTableHeaderAxisConfiguration();
        TableHeaderAxisConfiguration columnHeaderAxisConfiguration = NattableaxisconfigurationFactory.eINSTANCE.createTableHeaderAxisConfiguration();
        configuration.setColumnHeaderAxisConfiguration(columnHeaderAxisConfiguration);
        configuration.setRowHeaderAxisConfiguration(rowHeaderAxisConfiguration);
        return configuration;
    }

    @Override
    public void init(IWorkbench workbench, IStructuredSelection selection) {
        super.init(workbench, selection);
        if (selection instanceof StructuredSelection) {
            this.firstSelectedElement = selection.getFirstElement();
        }
    }

    @Override
    public boolean performFinish() {
        StringBuilder nattableConfigurationFileName = new StringBuilder(this.page.getNattableConfigurationFileName());
        if (!nattableConfigurationFileName.toString().contains(".") || !"nattableconfiguration".equals(nattableConfigurationFileName.toString().substring(nattableConfigurationFileName.lastIndexOf(".") + 1))) {
            nattableConfigurationFileName.append(".");
            nattableConfigurationFileName.append("nattableconfiguration");
        }
        ResourceSetImpl set = new ResourceSetImpl();
        StringBuilder nattableConfFileURI = new StringBuilder();
        nattableConfFileURI.append(this.getPathForTableConfigurationCreation());
        nattableConfFileURI.append((CharSequence)nattableConfigurationFileName);
        this.initialResource = set.createResource(URI.createFileURI((String)nattableConfFileURI.toString()));
        boolean result = super.performFinish();
        this.refreshProject();
        return result;
    }

    protected String getPathForTableConfigurationCreation() {
        String location = null;
        if (this.firstSelectedElement instanceof IFolder) {
            String projectLocation = ((IFolder)this.firstSelectedElement).getLocation().toString();
            StringBuilder builder = new StringBuilder(projectLocation);
            builder.append("/");
            location = builder.toString();
        } else if (this.firstSelectedElement instanceof IResource) {
            String projectLocation = this.getProjectLocation();
            StringBuilder builder = new StringBuilder(projectLocation);
            builder.append("/configs/");
            location = builder.toString();
        }
        return location;
    }

    protected final void refreshProject() {
        try {
            this.getProject().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            Activator.log.error((Throwable)e);
        }
    }

    protected IProject getProject() {
        IProject project = null;
        if (this.firstSelectedElement instanceof Resource) {
            project = ((Resource)this.firstSelectedElement).getProject();
        }
        return project;
    }

    protected String getProjectLocation() {
        IProject project = this.getProject();
        if (project != null) {
            return project.getLocation().toString();
        }
        return null;
    }
}

