/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.validation.common.internal.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.papyrus.toolsmiths.validation.common.checkers.IPluginChecker2;
import org.eclipse.papyrus.toolsmiths.validation.common.internal.utils.PluginErrorReporter;
import org.eclipse.pde.internal.core.builders.IncrementalErrorReporter;

public class DiagnosticErrorReporter
extends IncrementalErrorReporter {
    static final String SOURCE_ID = "source_id";
    private final Collection<IncrementalErrorReporter.VirtualMarker> fReportedMarkers = new ArrayList<IncrementalErrorReporter.VirtualMarker>();
    private int fErrorCount;
    private final IResource file;
    private final String markerType;
    private final DiagnosticChain diagnostics;

    public DiagnosticErrorReporter(IResource file, String markerType, DiagnosticChain diagnostics) {
        super(file);
        this.file = file;
        this.markerType = markerType;
        this.diagnostics = diagnostics;
    }

    public IncrementalErrorReporter.VirtualMarker addMarker(String message, int lineNumber, int severity, int problemID, String category) {
        if (lineNumber < 0) {
            lineNumber = 1;
        }
        if (severity == 2) {
            ++this.fErrorCount;
        }
        IncrementalErrorReporter.VirtualMarker marker = new IncrementalErrorReporter.VirtualMarker();
        marker.setAttribute("problemId", (Object)problemID);
        marker.setAttribute("categoryId", (Object)category);
        marker.setAttribute("message", (Object)message);
        marker.setAttribute("severity", (Object)severity);
        marker.setAttribute("lineNumber", (Object)lineNumber);
        this.fReportedMarkers.add(marker);
        return marker;
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Enabled aggressive block sorting
     */
    public void applyMarkers() {
        for (IncrementalErrorReporter.VirtualMarker reportedMarker : this.fReportedMarkers) {
            Map attributes = reportedMarker.getAttributes();
            ArrayList<Object> data = new ArrayList<Object>();
            data.add(this.file);
            data.add(IPluginChecker2.markerType(this.markerType));
            for (Map.Entry next : attributes.entrySet()) {
                switch ((String)next.getKey()) {
                    default: {
                        data.add(new IPluginChecker2.MarkerAttribute((String)next.getKey(), next.getValue()));
                        break;
                    }
                    case "message": 
                    case "severity": 
                }
            }
            BasicDiagnostic diagnostic = new BasicDiagnostic(DiagnosticErrorReporter.toDiagnosticSeverity(attributes.getOrDefault("severity", 2)), attributes.getOrDefault(SOURCE_ID, PluginErrorReporter.class.getName()), 0, (String)attributes.get("message"), data.toArray());
            this.diagnostics.add((Diagnostic)diagnostic);
        }
    }

    private static int toDiagnosticSeverity(int markerSeverity) {
        switch (markerSeverity) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
        }
        return 4;
    }

    public int getErrorCount() {
        return this.fErrorCount;
    }
}

