/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.urischeme.internal.registration;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.DirectoryStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.urischeme.IOperatingSystemRegistration;
import org.eclipse.urischeme.IScheme;
import org.eclipse.urischeme.ISchemeInformation;
import org.eclipse.urischeme.internal.registration.FileProvider;
import org.eclipse.urischeme.internal.registration.IFileProvider;
import org.eclipse.urischeme.internal.registration.IRegistryWriter;
import org.eclipse.urischeme.internal.registration.RegistryWriter;
import org.eclipse.urischeme.internal.registration.SchemeInformation;

public class RegistrationWindows
implements IOperatingSystemRegistration {
    IRegistryWriter registryWriter;
    IFileProvider fileProvider;

    public RegistrationWindows() {
        this(new RegistryWriter(), new FileProvider());
    }

    public RegistrationWindows(IRegistryWriter registryWriter, IFileProvider fileProvider) {
        this.registryWriter = registryWriter;
        this.fileProvider = fileProvider;
    }

    @Override
    public void handleSchemes(Collection<IScheme> toAdd, Collection<IScheme> toRemove) throws Exception {
        String eclipseLauncher = this.getEclipseLauncher();
        if (eclipseLauncher != null) {
            for (IScheme scheme : toAdd) {
                this.registryWriter.addScheme(scheme.getName(), eclipseLauncher);
            }
            for (IScheme scheme : toRemove) {
                this.registryWriter.removeScheme(scheme.getName());
            }
        }
    }

    @Override
    public List<ISchemeInformation> getSchemesInformation(Collection<IScheme> schemes) throws Exception {
        String launcher = this.getEclipseLauncher();
        ArrayList<ISchemeInformation> schemeInformations = new ArrayList<ISchemeInformation>();
        for (IScheme scheme : schemes) {
            SchemeInformation schemeInfo = new SchemeInformation(scheme.getName(), scheme.getDescription());
            String path = this.registryWriter.getRegisteredHandlerPath(schemeInfo.getName());
            if (path == null) {
                path = "";
            }
            schemeInfo.setHandled(path.equals(launcher));
            schemeInfo.setHandlerLocation(path);
            schemeInformations.add(schemeInfo);
        }
        return schemeInformations;
    }

    @Override
    public String getEclipseLauncher() {
        String launcher = this.getLauncherFromLauncherProperty();
        if (launcher != null) {
            return launcher;
        }
        return this.getLauncherFromHomeLocation();
    }

    @Override
    public boolean canOverwriteOtherApplicationsRegistration() {
        return true;
    }

    private String getLauncherFromLauncherProperty() {
        String launcher = System.getProperty("eclipse.launcher");
        if (launcher != null && this.fileProvider.fileExists(launcher) && !this.fileProvider.isDirectory(launcher)) {
            return launcher;
        }
        return null;
    }

    private String getLauncherFromHomeLocation() {
        URL homeLocationUrl;
        String homeLocation = System.getProperty("eclipse.home.location");
        Assert.isNotNull((Object)homeLocation, (String)"home location must not be null");
        try {
            homeLocationUrl = new URL(homeLocation);
        }
        catch (MalformedURLException e) {
            return null;
        }
        if (!"file".equals(homeLocationUrl.getProtocol())) {
            return null;
        }
        String directory = this.fileProvider.getFilePath(homeLocationUrl);
        if (!this.fileProvider.fileExists(directory) || !this.fileProvider.isDirectory(directory)) {
            return null;
        }
        try {
            Throwable throwable = null;
            Object var5_8 = null;
            try (DirectoryStream<Path> stream = this.fileProvider.newDirectoryStream(directory, "*.exe");){
                Iterator<Path> iterator = stream.iterator();
                if (iterator.hasNext()) {
                    Path path = iterator.next();
                    return path.toString();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
        return null;
    }
}

