/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.ui.workbench.properties;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.ui.views.properties.tabbed.AbstractSectionDescriptor;
import org.eclipse.ui.views.properties.tabbed.ISection;
import org.eclipse.xwt.ui.workbench.properties.XWTSection;

public class XWTSectionDescriptor
extends AbstractSectionDescriptor {
    private String id;
    private String targetTab;
    private String sectionTypeName;
    private List<String> inputTypes;

    public XWTSectionDescriptor(String id, String targetTab, String sectionTypeName) {
        Assert.isNotNull((Object)id, (String)"Section id can not be null");
        Assert.isNotNull((Object)targetTab, (String)"Tab id can not be null");
        Assert.isNotNull((Object)sectionTypeName, (String)"URL for renderering section can not be null");
        this.id = id;
        this.targetTab = targetTab;
        this.sectionTypeName = sectionTypeName;
    }

    public String getId() {
        return this.id;
    }

    public ISection getSectionClass() {
        URL sectionURL = null;
        try {
            Class<?> type = Class.forName(this.sectionTypeName);
            sectionURL = type.getResource(type.getSimpleName() + ".xwt");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return new XWTSection(sectionURL);
    }

    public String getTargetTab() {
        return this.targetTab;
    }

    public List<String> getInputTypes() {
        if (this.inputTypes == null) {
            this.inputTypes = new ArrayList<String>();
        }
        return this.inputTypes;
    }

    public void addInputType(String inputType) {
        this.getInputTypes().add(inputType);
    }
}

