/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.bcoview.compare;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.BitSet;
import org.eclipse.compare.BufferedContent;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.IStructureComparator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.bcoview.asm.DecompiledClass;
import org.eclipse.jdt.bcoview.asm.DecompilerHelper;
import org.eclipse.jdt.bcoview.asm.DecompilerOptions;
import org.eclipse.jdt.bcoview.ui.JdtUtils;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class TypedElement
extends BufferedContent
implements ITypedElement,
IStructureComparator {
    private final String name;
    private String type;
    private final String methodName;
    private final IJavaElement element;
    public static final String TYPE_BYTECODE = "bytecode";
    public static final String TYPE_ASM_IFIER = "java";
    private final BitSet modes;

    public TypedElement(String name, String methodName, String type, IJavaElement element, BitSet modes) {
        this.name = name;
        this.methodName = methodName;
        this.type = type;
        this.element = element;
        this.modes = modes;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    protected void setType(String type) {
        this.type = type;
    }

    public String getElementName() {
        return JdtUtils.getElementName(this.element);
    }

    public Image getImage() {
        return CompareUI.getImage((String)"class");
    }

    public Object[] getChildren() {
        return new TypedElement[0];
    }

    protected InputStream createStream() throws CoreException {
        byte[] classBytes = JdtUtils.readClassBytes(this.element);
        if (classBytes == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.jdt.bcoview", -1, "Can't read bytecode for: " + String.valueOf(this.element), null));
        }
        DecompiledClass decompiledClass = null;
        try {
            decompiledClass = DecompilerHelper.getDecompiledClass(classBytes, new DecompilerOptions(null, this.methodName, this.modes));
        }
        catch (UnsupportedClassVersionError e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.jdt.bcoview", -1, "Error caused by attempt to load class compiled with Java version which is not supported by current JVM", (Throwable)e));
        }
        byte[] bytes = decompiledClass.getText().getBytes(Charset.forName("UTF-8"));
        Display.getDefault().syncExec(() -> this.setContent(bytes));
        return new ByteArrayInputStream(bytes);
    }

    public void setMode(int mode, boolean value) {
        this.modes.set(mode, value);
        this.discardBuffer();
    }
}

