/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Viewport;

public final class ViewportUtilities {
    private ViewportUtilities() {
    }

    public static List<Viewport> getEnclosingViewportsPath(IFigure figure) {
        Viewport nearestEnclosingViewport = ViewportUtilities.getNearestEnclosingViewport(figure);
        if (nearestEnclosingViewport == null) {
            return Collections.emptyList();
        }
        Viewport rootViewport = ViewportUtilities.getRootViewport(figure);
        return ViewportUtilities.getViewportsPath(nearestEnclosingViewport, rootViewport, true);
    }

    public static List<Viewport> getViewportsPath(Viewport leafViewport, Viewport rootViewport) {
        return ViewportUtilities.getViewportsPath(leafViewport, rootViewport, true);
    }

    public static List<Viewport> getViewportsPath(Viewport leafViewport, Viewport rootViewport, boolean includeRootViewport) {
        if (leafViewport == null || rootViewport == null) {
            return Collections.emptyList();
        }
        ArrayList<Viewport> nestedViewports = new ArrayList<Viewport>();
        Viewport currentViewport = leafViewport;
        do {
            nestedViewports.add(currentViewport);
        } while ((currentViewport = ViewportUtilities.getNearestEnclosingViewport(currentViewport)) != null && currentViewport != rootViewport);
        if (currentViewport != null) {
            if (includeRootViewport) {
                nestedViewports.add(currentViewport);
            }
            return nestedViewports;
        }
        return Collections.emptyList();
    }

    public static Viewport getNearestCommonViewport(IFigure firstFigure, IFigure secondFigure) {
        return ViewportUtilities.getNearestViewport(FigureUtilities.findCommonAncestor(firstFigure, secondFigure));
    }

    public static Viewport getRootViewport(IFigure figure) {
        Viewport currentViewport = ViewportUtilities.getNearestViewport(figure);
        while (ViewportUtilities.getNearestEnclosingViewport(currentViewport) != null) {
            currentViewport = ViewportUtilities.getNearestEnclosingViewport(currentViewport);
        }
        return currentViewport;
    }

    /*
     * WARNING - void declaration
     */
    public static Viewport getNearestViewport(IFigure figure) {
        if (figure == null) {
            return null;
        }
        IFigure iFigure = figure;
        if (iFigure instanceof Viewport) {
            void viewPort;
            Viewport viewport = (Viewport)iFigure;
            Viewport cfr_ignored_0 = (Viewport)iFigure;
            return viewPort;
        }
        return ViewportUtilities.getNearestEnclosingViewport(figure);
    }

    /*
     * WARNING - void declaration
     */
    public static Viewport getNearestEnclosingViewport(IFigure figure) {
        if (figure == null) {
            return null;
        }
        Viewport viewport = null;
        IFigure currentFigure = figure;
        while (currentFigure.getParent() != null) {
            IFigure iFigure = currentFigure.getParent();
            if (iFigure instanceof Viewport) {
                void vp;
                Viewport viewport2 = (Viewport)iFigure;
                Viewport cfr_ignored_0 = (Viewport)iFigure;
                viewport = vp;
                break;
            }
            currentFigure = currentFigure.getParent();
        }
        return viewport;
    }
}

