/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.common.editpolicies;

import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.commands.CommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GroupEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.CreationEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.diagram.ui.requests.EditCommandRequestWrapper;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.uml2.diagram.common.editpolicies.MoveRequestWithParentInfo;
import org.eclipse.uml2.diagram.common.editpolicies.MoveViewCommand;
import org.eclipse.uml2.diagram.common.genapi.IVisualIDRegistry;

public class CreationEditPolicyWithCustomReparent
extends CreationEditPolicy {
    private final IVisualIDRegistry myVisualIdRegistry;

    public CreationEditPolicyWithCustomReparent(IVisualIDRegistry visualIdRegistry) {
        this.myVisualIdRegistry = visualIdRegistry;
    }

    public Command getCommand(Request request) {
        return super.getCommand(request);
    }

    protected Command getReparentCommand(ChangeBoundsRequest request) {
        return super.getReparentCommand(request);
    }

    protected ICommand getReparentCommand(IGraphicalEditPart gep) {
        CompositeCommand cc = new CompositeCommand(DiagramUIMessages.AddCommand_Label);
        View container = (View)this.getHost().getModel();
        EObject context = ViewUtil.resolveSemanticElement((View)container);
        View view = (View)gep.getModel();
        EObject element = ViewUtil.resolveSemanticElement((View)view);
        TransactionalEditingDomain editingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
        if (element != null) {
            EObject actualContainer = this.getSemanticContainer(gep);
            MoveRequestWithParentInfo request = new MoveRequestWithParentInfo(editingDomain, context, element);
            request.registerActualContainer(element, actualContainer);
            Command moveSemanticCmd = this.getHost().getCommand((Request)new EditCommandRequestWrapper((IEditCommandRequest)request));
            if (moveSemanticCmd == null) {
                return UnexecutableCommand.INSTANCE;
            }
            cc.compose((IUndoableOperation)new CommandProxy(moveSemanticCmd));
        }
        cc.compose((IUndoableOperation)this.getReparentViewCommand(gep));
        return cc;
    }

    protected ICommand getReparentGroupCommand(GroupEditPart groupEP) {
        CompositeCommand cc = new CompositeCommand(DiagramUIMessages.AddCommand_Label);
        View container = (View)this.getHost().getModel();
        EObject context = ViewUtil.resolveSemanticElement((View)container);
        EObject groupSemanticParent = this.getSemanticContainer((IGraphicalEditPart)groupEP);
        TransactionalEditingDomain editingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
        for (IGraphicalEditPart childEP : groupEP.getShapeChildren()) {
            EObject element = ViewUtil.resolveSemanticElement((View)((View)childEP.getModel()));
            if (element == null) continue;
            MoveRequestWithParentInfo request = new MoveRequestWithParentInfo(editingDomain, context, element);
            request.registerActualContainer(element, groupSemanticParent);
            Command moveSemanticCmd = this.getHost().getCommand((Request)new EditCommandRequestWrapper((IEditCommandRequest)request));
            if (moveSemanticCmd == null) {
                return UnexecutableCommand.INSTANCE;
            }
            cc.compose((IUndoableOperation)new CommandProxy(moveSemanticCmd));
        }
        cc.compose((IUndoableOperation)this.getReparentViewCommand((IGraphicalEditPart)groupEP));
        return cc;
    }

    private EObject getSemanticContainer(IGraphicalEditPart gep) {
        IGraphicalEditPart parentEP = (IGraphicalEditPart)gep.getParent();
        if (parentEP == null) {
            return null;
        }
        View view = parentEP.getPrimaryView();
        if (view == null) {
            return null;
        }
        return ViewUtil.resolveSemanticElement((View)view);
    }

    protected ICommand getReparentViewCommand(IGraphicalEditPart gep) {
        View container = (View)this.getHost().getModel();
        View view = (View)gep.getModel();
        MoveViewCommand result = new MoveViewCommand(gep.getEditingDomain(), (IAdaptable)new EObjectAdapter((EObject)container), (IAdaptable)new EObjectAdapter((EObject)view), this.getHostImpl().getDiagramPreferencesHint());
        result.setVisualIDRegistry(this.myVisualIdRegistry);
        return result;
    }

    private IGraphicalEditPart getHostImpl() {
        return (IGraphicalEditPart)this.getHost();
    }
}

