/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.csd.edit.parts;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.BorderLayout;
import org.eclipse.draw2d.Ellipse;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.LayoutEditPolicy;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.diagram.core.listener.DiagramEventBroker;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.DragDropEditPolicy;
import org.eclipse.gmf.runtime.draw2d.ui.figures.ConstrainedToolbarLayout;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.uml2.diagram.common.draw2d.DefaultSizeOvalAnchorableFigure;
import org.eclipse.uml2.diagram.common.draw2d.OneLineDashedBorder;
import org.eclipse.uml2.diagram.common.draw2d.SplitEllipseLayout;
import org.eclipse.uml2.diagram.common.editparts.PrimaryShapeEditPart;
import org.eclipse.uml2.diagram.common.editpolicies.CreationEditPolicyWithCustomReparent;
import org.eclipse.uml2.diagram.common.editpolicies.UpdateDescriptionEditPolicy;
import org.eclipse.uml2.diagram.common.genapi.IUpdaterLinkDescriptor;
import org.eclipse.uml2.diagram.common.genapi.IUpdaterNodeDescriptor;
import org.eclipse.uml2.diagram.csd.edit.parts.CollaborationContentsEditPart;
import org.eclipse.uml2.diagram.csd.edit.parts.CollaborationNameEditPart;
import org.eclipse.uml2.diagram.csd.edit.policies.CollaborationCanonicalEditPolicy;
import org.eclipse.uml2.diagram.csd.edit.policies.CollaborationItemSemanticEditPolicy;
import org.eclipse.uml2.diagram.csd.edit.policies.OpenDiagramEditPolicy;
import org.eclipse.uml2.diagram.csd.part.UMLDiagramUpdateCommand;
import org.eclipse.uml2.diagram.csd.part.UMLDiagramUpdater;
import org.eclipse.uml2.diagram.csd.part.UMLVisualIDRegistry;
import org.eclipse.uml2.uml.InterfaceRealization;
import org.eclipse.uml2.uml.UMLPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollaborationEditPart
extends ShapeNodeEditPart
implements PrimaryShapeEditPart {
    public static final int VISUAL_ID = 2005;
    protected IFigure contentPane;
    protected IFigure primaryShape;
    private LinkTargetListener myLinkTargetListener;

    public CollaborationEditPart(View view) {
        super(view);
    }

    protected void createDefaultEditPolicies() {
        if (UMLVisualIDRegistry.isShortcutDescendant(this.getNotationView())) {
            this.installEditPolicy(UpdateDescriptionEditPolicy.ROLE, (EditPolicy)new UpdateDescriptionEditPolicy(UMLDiagramUpdater.TYPED_ADAPTER, true));
        }
        this.installEditPolicy("CreationPolicy", (EditPolicy)new CreationEditPolicyWithCustomReparent(UMLVisualIDRegistry.TYPED_ADAPTER));
        super.createDefaultEditPolicies();
        this.installEditPolicy("SemanticPolicy", (EditPolicy)new CollaborationItemSemanticEditPolicy());
        this.installEditPolicy("DragDropPolicy", (EditPolicy)new DragDropEditPolicy());
        this.installEditPolicy("Canonical", (EditPolicy)new CollaborationCanonicalEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)this.createLayoutEditPolicy());
        this.installEditPolicy("OpenPolicy", (EditPolicy)new OpenDiagramEditPolicy());
    }

    protected LayoutEditPolicy createLayoutEditPolicy() {
        LayoutEditPolicy lep = new LayoutEditPolicy(){

            protected EditPolicy createChildEditPolicy(EditPart child) {
                EditPolicy result = child.getEditPolicy((Object)"PrimaryDrag Policy");
                if (result == null) {
                    result = new NonResizableEditPolicy();
                }
                return result;
            }

            protected Command getMoveChildrenCommand(Request request) {
                return null;
            }

            protected Command getCreateCommand(CreateRequest request) {
                return null;
            }
        };
        return lep;
    }

    protected IFigure createNodeShape() {
        CollaborationFigure figure = new CollaborationFigure();
        this.primaryShape = figure;
        return this.primaryShape;
    }

    public CollaborationFigure getPrimaryShape() {
        return (CollaborationFigure)this.primaryShape;
    }

    protected boolean addFixedChild(EditPart childEditPart) {
        if (childEditPart instanceof CollaborationNameEditPart) {
            ((CollaborationNameEditPart)childEditPart).setLabel(this.getPrimaryShape().getFigureCollaborationFigure_name());
            return true;
        }
        if (childEditPart instanceof CollaborationContentsEditPart) {
            RectangleFigure pane = this.getPrimaryShape().getFigureCollaborationFigure_contents();
            this.setupContentPane((IFigure)pane);
            pane.add(((CollaborationContentsEditPart)childEditPart).getFigure());
            return true;
        }
        return false;
    }

    protected boolean removeFixedChild(EditPart childEditPart) {
        if (childEditPart instanceof CollaborationContentsEditPart) {
            RectangleFigure pane = this.getPrimaryShape().getFigureCollaborationFigure_contents();
            pane.remove(((CollaborationContentsEditPart)childEditPart).getFigure());
            return true;
        }
        return false;
    }

    protected void addChildVisual(EditPart childEditPart, int index) {
        if (this.addFixedChild(childEditPart)) {
            return;
        }
        super.addChildVisual(childEditPart, -1);
    }

    protected void removeChildVisual(EditPart childEditPart) {
        if (this.removeFixedChild(childEditPart)) {
            return;
        }
        super.removeChildVisual(childEditPart);
    }

    protected IFigure getContentPaneFor(IGraphicalEditPart editPart) {
        if (editPart instanceof CollaborationContentsEditPart) {
            return this.getPrimaryShape().getFigureCollaborationFigure_contents();
        }
        return super.getContentPaneFor(editPart);
    }

    protected NodeFigure createNodePlate() {
        DefaultSizeOvalAnchorableFigure result = new DefaultSizeOvalAnchorableFigure(this.getMapMode().DPtoLP(200), this.getMapMode().DPtoLP(120));
        return result;
    }

    protected NodeFigure createNodeFigure() {
        NodeFigure figure = this.createNodePlate();
        figure.setLayoutManager((LayoutManager)new StackLayout());
        IFigure shape = this.createNodeShape();
        figure.add(shape);
        this.contentPane = this.setupContentPane(shape);
        return figure;
    }

    protected IFigure setupContentPane(IFigure nodeShape) {
        if (nodeShape.getLayoutManager() == null) {
            ConstrainedToolbarLayout layout = new ConstrainedToolbarLayout();
            layout.setSpacing(this.getMapMode().DPtoLP(5));
            nodeShape.setLayoutManager((LayoutManager)layout);
        }
        return nodeShape;
    }

    public IFigure getContentPane() {
        if (this.contentPane != null) {
            return this.contentPane;
        }
        return super.getContentPane();
    }

    public EditPart getPrimaryChildEditPart() {
        return this.getChildBySemanticHint(UMLVisualIDRegistry.getType(5009));
    }

    protected void handleNotificationEvent(Notification event) {
        if (event.getNotifier() == this.getModel() && EcorePackage.eINSTANCE.getEModelElement_EAnnotations().equals(event.getFeature())) {
            this.handleMajorSemanticChange();
        } else {
            super.handleNotificationEvent(event);
        }
        this.handleTypeLinkModification(event);
    }

    private DiagramEventBroker getDiagramEventBroker() {
        TransactionalEditingDomain theEditingDomain = this.getEditingDomain();
        if (theEditingDomain != null) {
            return DiagramEventBroker.getInstance((TransactionalEditingDomain)theEditingDomain);
        }
        return null;
    }

    private LinkTargetListener getLinkTargetListener() {
        if (this.myLinkTargetListener == null) {
            this.myLinkTargetListener = new LinkTargetListener();
        }
        return this.myLinkTargetListener;
    }

    protected void addSemanticListeners() {
        super.addSemanticListeners();
        for (IUpdaterNodeDescriptor iUpdaterNodeDescriptor : this.getCollaboration_2005ContainedLinks()) {
            EObject nextLink = iUpdaterNodeDescriptor.getModelElement();
            if (nextLink == null) continue;
            switch (iUpdaterNodeDescriptor.getVisualID()) {
                case 4007: {
                    this.getLinkTargetListener().addReferenceListener(nextLink, (EStructuralFeature)UMLPackage.eINSTANCE.getInterfaceRealization_Contract());
                    break;
                }
            }
        }
    }

    private List<IUpdaterLinkDescriptor> getCollaboration_2005ContainedLinks() {
        return UMLDiagramUpdater.getCollaboration_2005ContainedLinks(this.getNotationView());
    }

    protected void removeSemanticListeners() {
        super.removeSemanticListeners();
        this.getLinkTargetListener().dispose();
    }

    private void handleTypeLinkModification(Notification event) {
        if (event.getFeature() == UMLPackage.eINSTANCE.getBehavioredClassifier_InterfaceRealization()) {
            block0 : switch (event.getEventType()) {
                case 3: {
                    Object link = event.getNewValue();
                    if (link instanceof InterfaceRealization) {
                        this.getLinkTargetListener().addReferenceListener((EObject)link, (EStructuralFeature)UMLPackage.eINSTANCE.getInterfaceRealization_Contract());
                    }
                    if (!(link instanceof InterfaceRealization)) break;
                    this.refreshDiagram();
                    break;
                }
                case 4: {
                    Object link = event.getOldValue();
                    if (link instanceof InterfaceRealization) {
                        this.getLinkTargetListener().removeReferenceListener((EObject)link, (EStructuralFeature)UMLPackage.eINSTANCE.getInterfaceRealization_Contract());
                    }
                    if (!(link instanceof InterfaceRealization)) break;
                    this.refreshDiagram();
                    break;
                }
                case 5: {
                    List links = (List)event.getNewValue();
                    for (Object link : links) {
                        if (!(link instanceof InterfaceRealization)) continue;
                        this.getLinkTargetListener().addReferenceListener((EObject)link, (EStructuralFeature)UMLPackage.eINSTANCE.getInterfaceRealization_Contract());
                    }
                    for (Object link : links) {
                        if (!(link instanceof InterfaceRealization)) continue;
                        this.refreshDiagram();
                        break block0;
                    }
                    break;
                }
                case 6: {
                    List links = (List)event.getOldValue();
                    for (Object link : links) {
                        if (!(link instanceof InterfaceRealization)) continue;
                        this.getLinkTargetListener().removeReferenceListener((EObject)link, (EStructuralFeature)UMLPackage.eINSTANCE.getInterfaceRealization_Contract());
                    }
                    for (Object link : links) {
                        if (!(link instanceof InterfaceRealization)) continue;
                        this.refreshDiagram();
                        break block0;
                    }
                    break;
                }
            }
        }
    }

    public void refreshDiagram() {
        UMLDiagramUpdateCommand.performCanonicalUpdate(this.getDiagramView().getElement());
    }

    public class CollaborationFigure
    extends Ellipse {
        private int myXMargin;
        private int myYMargin;
        private Label fFigureCollaborationFigure_name;
        private RectangleFigure fFigureCollaborationFigure_contents;
        private boolean myUseLocalCoordinates = false;

        public CollaborationFigure() {
            SplitEllipseLayout layoutThis = new SplitEllipseLayout();
            this.setLayoutManager((LayoutManager)layoutThis);
            this.setLineStyle(2);
            this.createContents();
        }

        private void createContents() {
            this.fFigureCollaborationFigure_name = new Label();
            this.fFigureCollaborationFigure_name.setText("");
            this.add((IFigure)this.fFigureCollaborationFigure_name, BorderLayout.TOP);
            this.fFigureCollaborationFigure_contents = new RectangleFigure();
            this.fFigureCollaborationFigure_contents.setFill(false);
            this.fFigureCollaborationFigure_contents.setOutline(false);
            this.fFigureCollaborationFigure_contents.setBorder(this.createBorder0());
            this.add((IFigure)this.fFigureCollaborationFigure_contents, BorderLayout.CENTER);
        }

        private Border createBorder0() {
            OneLineDashedBorder result = new OneLineDashedBorder();
            return result;
        }

        protected boolean useLocalCoordinates() {
            return this.myUseLocalCoordinates;
        }

        protected void setUseLocalCoordinates(boolean useLocalCoordinates) {
            this.myUseLocalCoordinates = useLocalCoordinates;
        }

        public Label getFigureCollaborationFigure_name() {
            return this.fFigureCollaborationFigure_name;
        }

        public RectangleFigure getFigureCollaborationFigure_contents() {
            return this.fFigureCollaborationFigure_contents;
        }
    }

    private class LinkTargetListener
    implements NotificationListener {
        Map<EObject, Set<EStructuralFeature>> myNotifiers = new HashMap<EObject, Set<EStructuralFeature>>();

        private LinkTargetListener() {
        }

        private void added(EObject link, EStructuralFeature feature) {
            if (!this.myNotifiers.containsKey(link)) {
                this.myNotifiers.put(link, new HashSet());
            }
            this.myNotifiers.get(link).add(feature);
        }

        private void removed(EObject link, EStructuralFeature feature) {
            if (!this.myNotifiers.containsKey(link)) {
                return;
            }
            this.myNotifiers.get(link).remove(feature);
        }

        public void dispose() {
            Set<Map.Entry<EObject, Set<EStructuralFeature>>> entrySet = this.myNotifiers.entrySet();
            for (Map.Entry<EObject, Set<EStructuralFeature>> entry : entrySet) {
                for (EStructuralFeature feature : entry.getValue()) {
                    CollaborationEditPart.this.getDiagramEventBroker().removeNotificationListener(entry.getKey(), (Object)feature, (NotificationListener)this);
                }
            }
        }

        private void removeReferenceListener(EObject link, EStructuralFeature feature) {
            CollaborationEditPart.this.getDiagramEventBroker().removeNotificationListener(link, (Object)feature, (NotificationListener)this);
            this.removed(link, feature);
        }

        private void addReferenceListener(EObject link, EStructuralFeature feature) {
            CollaborationEditPart.this.getDiagramEventBroker().addNotificationListener(link, feature, (NotificationListener)this);
            this.added(link, feature);
        }

        public void notifyChanged(Notification event) {
            if (event.getFeature() == UMLPackage.eINSTANCE.getInterfaceRealization_Contract()) {
                CollaborationEditPart.this.refreshDiagram();
                return;
            }
        }
    }
}

