/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ocl.internal.parser;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ocl.internal.parser.CompatibilityEnvironment;
import org.eclipse.emf.ocl.internal.parser.CompatibilityEnvironmentFactory;
import org.eclipse.emf.ocl.internal.parser.ReverseCompatibilityEnvironment;
import org.eclipse.emf.ocl.internal.parser.ToNewASVisitor;
import org.eclipse.emf.ocl.internal.parser.ToOldASVisitor;
import org.eclipse.emf.ocl.types.TypesPackage;
import org.eclipse.emf.ocl.types.util.Types;
import org.eclipse.emf.ocl.uml.CallOperationAction;
import org.eclipse.emf.ocl.uml.UMLPackage;
import org.eclipse.emf.ocl.utilities.ASTNode;
import org.eclipse.emf.ocl.utilities.TypedASTNode;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.EnvironmentFactory;
import org.eclipse.ocl.ecore.AnyType;
import org.eclipse.ocl.ecore.CollectionType;
import org.eclipse.ocl.ecore.Constraint;
import org.eclipse.ocl.ecore.EcoreEnvironmentFactory;
import org.eclipse.ocl.ecore.ExpressionInOCL;
import org.eclipse.ocl.ecore.SendSignalAction;
import org.eclipse.ocl.expressions.CollectionItem;
import org.eclipse.ocl.expressions.CollectionRange;
import org.eclipse.ocl.types.ElementType;
import org.eclipse.ocl.types.OCLStandardLibrary;
import org.eclipse.ocl.types.TypesPackage;
import org.eclipse.ocl.utilities.PredefinedType;
import org.eclipse.ocl.utilities.TypedElement;
import org.eclipse.ocl.utilities.UtilitiesPackage;
import org.eclipse.ocl.utilities.Visitable;
import org.eclipse.ocl.utilities.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompatibilityUtil {
    private CompatibilityUtil() {
    }

    public static org.eclipse.emf.ocl.parser.Environment getCompatibilityEnvironment(Environment<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, org.eclipse.ocl.ecore.CallOperationAction, SendSignalAction, Constraint, EClass, EObject> environment) {
        if (environment instanceof CompatibilityEnvironment) {
            return ((CompatibilityEnvironment)environment).getOldStyle();
        }
        return new ReverseCompatibilityEnvironment(environment);
    }

    public static Environment<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, org.eclipse.ocl.ecore.CallOperationAction, SendSignalAction, Constraint, EClass, EObject> getCompatibilityEnvironment(Environment<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, org.eclipse.ocl.ecore.CallOperationAction, SendSignalAction, Constraint, EClass, EObject> parent, org.eclipse.emf.ocl.parser.Environment environment, EnvironmentFactory<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, org.eclipse.ocl.ecore.CallOperationAction, SendSignalAction, Constraint, EClass, EObject> factory) {
        return new CompatibilityEnvironment(parent, environment, factory);
    }

    public static EnvironmentFactory<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, org.eclipse.ocl.ecore.CallOperationAction, SendSignalAction, Constraint, EClass, EObject> getCompatibilityFactory(org.eclipse.emf.ocl.parser.EnvironmentFactory factory) {
        return new CompatibilityEnvironmentFactory(factory);
    }

    public static EOperation getOldOperation(EOperation oper, EClassifier oldOwner, EClassifier newOwner) {
        EOperation result = oper;
        if (newOwner instanceof PredefinedType) {
            for (Object o : ((org.eclipse.emf.ocl.utilities.PredefinedType)oldOwner).getOperations()) {
                EOperation next = (EOperation)o;
                if (!next.getName().equals(oper.getName()) || !CompatibilityUtil.matchParms(next, oper)) continue;
                result = next;
                break;
            }
        } else {
            EcoreEnvironmentFactory.INSTANCE.createEnvironment().getOCLStandardLibrary();
            for (Object o : Types.OCL_ANY_TYPE.getOperations()) {
                EOperation next = (EOperation)o;
                if (!next.getName().equals(oper.getName()) || !CompatibilityUtil.matchParms(next, oper)) continue;
                result = next;
                break;
            }
        }
        return result;
    }

    public static EOperation getNewOperation(EOperation oper, EClassifier newOwner, EClassifier oldOwner) {
        EOperation result = oper;
        if (oldOwner instanceof org.eclipse.emf.ocl.utilities.PredefinedType) {
            for (EOperation next : ((PredefinedType)newOwner).oclOperations()) {
                if (!next.getName().equals(oper.getName()) || !CompatibilityUtil.matchParms(next, oper)) continue;
                result = next;
                break;
            }
        } else {
            OCLStandardLibrary stdlib = EcoreEnvironmentFactory.INSTANCE.createEnvironment().getOCLStandardLibrary();
            AnyType anyType = (AnyType)stdlib.getOclAny();
            for (EOperation next : anyType.oclOperations()) {
                if (!next.getName().equals(oper.getName()) || !CompatibilityUtil.matchParms(next, oper)) continue;
                result = next;
                break;
            }
        }
        return result;
    }

    static boolean matchParms(EOperation oper1, EOperation oper2) {
        boolean result;
        EList parms1 = oper1.getEParameters();
        EList parms2 = oper2.getEParameters();
        int count = parms1.size();
        boolean bl = result = count == parms2.size();
        if (result) {
            int i = 0;
            while (result && i < count) {
                result = ((EParameter)parms1.get(i)).getName().equals(((EParameter)parms2.get(i)).getName());
                ++i;
            }
        }
        return result;
    }

    public static EList<EObject> getOldAS(org.eclipse.emf.ocl.parser.Environment env, List<? extends EObject> astNodes) {
        BasicEList result = new BasicEList(astNodes.size());
        for (EObject eObject : astNodes) {
            result.add((Object)CompatibilityUtil.getOldAS(env, eObject));
        }
        return result;
    }

    public static EList<EObject> getNewAS(org.eclipse.emf.ocl.parser.Environment env, List<? extends EObject> astNodes) {
        BasicEList result = new BasicEList(astNodes.size());
        for (EObject eObject : astNodes) {
            result.add((Object)CompatibilityUtil.getNewAS(env, eObject));
        }
        return result;
    }

    public static EObject getOldAS(org.eclipse.emf.ocl.parser.Environment env, EObject astNode) {
        EObject result;
        if (astNode == null) {
            return null;
        }
        AbstractSyntaxBridge bridge = (AbstractSyntaxBridge)EcoreUtil.getExistingAdapter((Notifier)astNode, AbstractSyntaxBridge.class);
        if (bridge != null) {
            return bridge.getOldAS();
        }
        if (astNode instanceof Constraint) {
            result = ToOldASVisitor.getInstance(env).visitConstraint((Constraint)astNode);
        } else if (astNode instanceof Visitable) {
            result = (EObject)((Visitable)astNode).accept((Visitor)ToOldASVisitor.getInstance(env));
        } else if (astNode instanceof org.eclipse.ocl.ecore.CallOperationAction) {
            result = ToOldASVisitor.getInstance(env).visitCallOperationAction((org.eclipse.ocl.ecore.CallOperationAction)astNode);
        } else if (astNode instanceof SendSignalAction) {
            result = ToOldASVisitor.getInstance(env).visitSendSignalAction((SendSignalAction)astNode);
        } else if (astNode instanceof PredefinedType || astNode instanceof ElementType) {
            EClassifier type = (EClassifier)astNode;
            if ("UnlimitedNatural".equals(type.getName())) {
                return Types.OCL_INTEGER;
            }
            result = ToOldASVisitor.getInstance(env).visitPredefinedType((EClassifier)astNode);
        } else {
            result = astNode instanceof CollectionItem ? ToOldASVisitor.getInstance(env).visitCollectionItem((CollectionItem<EClassifier>)((CollectionItem)astNode)) : (astNode instanceof CollectionRange ? ToOldASVisitor.getInstance(env).visitCollectionRange((CollectionRange<EClassifier>)((CollectionRange)astNode)) : astNode);
        }
        if (result != astNode) {
            AbstractSyntaxBridge.link(result, astNode, env);
        }
        return result;
    }

    public static EObject getNewAS(org.eclipse.emf.ocl.parser.Environment env, EObject astNode) {
        if (astNode == null) {
            return null;
        }
        AbstractSyntaxBridge bridge = (AbstractSyntaxBridge)EcoreUtil.getExistingAdapter((Notifier)astNode, AbstractSyntaxBridge.class);
        if (bridge != null) {
            return bridge.getNewAS();
        }
        Object result = astNode instanceof org.eclipse.emf.ocl.uml.Constraint ? (EObject)ToNewASVisitor.getInstance(env).visitConstraint((org.eclipse.emf.ocl.uml.Constraint)astNode) : (astNode instanceof org.eclipse.emf.ocl.utilities.Visitable ? (EObject)((org.eclipse.emf.ocl.utilities.Visitable)astNode).accept(ToNewASVisitor.getInstance(env)) : (astNode instanceof CallOperationAction ? ToNewASVisitor.getInstance(env).visitCallOperationAction((CallOperationAction)astNode) : (astNode instanceof org.eclipse.emf.ocl.uml.SendSignalAction ? ToNewASVisitor.getInstance(env).visitSendSignalAction((org.eclipse.emf.ocl.uml.SendSignalAction)astNode) : (astNode instanceof org.eclipse.emf.ocl.utilities.PredefinedType || astNode instanceof org.eclipse.emf.ocl.types.ElementType ? ToNewASVisitor.getInstance(env).visitPredefinedType((EClassifier)astNode) : (astNode instanceof org.eclipse.emf.ocl.expressions.CollectionItem ? ToNewASVisitor.getInstance(env).visitCollectionItem((org.eclipse.emf.ocl.expressions.CollectionItem)astNode) : (astNode instanceof org.eclipse.emf.ocl.expressions.CollectionRange ? ToNewASVisitor.getInstance(env).visitCollectionRange((org.eclipse.emf.ocl.expressions.CollectionRange)astNode) : astNode))))));
        if (result != astNode) {
            AbstractSyntaxBridge.link(astNode, result, env);
        }
        return result;
    }

    private static class AbstractSyntaxBridge
    extends AdapterImpl {
        private EObject oldAS;
        private EObject newAS;
        private Reference<org.eclipse.emf.ocl.parser.Environment> env;

        public boolean isAdapterForType(Object type) {
            return type == AbstractSyntaxBridge.class;
        }

        static void link(EObject oldAS, EObject newAS, org.eclipse.emf.ocl.parser.Environment env) {
            ExpressionInOCL specification;
            AbstractSyntaxBridge bridge = new AbstractSyntaxBridge(oldAS, newAS, env);
            oldAS.eAdapters().add((Object)bridge);
            newAS.eAdapters().add((Object)bridge);
            if (newAS instanceof Constraint && (specification = (ExpressionInOCL)((Constraint)newAS).getSpecification()) != null) {
                specification.eAdapters().add((Object)bridge);
            }
        }

        private AbstractSyntaxBridge(EObject oldAS, EObject newAS, org.eclipse.emf.ocl.parser.Environment env) {
            this.oldAS = oldAS;
            this.newAS = newAS;
            this.env = new WeakReference<org.eclipse.emf.ocl.parser.Environment>(env);
        }

        EObject getOldAS() {
            return this.oldAS;
        }

        EObject getNewAS() {
            return this.newAS;
        }

        public void unsetTarget(Notifier oldTarget) {
            super.unsetTarget(oldTarget);
            if (oldTarget == this.oldAS) {
                this.oldAS = null;
                if (this.newAS != null) {
                    this.newAS.eAdapters().remove((Object)this);
                }
            } else if (oldTarget == this.newAS) {
                this.newAS = null;
                if (this.oldAS != null) {
                    this.oldAS.eAdapters().remove((Object)this);
                }
            }
            this.env = null;
        }

        public void notifyChanged(Notification msg) {
            if (msg.isTouch()) {
                return;
            }
            org.eclipse.emf.ocl.parser.Environment env = this.env.get();
            if (env == null) {
                if (this.oldAS != null) {
                    this.oldAS.eAdapters().remove((Object)this);
                }
                return;
            }
            Object feature = msg.getFeature();
            Object notifier = msg.getNotifier();
            if (notifier == this.getNewAS() && (feature == EcorePackage.Literals.ETYPED_ELEMENT__ETYPE || feature == EcorePackage.Literals.ENAMED_ELEMENT__NAME)) {
                ToOldASVisitor.getInstance(env).copyTypedElement((TypedElement<EClassifier>)((TypedElement)this.getNewAS()), (org.eclipse.emf.ocl.uml.TypedElement)this.getOldAS());
            } else if (notifier instanceof org.eclipse.emf.ocl.uml.TypedElement && notifier == this.getOldAS() && (feature == UMLPackage.Literals.TYPED_ELEMENT__TYPE || feature == EcorePackage.Literals.ENAMED_ELEMENT__NAME)) {
                ToNewASVisitor.getInstance(env).copyTypedElement((org.eclipse.emf.ocl.uml.TypedElement)this.getOldAS(), (TypedElement<EClassifier>)((TypedElement)this.getNewAS()));
            } else if (feature == TypesPackage.Literals.COLLECTION_TYPE__ELEMENT_TYPE) {
                if (notifier == this.getNewAS()) {
                    ToOldASVisitor.getInstance(env).copyCollectionType((CollectionType)this.getNewAS(), (org.eclipse.emf.ocl.types.CollectionType)this.getOldAS());
                }
            } else if (feature == TypesPackage.Literals.COLLECTION_TYPE__ELEMENT_TYPE) {
                if (notifier == this.getOldAS()) {
                    ToNewASVisitor.getInstance(env).copyCollectionType((org.eclipse.emf.ocl.types.CollectionType)this.getOldAS(), (CollectionType)this.getNewAS());
                }
            } else if (feature == UtilitiesPackage.Literals.AST_NODE__END_POSITION || feature == UtilitiesPackage.Literals.AST_NODE__START_POSITION) {
                ToOldASVisitor.getInstance(env).copyASTNode((org.eclipse.ocl.utilities.ASTNode)this.getNewAS(), (ASTNode)this.getOldAS());
            } else if (feature == UtilitiesPackage.Literals.TYPED_AST_NODE__TYPE_END_POSITION || feature == UtilitiesPackage.Literals.TYPED_AST_NODE__TYPE_START_POSITION) {
                ToOldASVisitor.getInstance(env).copyTypedASTNode((org.eclipse.ocl.utilities.TypedASTNode)this.getNewAS(), (TypedASTNode)this.getOldAS());
            } else if (notifier instanceof Constraint && notifier == this.getNewAS()) {
                ToOldASVisitor.getInstance(env).copyConstraint((Constraint)this.getNewAS(), (org.eclipse.emf.ocl.uml.Constraint)this.getOldAS());
            } else if (feature == UtilitiesPackage.Literals.EXPRESSION_IN_OCL__BODY_EXPRESSION && ((ExpressionInOCL)notifier).eContainer() == this.getNewAS()) {
                ToOldASVisitor.getInstance(env).copyConstraint((Constraint)this.getNewAS(), (org.eclipse.emf.ocl.uml.Constraint)this.getOldAS());
            }
        }
    }
}

