/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.lpg;

import java.io.IOException;
import java.io.Reader;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.ocl.cst.CSTNode;
import org.eclipse.ocl.internal.OCLPlugin;
import org.eclipse.ocl.lpg.AbstractFormattingHelper;
import org.eclipse.ocl.lpg.AbstractLexer;
import org.eclipse.ocl.lpg.AbstractParser;
import org.eclipse.ocl.lpg.BasicEnvironment;
import org.eclipse.ocl.lpg.FormattingHelper;
import org.eclipse.ocl.utilities.ASTNode;
import org.eclipse.ocl.utilities.CallingASTNode;
import org.eclipse.ocl.utilities.TypedASTNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAnalyzer {
    private final AbstractParser parser;
    private final BasicEnvironment environment;
    private FormattingHelper formatter = null;
    private boolean traceflag = false;
    private int charOffset = 0;

    protected AbstractAnalyzer(AbstractParser parser) {
        this.parser = parser;
        this.environment = parser.getEnvironment();
    }

    public String computeInputString(CSTNode node) {
        return this.getParser().computeInputString(node.getStartOffset(), node.getEndOffset());
    }

    public void dumpTokens() {
        this.parser.dumpTokens();
    }

    public String formatClass(Object object) {
        return this.getFormatter().formatClass(object);
    }

    public String formatEClassName(EObject object) {
        return this.getFormatter().formatEClassName(object);
    }

    public String formatName(Object object) {
        return this.getFormatter().formatName(object);
    }

    public String formatQualifiedName(Object object) {
        return this.getFormatter().formatQualifiedName(object);
    }

    public String formatPath(List<String> pathName) {
        return this.getFormatter().formatPath(pathName);
    }

    public String formatPath(List<String> pathName, String name) {
        return this.getFormatter().formatPath(pathName, name);
    }

    public String formatString(String string) {
        return this.getFormatter().formatString(string);
    }

    public String formatType(Object object) {
        return this.getFormatter().formatType(object);
    }

    public int getCharOffset() {
        return this.charOffset;
    }

    public BasicEnvironment getEnvironment() {
        return this.environment;
    }

    public FormattingHelper getFormatter() {
        if (this.formatter == null) {
            BasicEnvironment environment = this.getEnvironment();
            if (environment != null) {
                this.formatter = environment.getFormatter();
            }
            if (this.formatter == null) {
                this.formatter = AbstractFormattingHelper.INSTANCE;
            }
        }
        return this.formatter;
    }

    public AbstractLexer getLexer() {
        return this.getParser().getLexer();
    }

    public AbstractParser getParser() {
        return this.parser;
    }

    public boolean getTraceFlag() {
        return this.traceflag;
    }

    protected void initPropertyPositions(CallingASTNode callingASTNode, CSTNode cstNode) {
        callingASTNode.setPropertyStartPosition(cstNode.getStartOffset() + this.charOffset);
        callingASTNode.setPropertyEndPosition(cstNode.getEndOffset() + this.charOffset + 1);
    }

    protected void initStartEndPositions(ASTNode astNode, CSTNode cstNode) {
        if (astNode != null && cstNode != null) {
            astNode.setStartPosition(cstNode.getStartOffset() + this.charOffset);
            astNode.setEndPosition(cstNode.getEndOffset() + this.charOffset + 1);
        }
    }

    protected void initTypePositions(TypedASTNode typedASTNode, CSTNode cstNode) {
        if (typedASTNode != null && cstNode != null) {
            typedASTNode.setTypeStartPosition(cstNode.getStartOffset() + this.charOffset);
            typedASTNode.setTypeEndPosition(cstNode.getEndOffset() + this.charOffset + 1);
        }
    }

    protected String makeName(EList<String> namelist) {
        StringBuffer msg = new StringBuffer();
        int i = 0;
        while (i < namelist.size()) {
            if (i > 0) {
                msg.append("::");
            }
            msg.append((String)namelist.get(i));
            ++i;
        }
        return msg.toString();
    }

    protected String makeString(EList<String> namelist) {
        String msg = "";
        int i = 0;
        while (i < namelist.size()) {
            msg = String.valueOf(msg) + " " + (String)namelist.get(i);
            ++i;
        }
        return msg;
    }

    public void setCharacterOffset(int offset) {
        this.charOffset = offset;
    }

    public void setFileName(String filename) {
        this.getLexer().setFileName(filename);
    }

    public void initialize(char[] buffer) {
        this.getLexer().initialize(buffer);
    }

    public void initialize(Reader reader) throws IOException {
        this.getLexer().initialize(reader);
    }

    public void setTab(int tab) {
        this.getLexer().setTab(tab);
    }

    public void setTraceFlag(boolean flag) {
        this.traceflag = flag;
    }

    public void ERROR(String problemMessage) {
        this.getEnvironment().utilityError(problemMessage, null, null);
    }

    public void ERROR(Object problemObject, String rule, String problemMessage) {
        this.getEnvironment().analyzerError(problemMessage, rule, problemObject);
    }

    public void ERROR(List<?> problemObjects, String rule, String problemMessage) {
        this.getEnvironment().analyzerError(problemMessage, rule, problemObjects);
    }

    protected void TRACE(String rule, String message) {
        if (this.traceflag) {
            OCLPlugin.trace(String.valueOf(rule) + ": " + message);
        }
    }

    protected void TRACE(String rule, String message, EList<String> namelist) {
        this.TRACE(rule, String.valueOf(message) + this.makeString(namelist));
    }
}

