/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.sequence.internal.layout.horizontal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LMFrame;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LMVisibleFrameWithPentagon;

class UntiedFrameHorizontalLayouter {
    private final int myWidth;
    private final List mySimpleLayoutersReverseOrder = new ArrayList();

    UntiedFrameHorizontalLayouter(Collection untiedFrames) {
        int width = 0;
        for (LMFrame lmFrame : untiedFrames) {
            int res = this.processRecusivelyReturnWidth(lmFrame, 0);
            if (width >= res) continue;
            width = res;
        }
        this.myWidth = width;
    }

    int getWidth() {
        return this.myWidth;
    }

    void layout(int x) {
        int i = this.mySimpleLayoutersReverseOrder.size() - 1;
        while (i >= 0) {
            SimpleLayouter simpleLayouter = (SimpleLayouter)this.mySimpleLayoutersReverseOrder.get(i);
            simpleLayouter.layout(x);
            --i;
        }
    }

    private int processRecusivelyReturnWidth(LMFrame lmFrame, int xOffset) {
        LMVisibleFrameWithPentagon frameWithPentagon;
        int titleWidth;
        int width = 10;
        if (lmFrame instanceof LMVisibleFrameWithPentagon && (titleWidth = (frameWithPentagon = (LMVisibleFrameWithPentagon)lmFrame).getPreferredWidth() + 10) > width) {
            width = titleWidth;
        }
        List childList = lmFrame.getChildList();
        int i = 0;
        while (i < childList.size()) {
            LMFrame childFrame = (LMFrame)childList.get(i);
            int subWidth = this.processRecusivelyReturnWidth(childFrame, xOffset + 3) + 5;
            if (width < subWidth) {
                width = subWidth;
            }
            ++i;
        }
        SimpleLayouter simpleLayouter = new SimpleLayouter(width, xOffset, lmFrame);
        this.mySimpleLayoutersReverseOrder.add(simpleLayouter);
        return width;
    }

    private static class SimpleLayouter {
        private final int myWidth;
        private int myOffset;
        private final LMFrame myLmFrame;

        SimpleLayouter(int width, int offset, LMFrame lmFrame) {
            this.myWidth = width;
            this.myOffset = offset;
            this.myLmFrame = lmFrame;
        }

        void layout(int baseX) {
            int x = baseX + this.myOffset;
            this.myLmFrame.setLeftBorderPosByLayout(x);
            this.myLmFrame.setRightBorderPosByLayout(x + this.myWidth);
        }
    }
}

