/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ocl.internal.parser;

import java.util.List;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ocl.expressions.AssociationClassCallExp;
import org.eclipse.emf.ocl.expressions.CallExp;
import org.eclipse.emf.ocl.expressions.CollectionKind;
import org.eclipse.emf.ocl.expressions.CollectionLiteralExp;
import org.eclipse.emf.ocl.expressions.ExpressionsFactory;
import org.eclipse.emf.ocl.expressions.InvalidLiteralExp;
import org.eclipse.emf.ocl.expressions.LetExp;
import org.eclipse.emf.ocl.expressions.LoopExp;
import org.eclipse.emf.ocl.expressions.NavigationCallExp;
import org.eclipse.emf.ocl.expressions.OperationCallExp;
import org.eclipse.emf.ocl.expressions.PrimitiveLiteralExp;
import org.eclipse.emf.ocl.expressions.PropertyCallExp;
import org.eclipse.emf.ocl.expressions.StateExp;
import org.eclipse.emf.ocl.expressions.TupleLiteralPart;
import org.eclipse.emf.ocl.expressions.UnspecifiedValueExp;
import org.eclipse.emf.ocl.expressions.Variable;
import org.eclipse.emf.ocl.internal.parser.CompatibilityUtil;
import org.eclipse.emf.ocl.parser.Environment;
import org.eclipse.emf.ocl.parser.PersistentEnvironment;
import org.eclipse.emf.ocl.parser.TypeResolver;
import org.eclipse.emf.ocl.types.ElementType;
import org.eclipse.emf.ocl.types.TupleType;
import org.eclipse.emf.ocl.types.TypesFactory;
import org.eclipse.emf.ocl.types.impl.AnyTypeImpl;
import org.eclipse.emf.ocl.types.impl.CollectionTypeImpl;
import org.eclipse.emf.ocl.types.util.Types;
import org.eclipse.emf.ocl.uml.UMLFactory;
import org.eclipse.emf.ocl.utilities.TypedASTNode;
import org.eclipse.ocl.ecore.AnyType;
import org.eclipse.ocl.ecore.CallOperationAction;
import org.eclipse.ocl.ecore.CollectionType;
import org.eclipse.ocl.ecore.Constraint;
import org.eclipse.ocl.ecore.EcoreEnvironmentFactory;
import org.eclipse.ocl.ecore.InvalidType;
import org.eclipse.ocl.ecore.MessageType;
import org.eclipse.ocl.ecore.PrimitiveType;
import org.eclipse.ocl.ecore.SendSignalAction;
import org.eclipse.ocl.ecore.TypeType;
import org.eclipse.ocl.ecore.VoidType;
import org.eclipse.ocl.ecore.util.EcoreSwitch;
import org.eclipse.ocl.expressions.BooleanLiteralExp;
import org.eclipse.ocl.expressions.CollectionItem;
import org.eclipse.ocl.expressions.CollectionLiteralPart;
import org.eclipse.ocl.expressions.CollectionRange;
import org.eclipse.ocl.expressions.EnumLiteralExp;
import org.eclipse.ocl.expressions.FeatureCallExp;
import org.eclipse.ocl.expressions.IfExp;
import org.eclipse.ocl.expressions.IntegerLiteralExp;
import org.eclipse.ocl.expressions.IterateExp;
import org.eclipse.ocl.expressions.IteratorExp;
import org.eclipse.ocl.expressions.LiteralExp;
import org.eclipse.ocl.expressions.MessageExp;
import org.eclipse.ocl.expressions.NullLiteralExp;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.expressions.RealLiteralExp;
import org.eclipse.ocl.expressions.StringLiteralExp;
import org.eclipse.ocl.expressions.TupleLiteralExp;
import org.eclipse.ocl.expressions.TypeExp;
import org.eclipse.ocl.expressions.UnlimitedNaturalLiteralExp;
import org.eclipse.ocl.expressions.VariableExp;
import org.eclipse.ocl.types.OCLStandardLibrary;
import org.eclipse.ocl.utilities.ASTNode;
import org.eclipse.ocl.utilities.CallingASTNode;
import org.eclipse.ocl.utilities.ExpressionInOCL;
import org.eclipse.ocl.utilities.TypedElement;
import org.eclipse.ocl.utilities.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ToOldASVisitor
implements Visitor<EObject, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint> {
    private EcoreSwitch<EClassifier> typesSwitch;
    private Environment env;
    private TypeResolver resolver;

    private ToOldASVisitor(Environment env) {
        this.env = env;
        if (env instanceof PersistentEnvironment) {
            this.resolver = ((PersistentEnvironment)env).getTypeResolver();
        }
    }

    static ToOldASVisitor getInstance(Environment env) {
        return new ToOldASVisitor(env);
    }

    void copyASTNode(ASTNode src, org.eclipse.emf.ocl.utilities.ASTNode dst) {
        dst.setStartPosition(src.getStartPosition());
        dst.setEndPosition(src.getEndPosition());
    }

    void copyTypedASTNode(org.eclipse.ocl.utilities.TypedASTNode src, TypedASTNode dst) {
        dst.setTypeStartPosition(src.getTypeStartPosition());
        dst.setTypeEndPosition(src.getTypeEndPosition());
        this.copyASTNode((ASTNode)src, dst);
    }

    private void copyCallingASTNode(CallingASTNode src, org.eclipse.emf.ocl.utilities.CallingASTNode dst) {
        dst.setPropertyStartPosition(src.getPropertyStartPosition());
        dst.setPropertyEndPosition(src.getPropertyEndPosition());
        this.copyASTNode((ASTNode)src, dst);
    }

    void copyTypedElement(TypedElement<EClassifier> src, org.eclipse.emf.ocl.uml.TypedElement dst) {
        dst.setName(src.getName());
        dst.setType((EClassifier)CompatibilityUtil.getOldAS(this.env, (EObject)src.getType()));
    }

    void copyCollectionType(CollectionType src, org.eclipse.emf.ocl.types.CollectionType dst) {
        dst.setElementType((EClassifier)CompatibilityUtil.getOldAS(this.env, (EObject)src.getElementType()));
    }

    void copyTupleLiteralPart(org.eclipse.ocl.expressions.TupleLiteralPart<EClassifier, EStructuralFeature> src, TupleLiteralPart dst) {
        EStructuralFeature attribute = (EStructuralFeature)src.getAttribute();
        org.eclipse.emf.ocl.expressions.TupleLiteralExp tuple = (org.eclipse.emf.ocl.expressions.TupleLiteralExp)dst.eContainer();
        TupleType type = (TupleType)tuple.getType();
        for (EStructuralFeature p : type.getEStructuralFeatures()) {
            if (!p.getName().equals(attribute.getName())) continue;
            dst.setAttribute(p);
            break;
        }
    }

    void copyConstraint(Constraint src, org.eclipse.emf.ocl.uml.Constraint dst) {
        dst.setBody((org.eclipse.emf.ocl.expressions.OCLExpression)CompatibilityUtil.getOldAS(this.env, (EObject)src.getSpecification().getBodyExpression()));
        dst.setName(src.getName());
        dst.setStereotype(src.getStereotype());
        ECollections.setEList((EList)dst.getConstrainedElement(), (List)src.getConstrainedElements());
    }

    private void copyNavigationCallExp(org.eclipse.ocl.expressions.NavigationCallExp<EClassifier, EStructuralFeature> src, NavigationCallExp dst) {
        dst.setNavigationSource((EStructuralFeature)src.getNavigationSource());
        for (OCLExpression q : src.getQualifier()) {
            dst.getQualifier().add((Object)CompatibilityUtil.getOldAS(this.env, (EObject)q));
        }
        this.copyFeatureCallExp((FeatureCallExp<EClassifier>)src, dst);
    }

    private void copyFeatureCallExp(FeatureCallExp<EClassifier> src, org.eclipse.emf.ocl.expressions.FeatureCallExp dst) {
        dst.setMarkedPre(src.isMarkedPre());
        this.copyCallExp((org.eclipse.ocl.expressions.CallExp<EClassifier>)src, dst);
    }

    private void copyCallExp(org.eclipse.ocl.expressions.CallExp<EClassifier> src, CallExp dst) {
        dst.setSource((org.eclipse.emf.ocl.expressions.OCLExpression)CompatibilityUtil.getOldAS(this.env, (EObject)src.getSource()));
        this.copyOCLExpression((OCLExpression<EClassifier>)src, dst);
        this.copyCallingASTNode((CallingASTNode)src, dst);
    }

    private void copyOCLExpression(OCLExpression<EClassifier> src, org.eclipse.emf.ocl.expressions.OCLExpression dst) {
        this.copyTypedElement((TypedElement<EClassifier>)src, dst);
        this.copyASTNode((ASTNode)src, dst);
    }

    private void copyPrimitiveLiteralExp(org.eclipse.ocl.expressions.PrimitiveLiteralExp<EClassifier> src, PrimitiveLiteralExp dst) {
        this.copyLiteralExp((LiteralExp<EClassifier>)src, dst);
    }

    private void copyLiteralExp(LiteralExp<EClassifier> src, org.eclipse.emf.ocl.expressions.LiteralExp dst) {
        this.copyOCLExpression((OCLExpression<EClassifier>)src, dst);
    }

    private void copyLoopExp(org.eclipse.ocl.expressions.LoopExp<EClassifier, EParameter> src, LoopExp dst) {
        dst.setBody((org.eclipse.emf.ocl.expressions.OCLExpression)CompatibilityUtil.getOldAS(this.env, (EObject)src.getBody()));
        for (org.eclipse.ocl.expressions.Variable i : src.getIterator()) {
            dst.getIterator().add((Object)CompatibilityUtil.getOldAS(this.env, (EObject)i));
        }
        this.copyCallExp((org.eclipse.ocl.expressions.CallExp<EClassifier>)src, dst);
    }

    public EObject visitAssociationClassCallExp(org.eclipse.ocl.expressions.AssociationClassCallExp<EClassifier, EStructuralFeature> ae) {
        AssociationClassCallExp result = ExpressionsFactory.eINSTANCE.createAssociationClassCallExp();
        result.setReferredAssociationClass((EClass)ae.getReferredAssociationClass());
        for (OCLExpression q : ae.getQualifier()) {
            result.getQualifier().add((Object)CompatibilityUtil.getOldAS(this.env, (EObject)q));
        }
        this.copyNavigationCallExp((org.eclipse.ocl.expressions.NavigationCallExp<EClassifier, EStructuralFeature>)ae, result);
        return result;
    }

    public EObject visitBooleanLiteralExp(BooleanLiteralExp<EClassifier> bl) {
        org.eclipse.emf.ocl.expressions.BooleanLiteralExp result = ExpressionsFactory.eINSTANCE.createBooleanLiteralExp();
        result.setBooleanSymbol(bl.getBooleanSymbol());
        this.copyPrimitiveLiteralExp((org.eclipse.ocl.expressions.PrimitiveLiteralExp<EClassifier>)bl, result);
        return result;
    }

    public EObject visitCollectionLiteralExp(org.eclipse.ocl.expressions.CollectionLiteralExp<EClassifier> cl) {
        CollectionLiteralExp result = ExpressionsFactory.eINSTANCE.createCollectionLiteralExp();
        result.setKind(CollectionKind.getCompatibleKind(cl.getKind()));
        for (CollectionLiteralPart p : cl.getPart()) {
            result.getPart().add((Object)CompatibilityUtil.getOldAS(this.env, (EObject)p));
        }
        this.copyLiteralExp((LiteralExp<EClassifier>)cl, result);
        return result;
    }

    public EObject visitCollectionItem(CollectionItem<EClassifier> item) {
        org.eclipse.emf.ocl.expressions.CollectionItem result = ExpressionsFactory.eINSTANCE.createCollectionItem();
        result.setItem((org.eclipse.emf.ocl.expressions.OCLExpression)CompatibilityUtil.getOldAS(this.env, (EObject)item.getItem()));
        this.copyTypedElement((TypedElement<EClassifier>)item, result);
        return result;
    }

    public EObject visitCollectionRange(CollectionRange<EClassifier> range) {
        org.eclipse.emf.ocl.expressions.CollectionRange result = ExpressionsFactory.eINSTANCE.createCollectionRange();
        result.setFirst((org.eclipse.emf.ocl.expressions.OCLExpression)CompatibilityUtil.getOldAS(this.env, (EObject)range.getFirst()));
        result.setLast((org.eclipse.emf.ocl.expressions.OCLExpression)CompatibilityUtil.getOldAS(this.env, (EObject)range.getLast()));
        this.copyTypedElement((TypedElement<EClassifier>)range, result);
        return result;
    }

    public EObject visitConstraint(Constraint constraint) {
        org.eclipse.emf.ocl.uml.Constraint result = UMLFactory.eINSTANCE.createConstraint();
        this.copyConstraint(constraint, result);
        return result;
    }

    public EObject visitEnumLiteralExp(EnumLiteralExp<EClassifier, EEnumLiteral> el) {
        org.eclipse.emf.ocl.expressions.EnumLiteralExp result = ExpressionsFactory.eINSTANCE.createEnumLiteralExp();
        result.setReferredEnumLiteral((EEnumLiteral)el.getReferredEnumLiteral());
        this.copyLiteralExp((LiteralExp<EClassifier>)el, result);
        return result;
    }

    public EObject visitIfExp(IfExp<EClassifier> i) {
        org.eclipse.emf.ocl.expressions.IfExp result = ExpressionsFactory.eINSTANCE.createIfExp();
        result.setCondition((org.eclipse.emf.ocl.expressions.OCLExpression)CompatibilityUtil.getOldAS(this.env, (EObject)i.getCondition()));
        result.setThenExpression((org.eclipse.emf.ocl.expressions.OCLExpression)CompatibilityUtil.getOldAS(this.env, (EObject)i.getThenExpression()));
        result.setElseExpression((org.eclipse.emf.ocl.expressions.OCLExpression)CompatibilityUtil.getOldAS(this.env, (EObject)i.getElseExpression()));
        this.copyOCLExpression((OCLExpression<EClassifier>)i, result);
        return result;
    }

    public EObject visitIntegerLiteralExp(IntegerLiteralExp<EClassifier> il) {
        org.eclipse.emf.ocl.expressions.IntegerLiteralExp result = ExpressionsFactory.eINSTANCE.createIntegerLiteralExp();
        result.setIntegerSymbol(il.getIntegerSymbol());
        this.copyPrimitiveLiteralExp((org.eclipse.ocl.expressions.PrimitiveLiteralExp<EClassifier>)il, result);
        return result;
    }

    public EObject visitUnlimitedNaturalLiteralExp(UnlimitedNaturalLiteralExp<EClassifier> literalExp) {
        org.eclipse.emf.ocl.expressions.IntegerLiteralExp result = ExpressionsFactory.eINSTANCE.createIntegerLiteralExp();
        result.setIntegerSymbol(literalExp.getIntegerSymbol());
        this.copyPrimitiveLiteralExp((org.eclipse.ocl.expressions.PrimitiveLiteralExp<EClassifier>)literalExp, result);
        return result;
    }

    public EObject visitInvalidLiteralExp(org.eclipse.ocl.expressions.InvalidLiteralExp<EClassifier> il) {
        InvalidLiteralExp result = ExpressionsFactory.eINSTANCE.createInvalidLiteralExp();
        this.copyLiteralExp((LiteralExp<EClassifier>)il, result);
        return result;
    }

    public EObject visitIterateExp(IterateExp<EClassifier, EParameter> ie) {
        org.eclipse.emf.ocl.expressions.IterateExp result = ExpressionsFactory.eINSTANCE.createIterateExp();
        result.setResult((Variable)CompatibilityUtil.getOldAS(this.env, (EObject)ie.getResult()));
        this.copyLoopExp((org.eclipse.ocl.expressions.LoopExp<EClassifier, EParameter>)ie, result);
        return result;
    }

    public EObject visitIteratorExp(IteratorExp<EClassifier, EParameter> ie) {
        org.eclipse.emf.ocl.expressions.IteratorExp result = ExpressionsFactory.eINSTANCE.createIteratorExp();
        this.copyLoopExp((org.eclipse.ocl.expressions.LoopExp<EClassifier, EParameter>)ie, result);
        return result;
    }

    public EObject visitLetExp(org.eclipse.ocl.expressions.LetExp<EClassifier, EParameter> l) {
        LetExp result = ExpressionsFactory.eINSTANCE.createLetExp();
        result.setVariable((Variable)CompatibilityUtil.getOldAS(this.env, (EObject)l.getVariable()));
        result.setIn((org.eclipse.emf.ocl.expressions.OCLExpression)CompatibilityUtil.getOldAS(this.env, (EObject)l.getIn()));
        this.copyOCLExpression((OCLExpression<EClassifier>)l, result);
        return result;
    }

    public EObject visitMessageExp(MessageExp<EClassifier, CallOperationAction, SendSignalAction> m) {
        org.eclipse.emf.ocl.expressions.MessageExp result = ExpressionsFactory.eINSTANCE.createMessageExp();
        result.setTarget((org.eclipse.emf.ocl.expressions.OCLExpression)CompatibilityUtil.getOldAS(this.env, (EObject)m.getTarget()));
        result.setCalledOperation((org.eclipse.emf.ocl.uml.CallOperationAction)CompatibilityUtil.getOldAS(this.env, (EObject)m.getCalledOperation()));
        result.setSentSignal((org.eclipse.emf.ocl.uml.SendSignalAction)CompatibilityUtil.getOldAS(this.env, (EObject)m.getSentSignal()));
        for (OCLExpression a : m.getArgument()) {
            result.getArgument().add((Object)CompatibilityUtil.getOldAS(this.env, (EObject)a));
        }
        this.copyOCLExpression((OCLExpression<EClassifier>)m, result);
        this.copyCallingASTNode((CallingASTNode)m, result);
        return result;
    }

    public EObject visitNullLiteralExp(NullLiteralExp<EClassifier> il) {
        org.eclipse.emf.ocl.expressions.NullLiteralExp result = ExpressionsFactory.eINSTANCE.createNullLiteralExp();
        this.copyLiteralExp((LiteralExp<EClassifier>)il, result);
        return result;
    }

    public EObject visitOperationCallExp(org.eclipse.ocl.expressions.OperationCallExp<EClassifier, EOperation> oc) {
        OperationCallExp result = ExpressionsFactory.eINSTANCE.createOperationCallExp();
        for (OCLExpression a : oc.getArgument()) {
            result.getArgument().add((Object)CompatibilityUtil.getOldAS(this.env, (EObject)a));
        }
        this.copyFeatureCallExp((FeatureCallExp<EClassifier>)oc, result);
        EOperation refOperation = (EOperation)oc.getReferredOperation();
        refOperation = CompatibilityUtil.getOldOperation(refOperation, result.getSource().getType(), (EClassifier)oc.getSource().getType());
        result.setReferredOperation(refOperation);
        return result;
    }

    public EObject visitPropertyCallExp(org.eclipse.ocl.expressions.PropertyCallExp<EClassifier, EStructuralFeature> ae) {
        PropertyCallExp result = ExpressionsFactory.eINSTANCE.createPropertyCallExp();
        this.copyNavigationCallExp((org.eclipse.ocl.expressions.NavigationCallExp<EClassifier, EStructuralFeature>)ae, result);
        EStructuralFeature refProperty = (EStructuralFeature)ae.getReferredProperty();
        if (ae.getSource() != null) {
            EClassifier sourceType = (EClassifier)ae.getSource().getType();
            if (sourceType instanceof MessageType) {
                for (EStructuralFeature p : ((org.eclipse.emf.ocl.types.MessageType)result.getSource().getType()).getEStructuralFeatures()) {
                    if (!p.getName().equals(refProperty.getName())) continue;
                    refProperty = p;
                    break;
                }
            } else if (sourceType instanceof org.eclipse.ocl.ecore.TupleType) {
                for (EStructuralFeature p : ((TupleType)result.getSource().getType()).getEStructuralFeatures()) {
                    if (!p.getName().equals(refProperty.getName())) continue;
                    refProperty = p;
                    break;
                }
            }
        }
        result.setReferredProperty(refProperty);
        return result;
    }

    public EObject visitRealLiteralExp(RealLiteralExp<EClassifier> rl) {
        org.eclipse.emf.ocl.expressions.RealLiteralExp result = ExpressionsFactory.eINSTANCE.createRealLiteralExp();
        result.setRealSymbol(rl.getRealSymbol());
        this.copyPrimitiveLiteralExp((org.eclipse.ocl.expressions.PrimitiveLiteralExp<EClassifier>)rl, result);
        return result;
    }

    public EObject visitStateExp(org.eclipse.ocl.expressions.StateExp<EClassifier, EObject> s) {
        StateExp result = ExpressionsFactory.eINSTANCE.createStateExp();
        result.setReferredState((EObject)s.getReferredState());
        this.copyOCLExpression((OCLExpression<EClassifier>)s, result);
        return result;
    }

    public EObject visitStringLiteralExp(StringLiteralExp<EClassifier> sl) {
        org.eclipse.emf.ocl.expressions.StringLiteralExp result = ExpressionsFactory.eINSTANCE.createStringLiteralExp();
        result.setStringSymbol(sl.getStringSymbol());
        this.copyPrimitiveLiteralExp((org.eclipse.ocl.expressions.PrimitiveLiteralExp<EClassifier>)sl, result);
        return result;
    }

    public EObject visitTupleLiteralExp(TupleLiteralExp<EClassifier, EStructuralFeature> tl) {
        org.eclipse.emf.ocl.expressions.TupleLiteralExp result = ExpressionsFactory.eINSTANCE.createTupleLiteralExp();
        this.copyLiteralExp((LiteralExp<EClassifier>)tl, result);
        for (org.eclipse.ocl.expressions.TupleLiteralPart p : tl.getPart()) {
            TupleLiteralPart newPart = (TupleLiteralPart)CompatibilityUtil.getOldAS(this.env, (EObject)p);
            result.getPart().add((Object)newPart);
            this.copyTupleLiteralPart((org.eclipse.ocl.expressions.TupleLiteralPart<EClassifier, EStructuralFeature>)p, newPart);
        }
        return result;
    }

    public EObject visitTupleLiteralPart(org.eclipse.ocl.expressions.TupleLiteralPart<EClassifier, EStructuralFeature> tp) {
        TupleLiteralPart result = ExpressionsFactory.eINSTANCE.createTupleLiteralPart();
        result.setAttribute((EStructuralFeature)tp.getAttribute());
        result.setValue((org.eclipse.emf.ocl.expressions.OCLExpression)CompatibilityUtil.getOldAS(this.env, (EObject)tp.getValue()));
        this.copyTypedASTNode((org.eclipse.ocl.utilities.TypedASTNode)tp, result);
        this.copyTypedElement((TypedElement<EClassifier>)tp, result);
        return result;
    }

    public EObject visitTypeExp(TypeExp<EClassifier> t) {
        org.eclipse.emf.ocl.expressions.TypeExp result = ExpressionsFactory.eINSTANCE.createTypeExp();
        result.setReferredType((EClassifier)CompatibilityUtil.getOldAS(this.env, (EObject)t.getReferredType()));
        this.copyOCLExpression((OCLExpression<EClassifier>)t, result);
        return result;
    }

    public EObject visitUnspecifiedValueExp(org.eclipse.ocl.expressions.UnspecifiedValueExp<EClassifier> uv) {
        UnspecifiedValueExp result = ExpressionsFactory.eINSTANCE.createUnspecifiedValueExp();
        this.copyTypedASTNode((org.eclipse.ocl.utilities.TypedASTNode)uv, result);
        this.copyOCLExpression((OCLExpression<EClassifier>)uv, result);
        return result;
    }

    public EObject visitVariable(org.eclipse.ocl.expressions.Variable<EClassifier, EParameter> vd) {
        Variable result = ExpressionsFactory.eINSTANCE.createVariable();
        result.setRepresentedParameter((EParameter)vd.getRepresentedParameter());
        result.setInitExpression((org.eclipse.emf.ocl.expressions.OCLExpression)CompatibilityUtil.getOldAS(this.env, (EObject)vd.getInitExpression()));
        this.copyTypedASTNode((org.eclipse.ocl.utilities.TypedASTNode)vd, result);
        this.copyTypedElement((TypedElement<EClassifier>)vd, result);
        return result;
    }

    public EObject visitVariableExp(VariableExp<EClassifier, EParameter> v) {
        org.eclipse.emf.ocl.expressions.VariableExp result = ExpressionsFactory.eINSTANCE.createVariableExp();
        result.setReferredVariable((Variable)CompatibilityUtil.getOldAS(this.env, (EObject)v.getReferredVariable()));
        this.copyOCLExpression((OCLExpression<EClassifier>)v, result);
        return result;
    }

    public org.eclipse.emf.ocl.uml.CallOperationAction visitCallOperationAction(CallOperationAction coa) {
        org.eclipse.emf.ocl.uml.CallOperationAction result = UMLFactory.eINSTANCE.createCallOperationAction();
        result.setOperation(coa.getOperation());
        return result;
    }

    public org.eclipse.emf.ocl.uml.SendSignalAction visitSendSignalAction(SendSignalAction ssa) {
        org.eclipse.emf.ocl.uml.SendSignalAction result = UMLFactory.eINSTANCE.createSendSignalAction();
        result.setSignal(ssa.getSignal());
        return result;
    }

    public EObject visitExpressionInOCL(ExpressionInOCL<EClassifier, EParameter> expression) {
        throw new IllegalArgumentException("cannot convert ExpressionInOCL");
    }

    public EClassifier visitPredefinedType(EClassifier type) {
        if (this.typesSwitch == null) {
            this.typesSwitch = new EcoreSwitch<EClassifier>(){
                OCLStandardLibrary<EClassifier> stdlib = EcoreEnvironmentFactory.INSTANCE.createEnvironment().getOCLStandardLibrary();

                public EClassifier caseAnyType(AnyType object) {
                    if (object == this.stdlib.getOclAny()) {
                        return Types.OCL_ANY_TYPE;
                    }
                    if (object == this.stdlib.getT()) {
                        return AnyTypeImpl.OCL_T;
                    }
                    if (object == this.stdlib.getT2()) {
                        return AnyTypeImpl.OCL_T2;
                    }
                    return TypesFactory.eINSTANCE.createAnyType();
                }

                public EClassifier caseElementType(org.eclipse.ocl.ecore.ElementType object) {
                    if (object == this.stdlib.getState()) {
                        return Types.STATE;
                    }
                    if (object == this.stdlib.getOclElement()) {
                        return Types.OCL_ELEMENT;
                    }
                    ElementType result = TypesFactory.eINSTANCE.createElementType();
                    result.setName(object.getName());
                    return result;
                }

                public EClassifier caseInvalidType(InvalidType object) {
                    return Types.INVALID;
                }

                public EClassifier caseVoidType(VoidType object) {
                    return Types.OCL_VOID;
                }

                public EClassifier casePrimitiveType(PrimitiveType object) {
                    if (object == this.stdlib.getBoolean()) {
                        return Types.OCL_BOOLEAN;
                    }
                    if (object == this.stdlib.getString()) {
                        return Types.OCL_STRING;
                    }
                    if (object == this.stdlib.getReal()) {
                        return Types.OCL_REAL;
                    }
                    return Types.OCL_INTEGER;
                }

                public EClassifier caseTypeType(TypeType object) {
                    if (object == this.stdlib.getOclType()) {
                        return Types.OCL_TYPE;
                    }
                    if (ToOldASVisitor.this.resolver != null) {
                        return ToOldASVisitor.this.resolver.resolveTypeType((EClassifier)CompatibilityUtil.getOldAS(ToOldASVisitor.this.env, (EObject)object.getReferredType()));
                    }
                    return TypesFactory.eINSTANCE.createTypeType((EClassifier)CompatibilityUtil.getOldAS(ToOldASVisitor.this.env, (EObject)object.getReferredType()));
                }

                public EClassifier caseCollectionType(CollectionType object) {
                    if (object == this.stdlib.getSet()) {
                        return CollectionTypeImpl.OCL_SET;
                    }
                    if (object == this.stdlib.getBag()) {
                        return CollectionTypeImpl.OCL_BAG;
                    }
                    if (object == this.stdlib.getOrderedSet()) {
                        return CollectionTypeImpl.OCL_ORDERED_SET;
                    }
                    if (object == this.stdlib.getSequence()) {
                        return CollectionTypeImpl.OCL_SEQUENCE;
                    }
                    if (object == this.stdlib.getCollection()) {
                        return CollectionTypeImpl.OCL_COLLECTION;
                    }
                    if (ToOldASVisitor.this.resolver != null) {
                        return ToOldASVisitor.this.resolver.resolveCollectionType(CollectionKind.getCompatibleKind(object.getKind()), (EClassifier)CompatibilityUtil.getOldAS(ToOldASVisitor.this.env, (EObject)object.getElementType()));
                    }
                    return TypesFactory.eINSTANCE.createCollectionType(CollectionKind.getCompatibleKind(object.getKind()), (EClassifier)CompatibilityUtil.getOldAS(ToOldASVisitor.this.env, (EObject)object.getElementType()));
                }

                public EClassifier caseMessageType(MessageType object) {
                    if (object == this.stdlib.getOclMessage()) {
                        return Types.OCL_MESSAGE;
                    }
                    if (object.getReferredOperation() != null) {
                        if (ToOldASVisitor.this.resolver != null) {
                            return ToOldASVisitor.this.resolver.resolveMessageType((EOperation)object.getReferredOperation());
                        }
                        return TypesFactory.eINSTANCE.createMessageType((ENamedElement)object.getReferredOperation());
                    }
                    if (ToOldASVisitor.this.resolver != null) {
                        return ToOldASVisitor.this.resolver.resolveMessageType((EClass)object.getReferredSignal());
                    }
                    return TypesFactory.eINSTANCE.createMessageType((ENamedElement)object.getReferredSignal());
                }

                public EClassifier caseTupleType(org.eclipse.ocl.ecore.TupleType object) {
                    BasicEList parts = new BasicEList(object.getEStructuralFeatures().size());
                    for (EStructuralFeature p : object.getEStructuralFeatures()) {
                        Variable part = ExpressionsFactory.eINSTANCE.createVariable();
                        part.setName(p.getName());
                        part.setType((EClassifier)CompatibilityUtil.getOldAS(ToOldASVisitor.this.env, (EObject)p.getEType()));
                        parts.add((Object)part);
                    }
                    if (ToOldASVisitor.this.resolver != null) {
                        return ToOldASVisitor.this.resolver.resolveTupleType((List)parts);
                    }
                    return TypesFactory.eINSTANCE.createTupleType((List)parts);
                }

                public EClassifier defaultCase(EObject object) {
                    if (object instanceof InvalidType) {
                        return Types.INVALID;
                    }
                    return null;
                }
            };
        }
        return (EClassifier)this.typesSwitch.doSwitch((EObject)type);
    }
}

