/**
 * <copyright> 
 * 
 * Copyright (c) 2004-2005 IBM Corporation and others. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License - v 1.0 
 * which accompanies this distribution, and is available at 
 * http://opensource.org/licenses/eclipse-1.0.txt 
 * 
 * Contributors: 
 *   IBM - Initial API and implementation 
 * 
 * </copyright> 
 * 
 * $Id: ContainmentLink.java,v 1.2 2007/03/18 09:06:59 lzhang Exp $
 */

package org.eclipse.eodm.owl.reasoner.structural;

public class ContainmentLink extends NodeLink {


    public ContainmentLink(TBox tbox) {
        super(tbox);
    }

    public ContainmentLink(TBox tbox, CTNode source, CTNode target) {
        super(tbox, source, target);
    }

    public void setSource(CTNode source) {
        if (this.source != source) {
            if (this.source != null) {
                this.source.containmentLinks.remove(this);
            }
            this.source = source;
            if (source != null) {
                source.containmentLinks.add(this);
            }
        }
    }

    public void setTarget(CTNode target) {
        if (this.target != target) {
            if (this.target != null) {
                this.target.containmentByLinks.remove(this);
            }
            this.target = target;
            if (target != null) {
                target.containmentByLinks.add(this);
            }
        }
    }
	
}
