/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.usecase.edit.policies;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.DeferredLayoutCommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.CanonicalConnectionEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewRequest;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.uml2.diagram.usecase.part.UMLDiagramUpdater;
import org.eclipse.uml2.diagram.usecase.part.UMLLinkDescriptor;
import org.eclipse.uml2.diagram.usecase.part.UMLNodeDescriptor;
import org.eclipse.uml2.diagram.usecase.part.UMLVisualIDRegistry;
import org.eclipse.uml2.uml.UMLPackage;

public class PackageCanonicalEditPolicy
extends CanonicalConnectionEditPolicy {
    Set myFeaturesToSynchronize;

    protected List getSemanticChildrenList() {
        View viewObject = (View)this.getHost().getModel();
        LinkedList<EObject> result = new LinkedList<EObject>();
        Iterator it = UMLDiagramUpdater.getSemanticChildren(viewObject).iterator();
        while (it.hasNext()) {
            result.add(((UMLNodeDescriptor)it.next()).getModelElement());
        }
        return result;
    }

    protected boolean shouldDeleteView(View view) {
        return true;
    }

    protected boolean isOrphaned(Collection semanticChildren, View view) {
        int actualID = UMLVisualIDRegistry.getVisualID(view);
        int suggestedID = UMLVisualIDRegistry.getNodeVisualID((View)this.getHost().getModel(), view.getElement());
        switch (actualID) {
            case 2001: 
            case 2006: 
            case 2007: 
            case 2008: {
                return !semanticChildren.contains(view.getElement()) || actualID != suggestedID;
            }
            case 2002: {
                if (!semanticChildren.contains(view.getElement())) {
                    return true;
                }
                return actualID != suggestedID && suggestedID != 2005;
            }
            case 2005: {
                if (!semanticChildren.contains(view.getElement())) {
                    return true;
                }
                return actualID != suggestedID && suggestedID != 2002;
            }
            case 2003: {
                if (!semanticChildren.contains(view.getElement())) {
                    return true;
                }
                return actualID != suggestedID && suggestedID != 2004;
            }
            case 2004: {
                if (!semanticChildren.contains(view.getElement())) {
                    return true;
                }
                return actualID != suggestedID && suggestedID != 2003;
            }
        }
        return false;
    }

    protected String getDefaultFactoryHint() {
        return null;
    }

    protected Set getFeaturesToSynchronize() {
        if (this.myFeaturesToSynchronize == null) {
            this.myFeaturesToSynchronize = new HashSet();
            this.myFeaturesToSynchronize.add(UMLPackage.eINSTANCE.getComponent_PackagedElement());
            this.myFeaturesToSynchronize.add(UMLPackage.eINSTANCE.getPackage_PackagedElement());
        }
        return this.myFeaturesToSynchronize;
    }

    protected List getSemanticConnectionsList() {
        return Collections.EMPTY_LIST;
    }

    protected EObject getSourceElement(EObject relationship) {
        return null;
    }

    protected EObject getTargetElement(EObject relationship) {
        return null;
    }

    protected boolean shouldIncludeConnection(Edge connector, Collection children) {
        return false;
    }

    protected void refreshSemantic() {
        LinkedList createdViews = new LinkedList();
        createdViews.addAll(this.refreshSemanticChildren());
        LinkedList createdConnectionViews = new LinkedList();
        createdConnectionViews.addAll(this.refreshSemanticConnections());
        createdConnectionViews.addAll(this.refreshConnections());
        if (createdViews.size() > 1) {
            DeferredLayoutCommand layoutCmd = new DeferredLayoutCommand(this.host().getEditingDomain(), createdViews, this.host());
            this.executeCommand((Command)new ICommandProxy((ICommand)layoutCmd));
        }
        createdViews.addAll(createdConnectionViews);
        this.makeViewsImmutable(createdViews);
    }

    private Diagram getDiagram() {
        return ((View)this.getHost().getModel()).getDiagram();
    }

    private Collection refreshConnections() {
        Domain2Notation domain2NotationMap = new Domain2Notation();
        Collection linkDescriptors = this.collectAllLinks((View)this.getDiagram(), domain2NotationMap);
        LinkedList existingLinks = new LinkedList(this.getDiagram().getEdges());
        Iterator linksIterator = existingLinks.iterator();
        while (linksIterator.hasNext()) {
            Edge nextDiagramLink = (Edge)linksIterator.next();
            int diagramLinkVisualID = UMLVisualIDRegistry.getVisualID((View)nextDiagramLink);
            if (diagramLinkVisualID == -1) {
                if (nextDiagramLink.getSource() == null || nextDiagramLink.getTarget() == null) continue;
                linksIterator.remove();
                continue;
            }
            EObject diagramLinkObject = nextDiagramLink.getElement();
            EObject diagramLinkSrc = nextDiagramLink.getSource().getElement();
            EObject diagramLinkDst = nextDiagramLink.getTarget().getElement();
            Iterator LinkDescriptorsIterator = linkDescriptors.iterator();
            while (LinkDescriptorsIterator.hasNext()) {
                UMLLinkDescriptor nextLinkDescriptor = (UMLLinkDescriptor)LinkDescriptorsIterator.next();
                if (diagramLinkObject != nextLinkDescriptor.getModelElement() || diagramLinkSrc != nextLinkDescriptor.getSource() || diagramLinkDst != nextLinkDescriptor.getDestination() || diagramLinkVisualID != nextLinkDescriptor.getVisualID()) continue;
                linksIterator.remove();
                LinkDescriptorsIterator.remove();
            }
        }
        this.deleteViews(existingLinks.iterator());
        return this.createConnections(linkDescriptors, domain2NotationMap);
    }

    private Collection collectAllLinks(View view, Domain2Notation domain2NotationMap) {
        if (!"UMLUseCase".equals(UMLVisualIDRegistry.getModelID(view))) {
            return Collections.EMPTY_LIST;
        }
        LinkedList result = new LinkedList();
        switch (UMLVisualIDRegistry.getVisualID(view)) {
            case 1000: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getPackage_1000ContainedLinks(view));
                }
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 2001: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getPackage_2001ContainedLinks(view));
                }
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 2002: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getActor_2002ContainedLinks(view));
                }
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 2005: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getActor_2005ContainedLinks(view));
                }
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 2003: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getUseCase_2003ContainedLinks(view));
                }
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 2004: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getUseCase_2004ContainedLinks(view));
                }
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 2006: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getComponent_2006ContainedLinks(view));
                }
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 2007: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getPackage_2007ContainedLinks(view));
                }
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 2008: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getConstraint_2008ContainedLinks(view));
                }
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 3001: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getElementImport_3001ContainedLinks(view));
                }
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 3002: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getExtensionPoint_3002ContainedLinks(view));
                }
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 3003: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getExtensionPoint_3003ContainedLinks(view));
                }
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 3004: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getUseCase_3004ContainedLinks(view));
                }
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 3005: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getActor_3005ContainedLinks(view));
                }
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 3006: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getUseCase_3006ContainedLinks(view));
                }
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 4001: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getInclude_4001ContainedLinks(view));
                }
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 4002: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getExtend_4002ContainedLinks(view));
                }
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 4003: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getGeneralization_4003ContainedLinks(view));
                }
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 4004: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getAssociation_4004ContainedLinks(view));
                }
                domain2NotationMap.put(view.getElement(), view);
            }
        }
        Iterator children = view.getChildren().iterator();
        while (children.hasNext()) {
            result.addAll(this.collectAllLinks((View)children.next(), domain2NotationMap));
        }
        Iterator edges = view.getSourceEdges().iterator();
        while (edges.hasNext()) {
            result.addAll(this.collectAllLinks((View)edges.next(), domain2NotationMap));
        }
        return result;
    }

    private Collection createConnections(Collection linkDescriptors, Domain2Notation domain2NotationMap) {
        LinkedList<IAdaptable> adapters = new LinkedList<IAdaptable>();
        for (UMLLinkDescriptor nextLinkDescriptor : linkDescriptors) {
            EditPart sourceEditPart = this.getSourceEditPart(nextLinkDescriptor, domain2NotationMap);
            EditPart targetEditPart = this.getTargetEditPart(nextLinkDescriptor, domain2NotationMap);
            if (sourceEditPart == null || targetEditPart == null) continue;
            CreateConnectionViewRequest.ConnectionViewDescriptor descriptor = new CreateConnectionViewRequest.ConnectionViewDescriptor(nextLinkDescriptor.getSemanticAdapter(), null, -1, false, ((IGraphicalEditPart)this.getHost()).getDiagramPreferencesHint());
            CreateConnectionViewRequest ccr = new CreateConnectionViewRequest(descriptor);
            ccr.setType((Object)"connection start");
            ccr.setSourceEditPart(sourceEditPart);
            sourceEditPart.getCommand((Request)ccr);
            ccr.setTargetEditPart(targetEditPart);
            ccr.setType((Object)"connection end");
            Command cmd = targetEditPart.getCommand((Request)ccr);
            if (cmd == null || !cmd.canExecute()) continue;
            this.executeCommand(cmd);
            IAdaptable viewAdapter = (IAdaptable)ccr.getNewObject();
            if (viewAdapter == null) continue;
            adapters.add(viewAdapter);
        }
        return adapters;
    }

    private EditPart getEditPart(EObject domainModelElement, Domain2Notation domain2NotationMap) {
        View view = domain2NotationMap.get(domainModelElement);
        if (view != null) {
            return (EditPart)this.getHost().getViewer().getEditPartRegistry().get(view);
        }
        return null;
    }

    private EditPart getSourceEditPart(UMLLinkDescriptor descriptor, Domain2Notation domain2NotationMap) {
        return this.getEditPart(descriptor.getSource(), domain2NotationMap);
    }

    private EditPart getTargetEditPart(UMLLinkDescriptor descriptor, Domain2Notation domain2NotationMap) {
        return this.getEditPart(descriptor.getDestination(), domain2NotationMap);
    }

    protected final EditPart getHintedEditPart(EObject domainModelElement, Domain2Notation domain2NotationMap, int hintVisualId) {
        View view = domain2NotationMap.getHinted(domainModelElement, UMLVisualIDRegistry.getType(hintVisualId));
        if (view != null) {
            return (EditPart)this.getHost().getViewer().getEditPartRegistry().get(view);
        }
        return null;
    }

    private static class Domain2Notation {
        private final HashMap myMap = new HashMap();

        private Domain2Notation() {
        }

        public boolean containsDomainElement(EObject domainElement) {
            return this.myMap.containsKey(domainElement);
        }

        public boolean containsKey(EObject domainElement) {
            return this.containsDomainElement(domainElement);
        }

        public void put(EObject domainElement, View view) {
            Object viewOrList = this.myMap.get(domainElement);
            if (viewOrList instanceof View) {
                this.myMap.remove(domainElement);
                LinkedList<View> list = new LinkedList<View>();
                list.add((View)viewOrList);
                this.myMap.put(domainElement, list);
                list.add(view);
            } else if (viewOrList instanceof List) {
                ((List)viewOrList).add(view);
            } else {
                this.myMap.put(domainElement, view);
            }
        }

        public View get(EObject domainEObject) {
            Object viewOrList = this.myMap.get(domainEObject);
            if (viewOrList instanceof View) {
                return (View)viewOrList;
            }
            if (viewOrList instanceof List) {
                for (Object next : (List)viewOrList) {
                    View nextView = (View)next;
                    if (nextView.getEAnnotation("Shortcut") != null) continue;
                    return nextView;
                }
                return (View)((List)viewOrList).get(0);
            }
            return null;
        }

        public View getHinted(EObject domainEObject, String hint) {
            if (hint == null) {
                return this.get(domainEObject);
            }
            Object viewOrList = this.myMap.get(domainEObject);
            if (viewOrList instanceof View) {
                return (View)viewOrList;
            }
            for (Object next : (List)viewOrList) {
                View nextView = (View)next;
                if (!hint.equals(nextView.getType())) continue;
                return nextView;
            }
            return (View)((List)viewOrList).get(0);
        }
    }
}

