/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.usecase.edit.policies;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.commands.DeleteCommand;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.commands.CommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.SemanticEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.requests.EditCommandRequestWrapper;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IEditHelperContext;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyReferenceRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DuplicateElementsRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.GetEditContextRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.MoveRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientReferenceRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.uml2.diagram.usecase.expressions.UMLAbstractExpression;
import org.eclipse.uml2.diagram.usecase.expressions.UMLOCLFactory;
import org.eclipse.uml2.diagram.usecase.part.UMLDiagramEditorPlugin;
import org.eclipse.uml2.diagram.usecase.part.UMLVisualIDRegistry;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.UseCase;

public class UMLBaseItemSemanticEditPolicy
extends SemanticEditPolicy {
    public static final String VISUAL_ID_KEY = "visual_id";

    public Command getCommand(Request request) {
        Object view;
        if (request instanceof ReconnectRequest && (view = ((ReconnectRequest)request).getConnectionEditPart().getModel()) instanceof View) {
            Integer id = new Integer(UMLVisualIDRegistry.getVisualID((View)view));
            request.getExtendedData().put(VISUAL_ID_KEY, id);
        }
        return super.getCommand(request);
    }

    protected int getVisualID(IEditCommandRequest request) {
        Object id = request.getParameter(VISUAL_ID_KEY);
        return id instanceof Integer ? (Integer)id : -1;
    }

    protected Command getSemanticCommand(IEditCommandRequest request) {
        TransactionalEditingDomain editingDomain;
        ICommand command;
        Command semanticCommand;
        IElementType elementType;
        IEditCommandRequest completedRequest = this.completeRequest(request);
        Object editHelperContext = completedRequest.getEditHelperContext();
        if (editHelperContext instanceof View || editHelperContext instanceof IEditHelperContext && ((IEditHelperContext)editHelperContext).getEObject() instanceof View) {
            return null;
        }
        if (editHelperContext == null) {
            editHelperContext = ViewUtil.resolveSemanticElement((View)((View)this.getHost().getModel()));
        }
        if ((elementType = ElementTypeRegistry.getInstance().getElementType(editHelperContext)) == ElementTypeRegistry.getInstance().getType("org.eclipse.gmf.runtime.emf.type.core.default")) {
            elementType = null;
        }
        if ((semanticCommand = this.getSemanticCommandSwitch(completedRequest)) != null) {
            command = semanticCommand instanceof ICommandProxy ? ((ICommandProxy)semanticCommand).getICommand() : new CommandProxy(semanticCommand);
            completedRequest.setParameter("edit policy command", (Object)command);
        }
        if (elementType != null && (command = elementType.getEditCommand(completedRequest)) != null) {
            if (!(command instanceof CompositeTransactionalCommand)) {
                editingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
                command = new CompositeTransactionalCommand(editingDomain, null).compose((IUndoableOperation)command);
            }
            semanticCommand = new ICommandProxy(command);
        }
        boolean shouldProceed = true;
        if (completedRequest instanceof DestroyRequest) {
            shouldProceed = this.shouldProceed((DestroyRequest)completedRequest);
        }
        if (shouldProceed) {
            if (completedRequest instanceof DestroyRequest) {
                editingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
                ICommandProxy deleteViewCommand = new ICommandProxy((ICommand)new DeleteCommand(editingDomain, (View)this.getHost().getModel()));
                semanticCommand = semanticCommand == null ? deleteViewCommand : semanticCommand.chain((Command)deleteViewCommand);
            }
            return semanticCommand;
        }
        return null;
    }

    protected Command getSemanticCommandSwitch(IEditCommandRequest req) {
        if (req instanceof CreateRelationshipRequest) {
            return this.getCreateRelationshipCommand((CreateRelationshipRequest)req);
        }
        if (req instanceof CreateElementRequest) {
            return this.getCreateCommand((CreateElementRequest)req);
        }
        if (req instanceof ConfigureRequest) {
            return this.getConfigureCommand((ConfigureRequest)req);
        }
        if (req instanceof DestroyElementRequest) {
            return this.getDestroyElementCommand((DestroyElementRequest)req);
        }
        if (req instanceof DestroyReferenceRequest) {
            return this.getDestroyReferenceCommand((DestroyReferenceRequest)req);
        }
        if (req instanceof DuplicateElementsRequest) {
            return this.getDuplicateCommand((DuplicateElementsRequest)req);
        }
        if (req instanceof GetEditContextRequest) {
            return this.getEditContextCommand((GetEditContextRequest)req);
        }
        if (req instanceof MoveRequest) {
            return this.getMoveCommand((MoveRequest)req);
        }
        if (req instanceof ReorientReferenceRelationshipRequest) {
            return this.getReorientReferenceRelationshipCommand((ReorientReferenceRelationshipRequest)req);
        }
        if (req instanceof ReorientRelationshipRequest) {
            return this.getReorientRelationshipCommand((ReorientRelationshipRequest)req);
        }
        if (req instanceof SetRequest) {
            return this.getSetCommand((SetRequest)req);
        }
        return null;
    }

    protected Command getConfigureCommand(ConfigureRequest req) {
        return null;
    }

    protected Command getCreateRelationshipCommand(CreateRelationshipRequest req) {
        return null;
    }

    protected Command getCreateCommand(CreateElementRequest req) {
        return null;
    }

    protected Command getSetCommand(SetRequest req) {
        return null;
    }

    protected Command getEditContextCommand(GetEditContextRequest req) {
        return null;
    }

    protected Command getDestroyElementCommand(DestroyElementRequest req) {
        return null;
    }

    protected Command getDestroyReferenceCommand(DestroyReferenceRequest req) {
        return null;
    }

    protected Command getDuplicateCommand(DuplicateElementsRequest req) {
        return null;
    }

    protected Command getMoveCommand(MoveRequest req) {
        return null;
    }

    protected Command getReorientReferenceRelationshipCommand(ReorientReferenceRelationshipRequest req) {
        return UnexecutableCommand.INSTANCE;
    }

    protected Command getReorientRelationshipCommand(ReorientRelationshipRequest req) {
        return UnexecutableCommand.INSTANCE;
    }

    protected final Command getGEFWrapper(ICommand cmd) {
        return new ICommandProxy(cmd);
    }

    protected final Command getMSLWrapper(ICommand cmd) {
        return this.getGEFWrapper(cmd);
    }

    protected EObject getSemanticElement() {
        return ViewUtil.resolveSemanticElement((View)((View)this.getHost().getModel()));
    }

    protected TransactionalEditingDomain getEditingDomain() {
        return ((IGraphicalEditPart)this.getHost()).getEditingDomain();
    }

    protected Command getDestroyElementCommand(View view) {
        EditPart editPart = (EditPart)this.getHost().getViewer().getEditPartRegistry().get(view);
        DestroyElementRequest request = new DestroyElementRequest(this.getEditingDomain(), false);
        return editPart.getCommand((Request)new EditCommandRequestWrapper((IEditCommandRequest)request, Collections.EMPTY_MAP));
    }

    protected CompoundCommand getDestroyEdgesCommand() {
        CompoundCommand cmd = new CompoundCommand();
        View view = (View)this.getHost().getModel();
        Iterator it = view.getSourceEdges().iterator();
        while (it.hasNext()) {
            cmd.add(this.getDestroyElementCommand((View)((Edge)it.next())));
        }
        it = view.getTargetEdges().iterator();
        while (it.hasNext()) {
            cmd.add(this.getDestroyElementCommand((View)((Edge)it.next())));
        }
        return cmd;
    }

    protected void addDestroyShortcutsCommand(CompoundCommand command) {
        View view = (View)this.getHost().getModel();
        if (view.getEAnnotation("Shortcut") != null) {
            return;
        }
        for (View nextView : view.getDiagram().getChildren()) {
            if (nextView.getEAnnotation("Shortcut") == null || !nextView.isSetElement() || nextView.getElement() != view.getElement()) continue;
            command.add(this.getDestroyElementCommand(nextView));
        }
    }

    public static class LinkConstraints {
        private static final String OPPOSITE_END_VAR = "oppositeEnd";
        private static final UMLAbstractExpression Generalization_4003_SourceExpression;
        private static final UMLAbstractExpression Generalization_4003_TargetExpression;
        private static final UMLAbstractExpression Association_4004_SourceExpression;
        private static final UMLAbstractExpression Association_4004_TargetExpression;

        static {
            HashMap<String, EClass> env = new HashMap<String, EClass>(3);
            env.put(OPPOSITE_END_VAR, UMLPackage.eINSTANCE.getClassifier());
            Generalization_4003_SourceExpression = UMLOCLFactory.getExpression("self.oclIsKindOf(uml::Actor) or self.oclIsKindOf(uml::UseCase) ", (EClassifier)UMLPackage.eINSTANCE.getClassifier(), env);
            env = new HashMap(3);
            env.put(OPPOSITE_END_VAR, UMLPackage.eINSTANCE.getClassifier());
            Generalization_4003_TargetExpression = UMLOCLFactory.getExpression("self.oclIsKindOf(uml::Actor) or self.oclIsKindOf(uml::UseCase) ", (EClassifier)UMLPackage.eINSTANCE.getClassifier(), env);
            env = new HashMap(3);
            env.put(OPPOSITE_END_VAR, UMLPackage.eINSTANCE.getType());
            Association_4004_SourceExpression = UMLOCLFactory.getExpression("self.oclIsKindOf(uml::Actor) or self.oclIsKindOf(uml::UseCase) ", (EClassifier)UMLPackage.eINSTANCE.getType(), env);
            env = new HashMap(3);
            env.put(OPPOSITE_END_VAR, UMLPackage.eINSTANCE.getType());
            Association_4004_TargetExpression = UMLOCLFactory.getExpression("self.oclIsKindOf(uml::Actor) or self.oclIsKindOf(uml::UseCase) ", (EClassifier)UMLPackage.eINSTANCE.getType(), env);
        }

        public static boolean canCreateInclude_4001(UseCase container, UseCase source, UseCase target) {
            return LinkConstraints.canExistInclude_4001(container, source, target);
        }

        public static boolean canCreateExtend_4002(UseCase container, UseCase source, UseCase target) {
            return LinkConstraints.canExistExtend_4002(container, source, target);
        }

        public static boolean canCreateGeneralization_4003(Classifier container, Classifier source, Classifier target) {
            return LinkConstraints.canExistGeneralization_4003(container, source, target);
        }

        public static boolean canCreateAssociation_4004(Package container, Type source, Type target) {
            return LinkConstraints.canExistAssociation_4004(container, source, target);
        }

        public static boolean canCreateConstraintConstrainedElement_4005(Constraint source, Element target) {
            if (source != null && source.getConstrainedElements().contains((Object)target)) {
                return false;
            }
            return LinkConstraints.canExistConstraintConstrainedElement_4005(source, target);
        }

        public static boolean canExistInclude_4001(UseCase container, UseCase source, UseCase target) {
            return true;
        }

        public static boolean canExistExtend_4002(UseCase container, UseCase source, UseCase target) {
            return true;
        }

        public static boolean canExistGeneralization_4003(Classifier container, Classifier source, Classifier target) {
            if (!LinkConstraints.evaluate(Generalization_4003_SourceExpression, source, target, false)) {
                return false;
            }
            return LinkConstraints.evaluate(Generalization_4003_TargetExpression, target, source, true);
        }

        public static boolean canExistAssociation_4004(Package container, Type source, Type target) {
            if (!LinkConstraints.evaluate(Association_4004_SourceExpression, source, target, false)) {
                return false;
            }
            return LinkConstraints.evaluate(Association_4004_TargetExpression, target, source, true);
        }

        public static boolean canExistConstraintConstrainedElement_4005(Constraint source, Element target) {
            return true;
        }

        private static boolean evaluate(UMLAbstractExpression constraint, Object sourceEnd, Object oppositeEnd, boolean clearEnv) {
            if (sourceEnd == null) {
                return true;
            }
            Map<String, Object> evalEnv = Collections.singletonMap(OPPOSITE_END_VAR, oppositeEnd);
            try {
                Object val = constraint.evaluate(sourceEnd, evalEnv);
                return val instanceof Boolean ? (Boolean)val : false;
            }
            catch (Exception e) {
                UMLDiagramEditorPlugin.getInstance().logError("Link constraint evaluation error", e);
                return false;
            }
        }
    }
}

