/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.uml.internal.operations;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Include;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPlugin;
import org.eclipse.uml2.uml.UseCase;
import org.eclipse.uml2.uml.internal.operations.BehavioredClassifierOperations;

public class UseCaseOperations
extends BehavioredClassifierOperations {
    protected UseCaseOperations() {
    }

    public static boolean validateMustHaveName(UseCase useCase, DiagnosticChain diagnostics, Map context) {
        if (UseCaseOperations.isEmpty((String)useCase.getName())) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.uml2.uml", 136, UMLPlugin.INSTANCE.getString("_UI_UseCase_MustHaveName_diagnostic", UseCaseOperations.getMessageSubstitutions((Map)context, (Object)useCase)), new Object[]{useCase}));
            }
            return false;
        }
        return true;
    }

    public static boolean validateBinaryAssociations(UseCase useCase, DiagnosticChain diagnostics, Map context) {
        Iterator a = useCase.getAssociations().iterator();
        while (a.hasNext()) {
            if (((Association)a.next()).isBinary()) continue;
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.uml2.uml", 137, UMLPlugin.INSTANCE.getString("_UI_UseCase_BinaryAssociations_diagnostic", UseCaseOperations.getMessageSubstitutions((Map)context, (Object)useCase)), new Object[]{useCase}));
            }
            return false;
        }
        return true;
    }

    public static boolean validateNoAssociationToUseCase(UseCase useCase, DiagnosticChain diagnostics, Map context) {
        Iterator a = useCase.getAssociations().iterator();
        while (a.hasNext()) {
            EList endTypes = ((Association)a.next()).getEndTypes();
            if (endTypes.size() != 2) continue;
            Type end1 = (Type)endTypes.get(0);
            Type end2 = (Type)endTypes.get(1);
            if (!(end1 instanceof UseCase) || !(end2 instanceof UseCase)) continue;
            UseCase useCase1 = (UseCase)end1;
            UseCase useCase2 = (UseCase)end2;
            UniqueEList.FastCompare subjects = new UniqueEList.FastCompare((Collection)useCase1.getSubjects());
            subjects.retainAll((Collection)useCase2.getSubjects());
            if (subjects.isEmpty()) continue;
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.uml2.uml", 138, UMLPlugin.INSTANCE.getString("_UI_UseCase_NoAssociationToUseCase_diagnostic", UseCaseOperations.getMessageSubstitutions((Map)context, (Object)useCase1, (Object)useCase2)), new Object[]{useCase1, useCase2}));
            }
            return false;
        }
        return true;
    }

    public static boolean validateCannotIncludeSelf(UseCase useCase, DiagnosticChain diagnostics, Map context) {
        if (useCase.allIncludedUseCases().contains((Object)useCase)) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.uml2.uml", 139, UMLPlugin.INSTANCE.getString("_UI_UseCase_CannotIncludeSelf_diagnostic", UseCaseOperations.getMessageSubstitutions((Map)context, (Object)useCase)), new Object[]{useCase}));
            }
            return false;
        }
        return true;
    }

    protected static EList allIncludedUseCases(UseCase useCase, EList allIncludedUseCases) {
        Iterator includes = useCase.getIncludes().iterator();
        while (includes.hasNext()) {
            UseCase addition = ((Include)includes.next()).getAddition();
            if (addition == null || !allIncludedUseCases.add((Object)addition)) continue;
            UseCaseOperations.allIncludedUseCases(addition, allIncludedUseCases);
        }
        return allIncludedUseCases;
    }

    public static EList allIncludedUseCases(UseCase useCase) {
        return ECollections.unmodifiableEList((EList)UseCaseOperations.allIncludedUseCases(useCase, (EList)new UniqueEList.FastCompare()));
    }
}

