/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ocl.types.impl;

import java.util.Collection;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.impl.EClassifierImpl;
import org.eclipse.emf.ocl.expressions.OCLExpression;
import org.eclipse.emf.ocl.expressions.TypeExp;
import org.eclipse.emf.ocl.internal.parser.CompatibilityParser;
import org.eclipse.emf.ocl.parser.SemanticException;
import org.eclipse.emf.ocl.types.AnyType;
import org.eclipse.emf.ocl.types.CollectionType;
import org.eclipse.emf.ocl.types.PrimitiveType;
import org.eclipse.emf.ocl.types.TupleType;
import org.eclipse.emf.ocl.types.TypesPackage;
import org.eclipse.emf.ocl.types.impl.CollectionTypeImpl;
import org.eclipse.emf.ocl.types.impl.PrimitiveTypeImpl;
import org.eclipse.emf.ocl.types.impl.TupleTypeImpl;
import org.eclipse.emf.ocl.types.impl.TypeUtil;
import org.eclipse.emf.ocl.types.util.Types;
import org.eclipse.ocl.internal.l10n.OCLMessages;

public class AnyTypeImpl
extends EClassifierImpl
implements AnyType {
    public static final String copyright = "";
    public static AnyType INSTANCE = new AnyTypeImpl("OclAny");
    public static EClassifier OCL_T = new AnyTypeImpl("T");
    public static EClassifier OCL_T2 = new AnyTypeImpl("T2");
    public static EClassifier UML_CLASSIFIER = EcorePackage.Literals.ECLASSIFIER;
    private static EList anyOperations = null;
    private static EList operations = null;

    protected static EList createAnyOperations() {
        if (anyOperations == null) {
            anyOperations = new BasicEList();
            anyOperations.add((Object)TypeUtil.createBinaryOperation((EClassifier)Types.OCL_BOOLEAN, "=", Types.OCL_ANY_TYPE, "object"));
            anyOperations.add((Object)TypeUtil.createBinaryOperation((EClassifier)Types.OCL_BOOLEAN, "<>", Types.OCL_ANY_TYPE, "object"));
            anyOperations.add((Object)TypeUtil.createBinaryOperation(OCL_T, "oclAsType", Types.OCL_TYPE, "typespec"));
            anyOperations.add((Object)TypeUtil.createBinaryOperation((EClassifier)Types.OCL_BOOLEAN, "oclIsKindOf", Types.OCL_TYPE, "typespec"));
            anyOperations.add((Object)TypeUtil.createBinaryOperation((EClassifier)Types.OCL_BOOLEAN, "oclIsTypeOf", Types.OCL_TYPE, "typespec"));
            anyOperations.add((Object)TypeUtil.createUnaryOperation((EClassifier)Types.OCL_BOOLEAN, "oclIsUndefined"));
            anyOperations.add((Object)TypeUtil.createUnaryOperation((EClassifier)Types.OCL_BOOLEAN, "oclIsInvalid"));
            anyOperations.add((Object)TypeUtil.createUnaryOperation((EClassifier)Types.OCL_BOOLEAN, "oclIsNew"));
            anyOperations.add((Object)TypeUtil.createBinaryOperation((EClassifier)Types.OCL_BOOLEAN, "oclIsInState", (EClassifier)Types.STATE, "statespec"));
        }
        return anyOperations;
    }

    protected static EList createOperations() {
        if (operations == null) {
            operations = new BasicEList();
            operations.addAll((Collection)AnyTypeImpl.createAnyOperations());
            operations.add((Object)TypeUtil.createBinaryOperation((EClassifier)Types.OCL_BOOLEAN, "<", OCL_T, "object"));
            operations.add((Object)TypeUtil.createBinaryOperation((EClassifier)Types.OCL_BOOLEAN, ">", OCL_T, "object"));
            operations.add((Object)TypeUtil.createBinaryOperation((EClassifier)Types.OCL_BOOLEAN, "<=", OCL_T, "object"));
            operations.add((Object)TypeUtil.createBinaryOperation((EClassifier)Types.OCL_BOOLEAN, ">=", OCL_T, "object"));
        }
        return operations;
    }

    public int getOperationCodeFor(String operName) {
        return AnyTypeImpl.getOperationCode(operName);
    }

    public static int getOperationCode(String operName) {
        if (operName.equals("=")) {
            return 60;
        }
        if (operName.equals("<>")) {
            return 61;
        }
        if (operName.equals("oclAsType")) {
            return 62;
        }
        if (operName.equals("oclIsKindOf")) {
            return 63;
        }
        if (operName.equals("oclIsTypeOf")) {
            return 64;
        }
        if (operName.equals("oclIsUndefined")) {
            return 65;
        }
        if (operName.equals("oclIsInvalid")) {
            return 66;
        }
        if (operName.equals("<")) {
            return 67;
        }
        if (operName.equals(">")) {
            return 68;
        }
        if (operName.equals("<=")) {
            return 69;
        }
        if (operName.equals(">=")) {
            return 70;
        }
        if (operName.equals("oclIsNew")) {
            return 71;
        }
        if (operName.equals("oclIsInState")) {
            return 72;
        }
        return 0;
    }

    public String getOperationNameFor(int opcode) {
        return AnyTypeImpl.getOperationName(opcode);
    }

    public static String getOperationName(int opcode) {
        switch (opcode) {
            case 60: {
                return "=";
            }
            case 61: {
                return "<>";
            }
            case 62: {
                return "oclAsType";
            }
            case 63: {
                return "oclIsKindOf";
            }
            case 64: {
                return "oclIsTypeOf";
            }
            case 65: {
                return "oclIsUndefined";
            }
            case 66: {
                return "oclIsInvalid";
            }
            case 67: {
                return "<";
            }
            case 68: {
                return ">";
            }
            case 69: {
                return "<=";
            }
            case 70: {
                return ">=";
            }
            case 71: {
                return "oclIsNew";
            }
            case 72: {
                return "oclIsInState";
            }
        }
        return copyright;
    }

    public EClassifier getResultTypeFor(EClassifier ownerType, int opcode, EList args) throws SemanticException {
        return AnyTypeImpl.getResultType(ownerType, opcode, args);
    }

    public int getRelationshipTo(EClassifier type) {
        if (this == type) {
            return 1;
        }
        if (!(type instanceof CollectionType)) {
            return 4;
        }
        return 8;
    }

    public EClassifier getCommonSupertype(EClassifier type) throws SemanticException {
        if (!(type instanceof CollectionType)) {
            return this;
        }
        String message = OCLMessages.bind((String)OCLMessages.TypeMismatch_ERROR_, (Object)this.getName(), (Object)TypeUtil.getName((ENamedElement)type));
        CompatibilityParser.ERR(message);
        return null;
    }

    public static EClassifier getResultType(EClassifier type, int opcode, EList args) throws SemanticException {
        switch (opcode) {
            case 60: 
            case 61: {
                OCLExpression arg = (OCLExpression)args.get(0);
                EClassifier argType = arg.getType();
                if (type == Types.INVALID) {
                    return Types.OCL_BOOLEAN;
                }
                if (type instanceof EEnum) {
                    if (type != argType && argType != Types.OCL_ANY_TYPE) {
                        String message = OCLMessages.bind((String)OCLMessages.Noncomforming_ERROR_, (Object)type.getName(), (Object)AnyTypeImpl.getOperationName(opcode));
                        CompatibilityParser.ERR(message);
                    }
                } else if (type instanceof TupleType) {
                    ((TupleTypeImpl)type).getCommonSupertype(argType);
                } else if (type instanceof PrimitiveType && !((argType = (arg = (OCLExpression)args.get(0)).getType()) instanceof PrimitiveType) && argType != Types.OCL_ANY_TYPE && argType != Types.INVALID && argType != Types.OCL_VOID) {
                    String message = OCLMessages.bind((String)OCLMessages.Noncomforming_ERROR_, (Object)type.getName(), (Object)AnyTypeImpl.getOperationName(opcode));
                    CompatibilityParser.ERR(message);
                }
                return Types.OCL_BOOLEAN;
            }
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                if (!(type instanceof EClass)) {
                    if (TypeUtil.isComparable(type)) {
                        return Types.OCL_BOOLEAN;
                    }
                    String message = OCLMessages.bind((String)OCLMessages.SourceEClass_ERROR_, (Object)AnyTypeImpl.getOperationName(opcode));
                    CompatibilityParser.ERR(message);
                }
                EOperation oper = null;
                try {
                    oper = TypeUtil.findOperationMatching(type, PrimitiveTypeImpl.getOperationName(opcode), args);
                    if (oper == null) {
                        oper = TypeUtil.findOperationMatching(type, "compareTo", args);
                    }
                }
                catch (Exception exception) {
                    String message = OCLMessages.bind((String)OCLMessages.SourceOperationCompareTo_ERROR_, (Object)AnyTypeImpl.getOperationName(opcode));
                    CompatibilityParser.ERR(message);
                }
                if (oper != null && "compareTo".equals(oper.getName()) && TypeUtil.getOCLType((ETypedElement)oper) != Types.OCL_INTEGER) {
                    CompatibilityParser.ERR(OCLMessages.ResultCompareToInt_ERROR_);
                }
            }
            case 63: 
            case 64: 
            case 71: 
            case 72: {
                return Types.OCL_BOOLEAN;
            }
            case 62: {
                TypeExp typeExp = (TypeExp)args.get(0);
                EClassifier argEType = typeExp.getReferredType();
                if (type instanceof CollectionType) {
                    String message = OCLMessages.bind((String)OCLMessages.Noncomforming_ERROR_, (Object)type.getName(), (Object)AnyTypeImpl.getOperationName(opcode));
                    CompatibilityParser.ERR(message);
                }
                return argEType;
            }
            case 65: 
            case 66: {
                return Types.OCL_BOOLEAN;
            }
        }
        return null;
    }

    public static boolean equal(Object anObject, Object anotherObject) {
        if (anObject == null || anotherObject == null) {
            return anObject == anotherObject;
        }
        if (anObject == Types.OCL_INVALID || anotherObject == Types.OCL_INVALID) {
            return anObject == anotherObject;
        }
        if (TypeUtil.isPrimitive(anObject) || TypeUtil.isPrimitive(anotherObject)) {
            if (anObject instanceof Integer && anotherObject instanceof Integer) {
                return ((Integer)anObject).intValue() == ((Integer)anotherObject).intValue();
            }
            if (anObject instanceof Integer && anotherObject instanceof Double) {
                return (double)((Integer)anObject).intValue() == (Double)anotherObject;
            }
            if (anObject instanceof Double && anotherObject instanceof Integer) {
                return (Double)anObject == (double)((Integer)anotherObject).intValue();
            }
            if (anObject instanceof Double && anotherObject instanceof Double) {
                return ((Double)anObject).doubleValue() == ((Double)anotherObject).doubleValue();
            }
            if (anObject instanceof String && anotherObject instanceof String) {
                return anObject.equals(anotherObject);
            }
            if (anObject instanceof Boolean && anotherObject instanceof Boolean) {
                return anObject.equals(anotherObject);
            }
            return false;
        }
        if (anObject instanceof EEnumLiteral && anotherObject instanceof EEnumLiteral) {
            return anObject == anotherObject;
        }
        if (anObject instanceof EEnumLiteral && anotherObject instanceof Enumerator) {
            return ((EEnumLiteral)anObject).getInstance() == anotherObject;
        }
        if (anotherObject instanceof EEnumLiteral && anObject instanceof Enumerator) {
            return ((EEnumLiteral)anotherObject).getInstance() == anObject;
        }
        if (anObject instanceof Collection && anotherObject instanceof Collection) {
            return CollectionTypeImpl.equals((Collection)anObject, (Collection)anotherObject);
        }
        return anObject.equals(anotherObject);
    }

    public static int hashCode(Object anObject) {
        if (anObject == null) {
            return 0;
        }
        if (TypeUtil.isPrimitive(anObject)) {
            if (anObject instanceof Integer) {
                return 37 * (Integer)anObject;
            }
            if (anObject instanceof Double) {
                return 37 * ((Double)anObject).intValue();
            }
            if (anObject instanceof String) {
                return anObject.hashCode();
            }
            if (anObject instanceof Boolean) {
                return anObject.hashCode();
            }
            return 0;
        }
        if (anObject instanceof EEnumLiteral) {
            return ((EEnumLiteral)anObject).getInstance().hashCode();
        }
        if (anObject instanceof Collection) {
            return CollectionTypeImpl.hashCode((Collection)anObject);
        }
        return anObject.hashCode();
    }

    public EList getOperations() {
        if (operations == null) {
            return AnyTypeImpl.createOperations();
        }
        return operations;
    }

    protected AnyTypeImpl() {
        this.setInstanceClass(Object.class);
    }

    protected AnyTypeImpl(String name) {
        this();
        this.setName(name);
    }

    protected EClass eStaticClass() {
        return TypesPackage.Literals.ANY_TYPE;
    }
}

