/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ocl.types.impl;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.impl.EClassifierImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ocl.internal.parser.CompatibilityParser;
import org.eclipse.emf.ocl.parser.SemanticException;
import org.eclipse.emf.ocl.types.InvalidType;
import org.eclipse.emf.ocl.types.TypesPackage;
import org.eclipse.emf.ocl.types.impl.AnyTypeImpl;
import org.eclipse.emf.ocl.types.impl.TypeUtil;
import org.eclipse.emf.ocl.types.util.Types;
import org.eclipse.ocl.internal.l10n.OCLMessages;

public class InvalidTypeImpl
extends EClassifierImpl
implements InvalidType {
    public static final String copyright = "";
    public static final Object OCL_INVALID = new EObjectImpl(){

        public EClass eClass() {
            return (EClass)Types.INVALID;
        }

        public String toString() {
            return "OclInvalid";
        }
    };

    protected InvalidTypeImpl() {
    }

    public InvalidTypeImpl(String name) {
        this.setName(name);
        this.setClassifierID(4);
    }

    protected EClass eStaticClass() {
        return TypesPackage.Literals.INVALID_TYPE;
    }

    public EClassifier getResultTypeFor(EClassifier ownerType, int opcode, EList args) throws SemanticException {
        return AnyTypeImpl.getResultType(ownerType, opcode, args);
    }

    public int getRelationshipTo(EClassifier type) {
        if (type == Types.INVALID) {
            return 1;
        }
        if (type != Types.OCL_VOID) {
            return 2;
        }
        return 8;
    }

    public EClassifier getCommonSupertype(EClassifier type) throws SemanticException {
        if (type == Types.INVALID) {
            return Types.INVALID;
        }
        if (type != Types.OCL_VOID) {
            return type;
        }
        String message = OCLMessages.bind((String)OCLMessages.TypeMismatch_ERROR_, (Object)this.getName(), (Object)TypeUtil.getName((ENamedElement)type));
        CompatibilityParser.ERR(message);
        return null;
    }

    public int getOperationCodeFor(String operName) {
        return AnyTypeImpl.getOperationCode(operName);
    }

    public String getOperationNameFor(int opcode) {
        return AnyTypeImpl.getOperationName(opcode);
    }

    public EList getOperations() {
        return AnyTypeImpl.createAnyOperations();
    }
}

