/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eodm.owl.transformer;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.eodm.OWLFactory;
import org.eclipse.eodm.RDFFactory;
import org.eclipse.eodm.exceptions.UnsupportedViewTypeException;
import org.eclipse.eodm.owl.owlbase.CardinalityRestriction;
import org.eclipse.eodm.owl.owlbase.EnumeratedClass;
import org.eclipse.eodm.owl.owlbase.Individual;
import org.eclipse.eodm.owl.owlbase.MaxCardinalityRestriction;
import org.eclipse.eodm.owl.owlbase.MinCardinalityRestriction;
import org.eclipse.eodm.owl.owlbase.OWLClass;
import org.eclipse.eodm.owl.owlbase.OWLDatatypeProperty;
import org.eclipse.eodm.owl.owlbase.OWLGraph;
import org.eclipse.eodm.owl.owlbase.OWLObjectProperty;
import org.eclipse.eodm.owl.resource.OWLXMLSaver;
import org.eclipse.eodm.owl.transformer.EODMOWLTransformerException;
import org.eclipse.eodm.rdf.rdfbase.PlainLiteral;
import org.eclipse.eodm.rdf.rdfbase.RDFGraph;
import org.eclipse.eodm.rdf.rdfbase.RDFProperty;
import org.eclipse.eodm.rdf.rdfbase.RDFSResource;
import org.eclipse.eodm.rdf.rdfbase.TypedLiteral;
import org.eclipse.eodm.rdf.rdfs.RDFSDatatype;
import org.eclipse.eodm.rdf.rdfweb.Document;

public class Ecore2OWL {
    private static String XSD_BOOLEAN = "http://www.w3.org/2001/XMLSchema#boolean";
    private static String XSD_FLOAT = "http://www.w3.org/2001/XMLSchema#float";
    private static String XSD_BYTE = "http://www.w3.org/2001/XMLSchema#byte";
    private static String XSD_INT = "http://www.w3.org/2001/XMLSchema#int";
    private static String XSD_LONG = "http://www.w3.org/2001/XMLSchema#long";
    private static String XSD_DOUBLE = "http://www.w3.org/2001/XMLSchema#double";
    private static String XSD_SHORT = "http://www.w3.org/2001/XMLSchema#short";
    private static String XSD_INTEGER = "http://www.w3.org/2001/XMLSchema#integer";
    private static String XSD_STRING = "http://www.w3.org/2001/XMLSchema#string";
    private static String XSD_NON_NEGATIVE_INT = "http://www.w3.org/2001/XMLSchema#nonNegativeInteger";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public static void ecore2OWL(String ecoreFilePath, String owlFilePath, Map options) throws EODMOWLTransformerException {
        OWLGraph graph = Ecore2OWL.ecore2OWL(ecoreFilePath, options);
        Ecore2OWL.saveOWLGraph(graph, owlFilePath, null);
    }

    public static OWLGraph ecore2OWL(String ecoreFilePath, Map options) throws EODMOWLTransformerException {
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getResource(URI.createFileURI((String)ecoreFilePath), true);
        File inputFile = new File(ecoreFilePath);
        URI absoluteInputURI = URI.createFileURI((String)inputFile.getAbsolutePath());
        Resource resource = resourceSet.getResource(absoluteInputURI, true);
        return Ecore2OWL.ecore2OWL(resource, options);
    }

    public static OWLGraph ecore2OWL(Resource ecoreResource, Map options) throws EODMOWLTransformerException {
        if (options == null) {
            options = Collections.EMPTY_MAP;
        }
        EPackage ePackage = (EPackage)ecoreResource.getContents().get(0);
        return Ecore2OWL.ecore2OWL(ePackage, options);
    }

    public static OWLGraph ecore2OWL(EPackage ePackage, Map options) throws EODMOWLTransformerException {
        OWLGraph graph = null;
        String nsUri = ePackage.getNsURI();
        try {
            OWLFactory factory = OWLFactory.eINSTANCE;
            graph = factory.createOWLGraph(nsUri);
            List eclassifierLst = Ecore2OWL.getEclassifier(ePackage);
            Iterator it = eclassifierLst.iterator();
            while (it.hasNext()) {
                EClassifier eclassifier = (EClassifier)it.next();
                RDFSResource rclass = Ecore2OWL.eclass2OWL(eclassifier, graph);
                if (!(eclassifier instanceof EClass)) continue;
                OWLClass oclass = (OWLClass)rclass;
                EClass eclass = (EClass)eclassifier;
                Iterator itSuper = eclass.getESuperTypes().iterator();
                while (itSuper.hasNext()) {
                    EClassifier eSuper = (EClassifier)itSuper.next();
                    if (eSuper.eIsProxy()) continue;
                    OWLClass parents = (OWLClass)Ecore2OWL.eclass2OWL(eSuper, graph);
                    parents.getSubClass().add((Object)rclass);
                }
                Iterator itAtt = eclass.getEAttributes().iterator();
                while (itAtt.hasNext()) {
                    EAttribute eatt = (EAttribute)itAtt.next();
                    if (eatt.eIsProxy()) continue;
                    OWLDatatypeProperty dp = Ecore2OWL.eatt2DP(eatt, graph);
                    dp.getRDFSdomain().add((Object)oclass);
                }
                Iterator itRef = eclass.getEReferences().iterator();
                while (itRef.hasNext()) {
                    EReference eref = (EReference)itRef.next();
                    OWLObjectProperty op = Ecore2OWL.eref2OP(eref, graph);
                    op.getRDFSdomain().add((Object)oclass);
                    int lowerBound = eref.getLowerBound();
                    int upperBound = eref.getUpperBound();
                    if (lowerBound > 0) {
                        if (upperBound == -1) {
                            oclass.getRDFSsubClassOf().add((Object)Ecore2OWL.createMinCardinarlity(graph, op, lowerBound));
                            continue;
                        }
                        if (lowerBound == upperBound) {
                            oclass.getRDFSsubClassOf().add((Object)Ecore2OWL.createCardinarlity(graph, op, lowerBound));
                            continue;
                        }
                        oclass.getRDFSsubClassOf().add((Object)Ecore2OWL.createMinCardinarlity(graph, op, lowerBound));
                        oclass.getRDFSsubClassOf().add((Object)Ecore2OWL.createMaxCardinarlity(graph, op, upperBound));
                        continue;
                    }
                    if (upperBound == -1) continue;
                    oclass.getRDFSsubClassOf().add((Object)Ecore2OWL.createMaxCardinarlity(graph, op, upperBound));
                }
            }
        }
        catch (URISyntaxException e) {
            throw new EODMOWLTransformerException("Something wrong when creating OWL Resource:" + e.getMessage());
        }
        return graph;
    }

    private static RDFSResource eclass2OWL(EClassifier eclassifier, OWLGraph graph) throws EODMOWLTransformerException {
        OWLFactory factory = OWLFactory.eINSTANCE;
        String uri = Ecore2OWL.getURI((ENamedElement)eclassifier);
        RDFSResource rsource = graph.getRDFSResource(uri);
        if (rsource == null) {
            try {
                if (eclassifier instanceof EClass) {
                    EClass eclass = (EClass)eclassifier;
                    OWLClass oclass = factory.createOWLClass(graph, uri);
                    oclass.getRDFScomment().addAll((Collection)Ecore2OWL.eAnnotation2Literal((ENamedElement)eclass));
                    oclass.getRDFSlabel().add((Object)RDFFactory.eINSTANCE.createPlainLiteral(eclass.getName()));
                    rsource = oclass;
                } else if (eclassifier instanceof EEnum) {
                    EEnum eenum = (EEnum)eclassifier;
                    EnumeratedClass enumclass = factory.createEnumeratedClass(graph, uri);
                    enumclass.getRDFScomment().addAll((Collection)Ecore2OWL.eAnnotation2Literal((ENamedElement)eenum));
                    enumclass.getRDFSlabel().add((Object)RDFFactory.eINSTANCE.createPlainLiteral(eenum.getName()));
                    Iterator et = eenum.getELiterals().iterator();
                    while (et.hasNext()) {
                        EEnumLiteral enumLiteral = (EEnumLiteral)et.next();
                        Individual individual = factory.createIndividual(graph, enumLiteral.getName());
                        individual.getRDFSlabel().add((Object)RDFFactory.eINSTANCE.createPlainLiteral(enumLiteral.getName()));
                        enumclass.getOWLoneOf().add((Object)individual);
                    }
                    rsource = enumclass;
                } else if (eclassifier instanceof EDataType) {
                    EDataType datatype = (EDataType)eclassifier;
                    RDFSDatatype rdatatype = RDFFactory.eINSTANCE.createRDFSDatatype((RDFGraph)graph, datatype.getName());
                    rdatatype.getRDFSlabel().add((Object)RDFFactory.eINSTANCE.createPlainLiteral(datatype.getName()));
                    rdatatype.getRDFScomment().addAll((Collection)Ecore2OWL.eAnnotation2Literal((ENamedElement)datatype));
                    rsource = rdatatype;
                }
            }
            catch (URISyntaxException e) {
                throw new EODMOWLTransformerException("Something wrong when creating OWL Resource:" + e.getMessage());
            }
        }
        return rsource;
    }

    private static OWLDatatypeProperty eatt2DP(EAttribute eatt, OWLGraph graph) throws EODMOWLTransformerException {
        OWLDatatypeProperty odp;
        block34: {
            OWLFactory factory = OWLFactory.eINSTANCE;
            odp = null;
            String uri = Ecore2OWL.getURI((ENamedElement)eatt);
            RDFSResource rsource = graph.getRDFSResource(uri);
            try {
                if (rsource == null) {
                    odp = factory.createOWLDatatypeProperty(graph, uri);
                } else {
                    RDFSResource rDFSResource = graph.getRDFSResource(uri);
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("org.eclipse.eodm.owl.owlbase.OWLDatatypeProperty");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (rDFSResource.canAsType((Class)clazz)) {
                        odp = (OWLDatatypeProperty)rsource;
                    }
                }
                EDataType etype = eatt.getEAttributeType();
                if (etype.eIsProxy()) break block34;
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.eclipse.emf.ecore.EEnum");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (!clazz.isInstance(etype)) {
                    String xsdName = null;
                    if (etype == EcorePackage.eINSTANCE.getEBooleanObject()) {
                        xsdName = XSD_BOOLEAN;
                    } else if (etype == EcorePackage.eINSTANCE.getEFloatObject()) {
                        xsdName = XSD_FLOAT;
                    } else if (etype == EcorePackage.eINSTANCE.getEByteObject()) {
                        xsdName = XSD_BYTE;
                    } else if (etype == EcorePackage.eINSTANCE.getEInt()) {
                        xsdName = XSD_INT;
                    } else if (etype == EcorePackage.eINSTANCE.getELongObject()) {
                        xsdName = XSD_LONG;
                    } else if (etype == EcorePackage.eINSTANCE.getEDoubleObject()) {
                        xsdName = XSD_DOUBLE;
                    } else if (etype == EcorePackage.eINSTANCE.getEShortObject()) {
                        xsdName = XSD_SHORT;
                    } else if (etype == EcorePackage.eINSTANCE.getEIntegerObject()) {
                        xsdName = XSD_INTEGER;
                    } else if (etype == EcorePackage.eINSTANCE.getEString()) {
                        xsdName = XSD_STRING;
                    }
                    if (xsdName != null) {
                        RDFSDatatype type = RDFFactory.eINSTANCE.createRDFSDatatype((RDFGraph)graph, xsdName);
                        odp.getRDFSrange().add((Object)type);
                    } else {
                        String euri = Ecore2OWL.getURI((ENamedElement)etype);
                        RDFSDatatype rtype = (RDFSDatatype)graph.getRDFSResource(euri);
                        if (rtype == null) {
                            rtype = RDFFactory.eINSTANCE.createRDFSDatatype((RDFGraph)graph, euri);
                        }
                        odp.getRDFSrange().add((Object)rtype);
                    }
                } else {
                    EnumeratedClass enumeratedClass = (EnumeratedClass)graph.getRDFSResource(Ecore2OWL.getURI((ENamedElement)etype));
                }
            }
            catch (URISyntaxException e) {
                throw new EODMOWLTransformerException("Something wrong when creating OWL Resource:" + e.getMessage());
            }
        }
        return odp;
    }

    private static OWLObjectProperty eref2OP(EReference eref, OWLGraph graph) throws EODMOWLTransformerException {
        OWLObjectProperty oop;
        block12: {
            String uri = Ecore2OWL.getURI((ENamedElement)eref);
            RDFSResource rs = graph.getRDFSResource(uri);
            oop = null;
            try {
                block15: {
                    block14: {
                        if (rs == null) break block14;
                        Class<?> clazz = class$2;
                        if (clazz == null) {
                            try {
                                clazz = class$2 = Class.forName("org.eclipse.eodm.owl.owlbase.OWLObjectProperty");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if (rs.canAsType((Class)clazz)) break block15;
                    }
                    oop = OWLFactory.eINSTANCE.createOWLObjectProperty(graph, uri);
                    EClass erange = eref.getEReferenceType();
                    if (!erange.eIsProxy()) {
                        OWLClass range = (OWLClass)Ecore2OWL.eclass2OWL((EClassifier)erange, graph);
                        oop.getRDFSrange().add((Object)range);
                    }
                    break block12;
                }
                Class<?> clazz = class$2;
                if (clazz == null) {
                    try {
                        clazz = class$2 = Class.forName("org.eclipse.eodm.owl.owlbase.OWLObjectProperty");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                oop = (OWLObjectProperty)rs.asType((Class)clazz);
            }
            catch (UnsupportedViewTypeException e) {
                throw new EODMOWLTransformerException("Cannot retrieve resource:" + e.getMessage());
            }
            catch (URISyntaxException e) {
                throw new EODMOWLTransformerException("Something wrong when creating OWL Resource:" + e.getMessage());
            }
        }
        return oop;
    }

    private static String getURI(ENamedElement elem) {
        ENamedElement nsOwner = elem;
        String ns = null;
        while (nsOwner != null) {
            if (nsOwner instanceof EPackage) {
                ns = ((EPackage)nsOwner).getNsURI();
                break;
            }
            nsOwner = nsOwner.eContainer();
        }
        return ns.endsWith("#") ? String.valueOf(ns) + elem.getName() : String.valueOf(ns) + "#" + elem.getName();
    }

    private static List eAnnotation2Literal(ENamedElement eNameElem) {
        ArrayList<PlainLiteral> alist = new ArrayList<PlainLiteral>();
        Iterator itAn = eNameElem.getEAnnotations().iterator();
        while (itAn.hasNext()) {
            EAnnotation an = (EAnnotation)itAn.next();
            if (an == null) continue;
            PlainLiteral literal = RDFFactory.eINSTANCE.createPlainLiteral(Ecore2OWL.eAnnotation2String(an));
            alist.add(literal);
        }
        return alist;
    }

    private static String eAnnotation2String(EAnnotation an) {
        String str = String.valueOf(an.getSource()) + ": ";
        EMap detail = an.getDetails();
        Iterator iter = detail.keySet().iterator();
        while (iter.hasNext()) {
            Object key = iter.next();
            str = String.valueOf(str) + "  " + key + ":" + detail.get(key);
        }
        return Ecore2OWL.replaceKeywords(str);
    }

    private static String replaceKeywords(String str) {
        str = str.replaceAll("&", "&amp;");
        str = str.replaceAll("<", "&lt;");
        str = str.replaceAll(">", "&gt;");
        str = str.replaceAll("'", "&apos;");
        str = str.replaceAll("\"", "&quot;");
        return str;
    }

    private static MinCardinalityRestriction createMinCardinarlity(OWLGraph graph, OWLObjectProperty property, int bound) throws EODMOWLTransformerException {
        MinCardinalityRestriction minCr = OWLFactory.eINSTANCE.createMinCardinalityRestriction(graph);
        try {
            TypedLiteral literal = RDFFactory.eINSTANCE.createTypedLiteral(Integer.toString(bound), XSD_NON_NEGATIVE_INT);
            minCr.setOWLonProperty((RDFProperty)property);
            minCr.setOWLminCardinality(literal);
        }
        catch (Exception e) {
            throw new EODMOWLTransformerException("Something wrong when creating OWL Resource:" + e.getMessage());
        }
        return minCr;
    }

    private static MaxCardinalityRestriction createMaxCardinarlity(OWLGraph graph, OWLObjectProperty property, int bound) throws EODMOWLTransformerException {
        MaxCardinalityRestriction maxCr = OWLFactory.eINSTANCE.createMaxCardinalityRestriction(graph);
        try {
            TypedLiteral literal = RDFFactory.eINSTANCE.createTypedLiteral(Integer.toString(bound), XSD_NON_NEGATIVE_INT);
            maxCr.setOWLonProperty((RDFProperty)property);
            maxCr.setOWLmaxCardinality(literal);
        }
        catch (Exception e) {
            throw new EODMOWLTransformerException("Something wrong when creating OWL Resource:" + e.getMessage());
        }
        return maxCr;
    }

    private static CardinalityRestriction createCardinarlity(OWLGraph graph, OWLObjectProperty property, int bound) throws EODMOWLTransformerException {
        CardinalityRestriction cr = OWLFactory.eINSTANCE.createCardinalityRestriction(graph);
        try {
            TypedLiteral literal = RDFFactory.eINSTANCE.createTypedLiteral(Integer.toString(bound), XSD_NON_NEGATIVE_INT);
            cr.setOWLonProperty((RDFProperty)property);
            cr.setOWLcardinality(literal);
        }
        catch (Exception e) {
            throw new EODMOWLTransformerException("Something wrong when creating OWL Resource:" + e.getMessage());
        }
        return cr;
    }

    private static void saveOWLGraph(OWLGraph graph, String filePath, String docURI) {
        try {
            Document document = RDFFactory.eINSTANCE.createDocument(docURI);
            document.setComplementalGraph((RDFGraph)graph);
            OWLXMLSaver.saveToFile(document, filePath, "UTF-8");
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        catch (UnsupportedViewTypeException e) {
            e.printStackTrace();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    static List getEclassifier(EPackage ePackage) {
        EList lst = ePackage.getEClassifiers();
        Iterator iter = ePackage.getESubpackages().iterator();
        while (iter.hasNext()) {
            EPackage sube = (EPackage)iter.next();
            lst.addAll(Ecore2OWL.getEclassifier(sube));
        }
        return lst;
    }
}

