/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eodm.rdf.resource.parser.xml;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.eodm.rdf.resource.parser.ErrorHandler;
import org.eclipse.eodm.rdf.resource.parser.NamespaceHandler;
import org.eclipse.eodm.rdf.resource.parser.RDFXMLParser;
import org.eclipse.eodm.rdf.resource.parser.StatementHandler;
import org.eclipse.eodm.rdf.resource.parser.element.RDFBlankNode;
import org.eclipse.eodm.rdf.resource.parser.element.RDFLiteralElement;
import org.eclipse.eodm.rdf.resource.parser.element.RDFResourceElement;
import org.eclipse.eodm.rdf.resource.parser.element.RDFSURIConstant;
import org.eclipse.eodm.rdf.resource.parser.element.RDFTriple;
import org.eclipse.eodm.rdf.resource.parser.element.RDFValue;
import org.eclipse.eodm.rdf.resource.parser.element.URIReference;
import org.eclipse.eodm.rdf.resource.parser.exception.ParserException;
import org.eclipse.eodm.rdf.resource.parser.exception.ParserIOException;
import org.eclipse.eodm.rdf.resource.parser.xml.Element;
import org.eclipse.eodm.rdf.resource.parser.xml.NodeElement;
import org.eclipse.eodm.rdf.resource.parser.xml.PropertyElement;
import org.eclipse.eodm.rdf.resource.parser.xml.RDFXMLContentHandler;
import org.eclipse.eodm.rdf.resource.parser.xml.XMLNCName;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class RDFXMLParserImpl
implements RDFXMLParser {
    private StatementHandler statementHandler;
    private ErrorHandler errorHandler;
    private NamespaceHandler namespaceHandler;
    private Set rdfIDs = new HashSet();
    public Stack xmlBaseURI = new Stack();
    private Stack elementStack = new Stack();
    private Stack langStack = new Stack();
    private HashMap namespaces = new HashMap();
    private RDFXMLContentHandler xmlParser = new RDFXMLContentHandler(this);
    private Locator locator;
    public final String XML = "xml";
    public final String XML_LANG = "xml:lang";
    private static final String[] FORBIDDEN_RDF_TYPE_KEYWORD = new String[]{"RDF", "ID", "about", "parseType", "resource", "nodeID", "li", "aboutEach", "aboutEachPrefix", "bagID"};
    private static final String[] FORBIDDEN_RDF_PROPERTY_KEYWORD = new String[]{"Description", "RDF", "ID", "about", "parseType", "resource", "nodeID", "li", "aboutEach", "aboutEachPrefix", "bagID"};

    public void parse(InputSource inputSource, String baseURI) throws ParserIOException, ParserException {
        if (inputSource == null || baseURI == null) {
            throw new IllegalArgumentException("source or baseURI must NOT be null");
        }
        try {
            SAXParserFactory spf = SAXParserFactory.newInstance();
            XMLReader reader = null;
            try {
                reader = spf.newSAXParser().getXMLReader();
            }
            catch (ParserConfigurationException parserConfigurationException) {
                throw new ParserException("System property javax.xml.parsers.SAXParserFactory is not valid");
            }
            inputSource.setSystemId(baseURI);
            this.pushXmlBase(baseURI);
            reader.setContentHandler(this.xmlParser);
            reader.setFeature("http://xml.org/sax/features/validation", false);
            reader.setFeature("http://xml.org/sax/features/namespaces", true);
            reader.parse(inputSource);
        }
        catch (SAXException e) {
            if (this.locator != null) {
                e.printStackTrace();
                e.getCause();
                e.getLocalizedMessage();
                this.error("meet error on line " + this.locator.getLineNumber() + this.locator.getColumnNumber());
            }
            throw new ParserException(e);
        }
        catch (IOException e) {
            throw new ParserIOException(e);
        }
    }

    public void setStatementHandler(StatementHandler statementHandler) {
        this.statementHandler = statementHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public void setNamespaceHandler(NamespaceHandler namespaceHandler) {
        this.namespaceHandler = namespaceHandler;
    }

    protected void addNamespace(String abb, String uri) {
        this.namespaces.put(abb, uri);
        if (this.namespaceHandler != null) {
            this.namespaceHandler.exportNamespace(abb, uri);
        }
    }

    protected void removeNamespace(String abb) {
        this.namespaces.remove(abb);
    }

    protected void addNodeElement(String namespaceURI, String localName, Attributes attributes) {
        String rdfType;
        RDFResourceElement nodeResource = this.getNodeResource(attributes);
        NodeElement nodeElement = new NodeElement(nodeResource);
        nodeElement.setXmlLang(attributes.getValue("xml:lang"));
        if (!this.elementStack.isEmpty()) {
            NodeElement subject = (NodeElement)this.elementStack.get(this.elementStack.size() - 2);
            PropertyElement predicate = (PropertyElement)this.elementStack.get(this.elementStack.size() - 1);
            if (predicate.isCollectionContext()) {
                RDFResourceElement lastLIResource = predicate.getLastLIResource();
                RDFBlankNode currListResource = new RDFBlankNode();
                if (lastLIResource != null) {
                    this.exportStatement(lastLIResource, RDFSURIConstant.P_REST_URI, (RDFValue)currListResource);
                } else {
                    this.exportStatement(subject.getResource(), predicate, (RDFValue)currListResource);
                }
                this.exportStatement((RDFResourceElement)currListResource, RDFSURIConstant.P_FIRST_URI, (RDFValue)nodeResource);
                predicate.setLastLIResource(currListResource);
            } else {
                this.exportStatement(subject.getResource(), predicate, (RDFValue)nodeResource);
            }
        }
        if (!namespaceURI.equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#") || !localName.equals("Description")) {
            URIReference rdfClassName = new URIReference(namespaceURI, localName);
            this.exportStatement(nodeResource, RDFSURIConstant.P_TYPE_URI, (RDFValue)rdfClassName);
        }
        if ((rdfType = attributes.getValue("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "type")) != null) {
            URIReference reference = new URIReference(rdfType);
            this.exportStatement(nodeResource, RDFSURIConstant.P_TYPE_URI, (RDFValue)reference);
        }
        this.processSubjectsOfNodeAtts(nodeElement, attributes);
        this.pushElement(nodeElement);
    }

    protected void addPropertyElement(String namespaceURI, String localName, Attributes attributes) {
        String dataType;
        RDFResourceElement propertyResource;
        URIReference referenceURI;
        boolean propertyAndNodeElement = false;
        if (localName.equals("li") && namespaceURI.equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#")) {
            NodeElement subject = (NodeElement)this.elementStack.get(this.elementStack.size() - 1);
            referenceURI = new URIReference("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "_" + subject.nextLI());
        } else {
            referenceURI = new URIReference(namespaceURI, localName);
        }
        PropertyElement predicate = new PropertyElement(referenceURI);
        predicate.setXmlLang(attributes.getValue("xml:lang"));
        this.pushElement(predicate);
        String rdfID = attributes.getValue("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "ID");
        if (rdfID != null) {
            URIReference reificationURI = this.createResourceFromID(rdfID);
            predicate.setReificationURI(reificationURI);
        }
        String rdfParseType = null;
        rdfParseType = attributes.getValue("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "parseType");
        if (rdfParseType != null) {
            predicate.setParseType(rdfParseType);
            if (rdfParseType.equals("Literal")) {
                if (attributes.getValue("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "resource") != null) {
                    this.error("rdf:resource is forbidden since there is an rdf:parseType of \"Literal\"");
                }
                this.pushElement(null);
            } else if (rdfParseType.equals("Resource")) {
                propertyAndNodeElement = true;
                RDFBlankNode blankNode = new RDFBlankNode();
                NodeElement subject = (NodeElement)this.elementStack.get(this.elementStack.size() - 2);
                this.exportStatement(subject.getResource(), predicate, (RDFValue)blankNode);
                NodeElement nodeElement = new NodeElement(blankNode);
                nodeElement.setExplicit(false);
                this.pushElement(nodeElement);
            } else if (rdfParseType.equals("Collection")) {
                predicate.setCollectionContext(true);
            } else if (rdfParseType.equals("daml:collection")) {
                predicate.setCollectionContext(true);
            } else {
                this.error("Unknown parseType: '" + rdfParseType + "'");
            }
        }
        if (!propertyAndNodeElement && (propertyResource = this.getPropertyResource(attributes)) != null) {
            NodeElement propertyResourceNodeElement = new NodeElement(propertyResource);
            NodeElement subject = (NodeElement)this.elementStack.get(this.elementStack.size() - 2);
            this.exportStatement(subject.getResource(), predicate, (RDFValue)propertyResource);
            String rdfType = null;
            rdfType = attributes.getValue("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "type");
            if (rdfType != null) {
                URIReference className = new URIReference(rdfType);
                this.exportStatement(propertyResource, RDFSURIConstant.P_TYPE_URI, (RDFValue)className);
            }
            this.processSubjectsOfPropertyAtts(propertyResourceNodeElement, attributes);
        }
        if ((dataType = attributes.getValue("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "datatype")) != null) {
            predicate.setDataType(dataType);
        }
    }

    public void removeElement() {
        Object topElement = this.elementStack.peek();
        if (!(topElement instanceof NodeElement) && topElement instanceof PropertyElement) {
            PropertyElement propertyElement = (PropertyElement)topElement;
            if (propertyElement.isCollectionContext()) {
                RDFResourceElement resource = propertyElement.getLastLIResource();
                this.exportStatement(resource, RDFSURIConstant.P_REST_URI, (RDFValue)RDFSURIConstant.NIL_URI);
            } else if (propertyElement.isEmpty()) {
                NodeElement subject = (NodeElement)this.elementStack.get(this.elementStack.size() - 2);
                if (propertyElement.getParseType() != null && propertyElement.getParseType().equals("Literal")) {
                    this.exportStatement(subject.getResource(), propertyElement, (RDFValue)new RDFLiteralElement("", null, RDFSURIConstant.C_XMLLITERAL_URI));
                } else {
                    this.exportStatement(subject.getResource(), propertyElement, (RDFValue)new RDFLiteralElement(""));
                }
            }
        }
        this.popElement();
    }

    public void addText(String text) {
        Object topElement = this.elementStack.peek();
        int offset = 0;
        if (topElement == null) {
            do {
                topElement = this.elementStack.get(this.elementStack.size() - ++offset - 1);
            } while (offset < this.elementStack.size() && topElement == null);
        }
        if (topElement instanceof PropertyElement) {
            PropertyElement propertyElement = (PropertyElement)topElement;
            String type = propertyElement.getDataType();
            URIReference dataType = type != null ? new URIReference(type) : null;
            RDFLiteralElement literal = "Literal".equals(propertyElement.getParseType()) ? new RDFLiteralElement(text, null, RDFSURIConstant.C_XMLLITERAL_URI) : new RDFLiteralElement(text, this.peekXmlLang(), dataType);
            NodeElement nodeElement = (NodeElement)this.elementStack.get(this.elementStack.size() - 2 - offset);
            this.exportStatement(nodeElement.getResource(), propertyElement, (RDFValue)literal);
        } else {
            this.error("Unexpected element type while adding text");
        }
    }

    private void processSubjectsOfNodeAtts(NodeElement nodeElement, Attributes attributes) {
        int i = 0;
        while (i < attributes.getLength()) {
            if (!attributes.getQName(i).startsWith("xmlns")) {
                String namespace = attributes.getURI(i);
                String localName = attributes.getLocalName(i);
                String uri = String.valueOf(namespace) + localName;
                if (!("http://www.w3.org/1999/02/22-rdf-syntax-ns#about".equals(uri) || "http://www.w3.org/1999/02/22-rdf-syntax-ns#ID".equals(uri) || "http://www.w3.org/1999/02/22-rdf-syntax-ns#nodeID".equals(uri) || "http://www.w3.org/1999/02/22-rdf-syntax-ns#type".equals(uri) || "http://www.w3.org/XML/1998/namespace".equals(namespace) || "http://www.w3.org/XML/1998/namespacelang".equals(uri) || "http://www.w3.org/XML/1998/namespacebase".equals(uri))) {
                    String value = attributes.getValue(i);
                    RDFLiteralElement literal = new RDFLiteralElement(value, nodeElement.getXmlLang());
                    this.exportStatement(nodeElement.getResource(), new URIReference(uri), (RDFValue)literal);
                }
            }
            ++i;
        }
    }

    private void processSubjectsOfPropertyAtts(NodeElement nodeElement, Attributes attributes) {
        int i = 0;
        while (i < attributes.getLength()) {
            if (!attributes.getQName(i).startsWith("xmlns")) {
                String namespace = attributes.getURI(i);
                String localName = attributes.getLocalName(i);
                String uri = String.valueOf(namespace) + localName;
                if (!("http://www.w3.org/1999/02/22-rdf-syntax-ns#ID".equals(uri) || "http://www.w3.org/1999/02/22-rdf-syntax-ns#parseType".equals(uri) || "http://www.w3.org/1999/02/22-rdf-syntax-ns#resource".equals(uri) || "http://www.w3.org/1999/02/22-rdf-syntax-ns#nodeID".equals(uri) || "http://www.w3.org/1999/02/22-rdf-syntax-ns#type".equals(uri) || "http://www.w3.org/XML/1998/namespace".equals(namespace) || "http://www.w3.org/XML/1998/namespacelang".equals(uri) || "http://www.w3.org/XML/1998/namespacebase".equals(uri))) {
                    String value = attributes.getValue(i);
                    if (!uri.startsWith("xml")) {
                        this.exportStatement(nodeElement.getResource(), new URIReference(uri), (RDFValue)new RDFLiteralElement(value));
                    }
                }
            }
            ++i;
        }
    }

    private RDFResourceElement getNodeResource(Attributes attributes) {
        String rdfAbout = null;
        String rdfID = null;
        String rdfNodeID = null;
        rdfAbout = attributes.getValue("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "about");
        rdfID = attributes.getValue("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "ID");
        rdfNodeID = attributes.getValue("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "nodeID");
        int resourceCount = 0;
        if (rdfAbout != null) {
            ++resourceCount;
        }
        if (rdfID != null) {
            ++resourceCount;
        }
        if (rdfNodeID != null) {
            ++resourceCount;
        }
        if (resourceCount > 1) {
            this.error("only ONE resource declaration is allowed here");
        }
        if (rdfAbout != null) {
            if (rdfAbout.length() == 0) {
                return (RDFResourceElement)this.xmlBaseURI.peek();
            }
            return ((URIReference)this.xmlBaseURI.peek()).relative(rdfAbout);
        }
        if (rdfID != null) {
            return this.createResourceFromID(rdfID);
        }
        if (rdfNodeID != null) {
            this.checkIDValid(rdfNodeID);
            return new RDFBlankNode(rdfNodeID);
        }
        return new RDFBlankNode();
    }

    private RDFResourceElement getPropertyResource(Attributes attributes) {
        String parseType;
        String rdfResource = null;
        rdfResource = attributes.getValue("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "resource");
        String rdfNodeID = null;
        rdfNodeID = attributes.getValue("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "nodeID");
        if (rdfResource != null && rdfNodeID != null) {
            this.error("only ONE resource declaration is allowed here");
        }
        if (rdfResource != null) {
            return this.createResource(rdfResource);
        }
        if (rdfNodeID != null) {
            this.checkIDValid(rdfNodeID);
            return new RDFBlankNode(rdfNodeID);
        }
        int count = attributes.getLength();
        if (attributes.getValue("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "datatype") != null) {
            --count;
        }
        if (attributes.getValue("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "ID") != null) {
            --count;
        }
        if (attributes.getValue("xml:lang") != null) {
            --count;
        }
        if ((parseType = attributes.getValue("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "parseType")) != null) {
            --count;
        }
        int i = 0;
        while (i < attributes.getLength()) {
            if (attributes.getQName(i).startsWith("xmlns")) {
                --count;
            } else {
                String namespace = attributes.getURI(i);
                String localName = attributes.getLocalName(i);
                if ("http://www.w3.org/XML/1998/namespace".equals(namespace) || localName.startsWith("xml")) {
                    --count;
                }
            }
            ++i;
        }
        if (count > 0) {
            if (parseType != null && parseType.equals("Literal")) {
                this.error("rdf:parseType=\"Literal\" is forbidden since an additional resource node will be created.");
            }
            return new RDFBlankNode();
        }
        return null;
    }

    private URIReference createResourceFromID(String rdfID) {
        this.checkIDValid(rdfID);
        URIReference id = ((URIReference)this.xmlBaseURI.peek()).relative("#" + rdfID);
        boolean noConflict = this.rdfIDs.add(id);
        if (!noConflict) {
            this.error("'" + rdfID + "' is already used.");
        }
        return id;
    }

    private void checkIDValid(String id) {
        boolean valid = XMLNCName.validateNCName(id);
        if (!valid) {
            this.error("ID " + id + " is not valid.");
        }
    }

    private URIReference createResource(String resource) {
        try {
            return ((URIReference)this.xmlBaseURI.peek()).relative(resource);
        }
        catch (IllegalArgumentException ie) {
            try {
                int anchor = resource.indexOf(35);
                if (anchor > 0) {
                    return ((URIReference)this.xmlBaseURI.peek()).relative(String.valueOf(resource.substring(0, anchor)) + URLEncoder.encode(resource.substring(anchor, resource.length()), "UTF8"));
                }
                if (anchor == 0) {
                    return ((URIReference)this.xmlBaseURI.peek()).relative(URLEncoder.encode(resource, "UTF8"));
                }
                throw ie;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw ie;
            }
        }
    }

    public void pushElement(Element element) {
        this.elementStack.push(element);
        if (element != null && element.getXmlLang() != null) {
            this.langStack.push(element.getXmlLang());
        }
    }

    protected Element popElement() {
        if (this.elementStack.isEmpty()) {
            return null;
        }
        Element element = (Element)this.elementStack.pop();
        if (element != null && element.getXmlLang() != null) {
            this.langStack.pop();
        }
        return element;
    }

    protected Element peekElement() {
        if (this.elementStack.isEmpty()) {
            return null;
        }
        return (Element)this.elementStack.peek();
    }

    private String peekXmlLang() {
        if (!this.langStack.isEmpty()) {
            return (String)this.langStack.peek();
        }
        return null;
    }

    private void exportStatement(RDFResourceElement subject, PropertyElement predicate, RDFValue object) {
        predicate.setEmpty(false);
        this.exportStatement(subject, predicate.getUriReference(), object);
        if (predicate.getReificationURI() != null) {
            this.exportReificationStatement(predicate.getReificationURI(), subject, predicate.getUriReference(), object);
        }
    }

    private void exportStatement(RDFResourceElement subject, URIReference predicate, RDFValue object) {
        if (!this.checkStatementValid(subject, predicate, object)) {
            throw new ParserException("The statement " + new RDFTriple(subject, predicate, object) + " is not valid.");
        }
        this.statementHandler.exportStatement(subject, predicate, object);
    }

    private void exportReificationStatement(RDFResourceElement reifyNode, RDFResourceElement subject, URIReference predicate, RDFValue object) {
        this.statementHandler.exportReification(reifyNode, subject, predicate, object);
        if (!this.statementHandler.isSeparateExport()) {
            this.exportStatement(reifyNode, RDFSURIConstant.P_TYPE_URI, (RDFValue)RDFSURIConstant.C_STATEMENT_URI);
            this.exportStatement(reifyNode, RDFSURIConstant.P_SUBJECT_URI, (RDFValue)subject);
            this.exportStatement(reifyNode, RDFSURIConstant.P_PREDICATE_URI, (RDFValue)predicate);
            this.exportStatement(reifyNode, RDFSURIConstant.P_OBJECT_URI, object);
        }
    }

    public void pushXmlBase(String xmlBase) {
        try {
            URI baseURL = new URI(xmlBase);
            String fragment = baseURL.getFragment();
            if (fragment == null) {
                this.xmlBaseURI.push(new URIReference(baseURL));
            } else {
                this.xmlBaseURI.push(new URIReference(xmlBase.substring(0, xmlBase.length() - (fragment.length() + 1))));
            }
        }
        catch (URISyntaxException murle) {
            throw new ParserException(murle);
        }
    }

    public void popXmlBase() {
        this.xmlBaseURI.pop();
    }

    protected void error(String msg) {
        if (this.errorHandler == null) {
            System.err.println(msg);
            throw new ParserException(msg);
        }
        this.errorHandler.error(msg);
    }

    public void setLocator(Locator locator) {
        this.locator = locator;
    }

    private boolean checkStatementValid(RDFResourceElement subject, URIReference predicate, RDFValue object) {
        if (predicate.getFullURI().equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#type") && object instanceof URIReference) {
            URIReference refObject = (URIReference)object;
            int i = 0;
            while (i < FORBIDDEN_RDF_TYPE_KEYWORD.length) {
                if (refObject.getFullURI().equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#" + FORBIDDEN_RDF_TYPE_KEYWORD[i])) {
                    return false;
                }
                ++i;
            }
        }
        int i = 0;
        while (i < FORBIDDEN_RDF_PROPERTY_KEYWORD.length) {
            if (predicate.getFullURI().equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#" + FORBIDDEN_RDF_PROPERTY_KEYWORD[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

