/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eodm.rdf.transformer;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;
import org.eclipse.eodm.rdf.rdfbase.PlainLiteral;
import org.eclipse.eodm.rdf.rdfbase.RDFGraph;
import org.eclipse.eodm.rdf.rdfbase.RDFProperty;
import org.eclipse.eodm.rdf.rdfbase.RDFSLiteral;
import org.eclipse.eodm.rdf.rdfbase.RDFSResource;
import org.eclipse.eodm.rdf.rdfbase.URIReference;
import org.eclipse.eodm.rdf.rdfs.RDFBag;
import org.eclipse.eodm.rdf.rdfs.RDFSClass;
import org.eclipse.eodm.rdf.rdfs.RDFSDatatype;
import org.eclipse.eodm.rdf.rdfweb.Document;
import org.eclipse.eodm.rdf.resource.RDFXMLResourceFactoryImpl;
import org.eclipse.eodm.rdf.transformer.EODMRDFSTransformerException;

public class RDFS2Ecore {
    private static String XSD_BOOLEAN = "http://www.w3.org/2001/XMLSchema#boolean";
    private static String XSD_FLOAT = "http://www.w3.org/2001/XMLSchema#float";
    private static String XSD_BYTE = "http://www.w3.org/2001/XMLSchema#byte";
    private static String XSD_INT = "http://www.w3.org/2001/XMLSchema#int";
    private static String XSD_LONG = "http://www.w3.org/2001/XMLSchema#long";
    private static String XSD_DOUBLE = "http://www.w3.org/2001/XMLSchema#double";
    private static String XSD_SHORT = "http://www.w3.org/2001/XMLSchema#short";
    private static String XSD_STRING = "http://www.w3.org/2001/XMLSchema#string";
    static /* synthetic */ Class class$0;

    public static void rdf2ecore(String rdfFile, String ecoreFile, Map options) throws EODMRDFSTransformerException {
        EPackage epackage = RDFS2Ecore.rdf2ecore(rdfFile, options);
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new EcoreResourceFactoryImpl());
        Resource resource = resourceSet.createResource(URI.createFileURI((String)new File(ecoreFile).getAbsolutePath()));
        resource.getContents().add((Object)epackage);
        try {
            resource.save(Collections.EMPTY_MAP);
        }
        catch (Exception e) {
            throw new EODMRDFSTransformerException("Error during serialize into XMI file: " + e.toString());
        }
    }

    public static EPackage rdf2ecore(String rdfFile, Map options) throws EODMRDFSTransformerException {
        RDFGraph graph = null;
        try {
            graph = RDFS2Ecore.loadRDF(rdfFile);
        }
        catch (Exception e) {
            throw new EODMRDFSTransformerException("Can not load rdf files: " + e.getMessage());
        }
        return RDFS2Ecore.rdf2ecore(graph, options);
    }

    public static EPackage rdf2ecore(RDFGraph graph, Map options) throws EODMRDFSTransformerException {
        EcoreFactory efactory = EcoreFactory.eINSTANCE;
        EPackage ePackage = efactory.createEPackage();
        URIReference graphUri = graph.getGraphName();
        if (graphUri != null) {
            graphUri.getNamespace();
            ePackage.setName(graphUri.getUri().getName());
        }
        try {
            Iterator it;
            ArrayList clist = graph.getTypeResources("http://www.w3.org/2000/01/rdf-schema#Class");
            HashMap rdf2eclassifierMap = new HashMap();
            ArrayList baglist = graph.getTypeResources("http://www.w3.org/1999/02/22-rdf-syntax-ns#Bag");
            if (baglist != null) {
                it = baglist.iterator();
                while (it.hasNext()) {
                    EEnum eenum = RDFS2Ecore.rdfBag2EEnum((RDFBag)it.next(), rdf2eclassifierMap);
                    ePackage.getEClassifiers().add((Object)eenum);
                }
            }
            it = clist.iterator();
            while (it.hasNext()) {
                RDFSClass rclass = (RDFSClass)it.next();
                EClassifier eclass = RDFS2Ecore.rdfs2eclassifier(rclass, rdf2eclassifierMap);
                if (eclass == null) continue;
                Iterator itSuper = rclass.getRDFSsubClassOf().iterator();
                while (itSuper.hasNext()) {
                    RDFSClass superClass = (RDFSClass)itSuper.next();
                    EClass efather = (EClass)RDFS2Ecore.rdfs2eclassifier(superClass, rdf2eclassifierMap);
                    if (efather == null) continue;
                    ((EClass)eclass).getESuperTypes().add((Object)efather);
                }
                Iterator itP = rclass.getPropertyForDomain().iterator();
                while (itP.hasNext()) {
                    RDFProperty p = (RDFProperty)itP.next();
                    EList rangeList = p.getRDFSrange();
                    if (rangeList.isEmpty()) continue;
                    RDFSClass range = (RDFSClass)rangeList.get(0);
                    EClassifier erange = RDFS2Ecore.rdfs2eclassifier(range, rdf2eclassifierMap);
                    if (erange instanceof EDataType) {
                        EAttribute attribute = EcoreFactory.eINSTANCE.createEAttribute();
                        attribute.setName(RDFS2Ecore.getName((RDFSResource)p));
                        attribute.getEAnnotations().addAll((Collection)RDFS2Ecore.comments2EAnnotation((RDFSResource)p));
                        attribute.setEType(erange);
                        ((EClass)eclass).getEStructuralFeatures().add((Object)attribute);
                        continue;
                    }
                    EReference eref = EcoreFactory.eINSTANCE.createEReference();
                    eref.setName(RDFS2Ecore.getName((RDFSResource)p));
                    eref.getEAnnotations().addAll((Collection)RDFS2Ecore.comments2EAnnotation((RDFSResource)p));
                    eref.setEType(erange);
                    ((EClass)eclass).getEStructuralFeatures().add((Object)eref);
                }
                ePackage.getEClassifiers().add((Object)eclass);
            }
        }
        catch (Exception e) {
            throw new EODMRDFSTransformerException("There are something wrong during transformation" + e.getMessage());
        }
        return ePackage;
    }

    private static List comments2EAnnotation(RDFSResource rsource) {
        EAnnotation an;
        ArrayList<EAnnotation> lst = new ArrayList<EAnnotation>();
        Iterator it = rsource.getRDFScomment().iterator();
        while (it.hasNext()) {
            an = EcoreFactory.eINSTANCE.createEAnnotation();
            an.setSource(((RDFSLiteral)it.next()).getLexicalForm());
            lst.add(an);
        }
        it = rsource.getRDFSisDefinedBy().iterator();
        while (it.hasNext()) {
            an = EcoreFactory.eINSTANCE.createEAnnotation();
            an.setSource(RDFS2Ecore.getName((RDFSResource)it.next()));
        }
        it = rsource.getRDFSlabel().iterator();
        while (it.hasNext()) {
            an = EcoreFactory.eINSTANCE.createEAnnotation();
            an.setSource(((PlainLiteral)it.next()).getLexicalForm());
        }
        return lst;
    }

    private static EClassifier rdfs2eclassifier(RDFSClass rclass, Map rdfs2ecoreMap) {
        EClassifier eclass = (EClassifier)rdfs2ecoreMap.get(rclass);
        if (eclass == null) {
            if (rclass instanceof RDFSDatatype) {
                RDFSDatatype dt = (RDFSDatatype)rclass;
                String dtURI = dt.getURI();
                if (dtURI != null) {
                    if (dtURI.equals(XSD_BOOLEAN)) {
                        eclass = EcorePackage.eINSTANCE.getEBoolean();
                    } else if (dtURI.equals(XSD_FLOAT)) {
                        eclass = EcorePackage.eINSTANCE.getEFloat();
                    } else if (dtURI.equals(XSD_INT)) {
                        eclass = EcorePackage.eINSTANCE.getEInt();
                    } else if (dtURI.equals(XSD_BYTE)) {
                        eclass = EcorePackage.eINSTANCE.getEByte();
                    } else if (dtURI.equals(XSD_LONG)) {
                        eclass = EcorePackage.eINSTANCE.getELong();
                    } else if (dtURI.equals(XSD_DOUBLE)) {
                        eclass = EcorePackage.eINSTANCE.getEDouble();
                    } else if (dtURI.equals(XSD_SHORT)) {
                        eclass = EcorePackage.eINSTANCE.getEShort();
                    } else if (dtURI.equals(XSD_STRING) || dtURI.equals("http://www.w3.org/2000/01/rdf-schema#Literal") || dtURI.equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral")) {
                        eclass = EcorePackage.eINSTANCE.getEString();
                    } else {
                        Class<?> clazz = class$0;
                        if (clazz == null) {
                            try {
                                clazz = class$0 = Class.forName("org.eclipse.eodm.rdf.rdfs.RDFBag");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if (clazz.isInstance(dt.getRDFSisDefinedBy().size() > 0 ? dt.getRDFSisDefinedBy().get(0) : null)) {
                            eclass = RDFS2Ecore.rdfBag2EEnum((RDFBag)dt.getRDFSisDefinedBy().get(0), rdfs2ecoreMap);
                        } else {
                            eclass = EcoreFactory.eINSTANCE.createEDataType();
                            eclass.setName(RDFS2Ecore.getName((RDFSResource)dt));
                            eclass.getEAnnotations().addAll((Collection)RDFS2Ecore.comments2EAnnotation((RDFSResource)dt));
                        }
                    }
                }
            } else {
                eclass = EcoreFactory.eINSTANCE.createEClass();
                eclass.setName(RDFS2Ecore.getName((RDFSResource)rclass));
                eclass.getEAnnotations().addAll((Collection)RDFS2Ecore.comments2EAnnotation((RDFSResource)rclass));
            }
            if (eclass != null) {
                rdfs2ecoreMap.put(rclass, eclass);
            }
        }
        return eclass;
    }

    private static EEnum rdfBag2EEnum(RDFBag bag, Map rdfs2ecoreMap) {
        EList memberList;
        EEnum eenum = (EEnum)rdfs2ecoreMap.get(bag);
        if (eenum == null && (memberList = bag.getRDFSmember()).size() > 0) {
            eenum = EcoreFactory.eINSTANCE.createEEnum();
            eenum.setName(RDFS2Ecore.getName((RDFSResource)bag));
            eenum.getEAnnotations().addAll((Collection)RDFS2Ecore.comments2EAnnotation((RDFSResource)bag));
            int i = 0;
            while (i < memberList.size()) {
                RDFSResource r = (RDFSResource)memberList.get(i);
                EEnumLiteral eliteral = EcoreFactory.eINSTANCE.createEEnumLiteral();
                String name = r instanceof RDFSLiteral ? ((RDFSLiteral)r).getLexicalForm() : RDFS2Ecore.getName(r);
                eliteral.setName(name);
                eliteral.setValue(i);
                eliteral.getEAnnotations().addAll((Collection)RDFS2Ecore.comments2EAnnotation(r));
                eenum.getELiterals().add((Object)eliteral);
                ++i;
            }
            rdfs2ecoreMap.put(bag, eenum);
        }
        return eenum;
    }

    private static RDFGraph loadRDF(String rdfFile) throws IOException {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("rdf", new RDFXMLResourceFactoryImpl());
        URI fileURI = URI.createFileURI((String)new File(rdfFile).getAbsolutePath());
        Resource resource = resourceSet.createResource(fileURI);
        resource.load(Collections.EMPTY_MAP);
        return ((Document)resource.getContents().get(0)).getComplementalGraph();
    }

    private static String getName(RDFSResource r) {
        URIReference uriRef;
        String name = null;
        name = !r.getUriRef().isEmpty() ? ((uriRef = (URIReference)r.getUriRef().get(0)).getFragmentIdentifier() == null ? uriRef.getUri().getName() : uriRef.getFragmentIdentifier().getName()) : r.getURI();
        return name;
    }
}

