/**
 * <copyright> 
 * 
 * Copyright (c) 2004-2005 IBM Corporation and others. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License - v 1.0 
 * which accompanies this distribution, and is available at 
 * http://opensource.org/licenses/eclipse-1.0.txt 
 * 
 * Contributors: 
 *   IBM - Initial API and implementation 
 * 
 * </copyright> 
 * 
 * $Id: OWLXMLResourceFactoryImpl.java,v 1.2 2007/03/18 09:07:04 lzhang Exp $
 */

package org.eclipse.eodm.owl.resource;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceFactoryImpl;

/**
 * OWLXMLResourceFactoryImpl
 */
public class OWLXMLResourceFactoryImpl extends ResourceFactoryImpl {
    /**
     * Constructs an OWLXMLResourceFactoryImpl instance
     * 
     */
    public OWLXMLResourceFactoryImpl() {
        super();
    }

    /**
     * Create a
     * {@link org.eclipse.eodm.owl.resource.OWLXMLResource OWLXMLResource}
     * instance based on uri.
     * 
     * @param uri
     *            the URI of the resource
     * @return {@link org.eclipse.eodm.owl.resource.OWLXMLResource OWLXMLResource}
     *         object
     */
    public Resource createResource(URI uri) {
        return new OWLXMLResourceImpl(uri);
    }
}