/**
 * Copyright (c) 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   IBM - Initial API and implementation
 *
 * $Id: EODMImplAdapterFactory.java,v 1.2 2007/03/18 10:23:39 lzhang Exp $
 */
package org.eclipse.eodm.impl;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterFactoryImpl;
import org.eclipse.emf.ecore.EObject;

import org.eclipse.eodm.owl.owlbase.AllValuesFromRestriction;
import org.eclipse.eodm.owl.owlbase.CardinalityRestriction;
import org.eclipse.eodm.owl.owlbase.ComplementClass;
import org.eclipse.eodm.owl.owlbase.EnumeratedClass;
import org.eclipse.eodm.owl.owlbase.HasValueRestriction;
import org.eclipse.eodm.owl.owlbase.Individual;
import org.eclipse.eodm.owl.owlbase.IntersectionClass;
import org.eclipse.eodm.owl.owlbase.MaxCardinalityRestriction;
import org.eclipse.eodm.owl.owlbase.MinCardinalityRestriction;
import org.eclipse.eodm.owl.owlbase.OWLAllDifferent;
import org.eclipse.eodm.owl.owlbase.OWLAnnotationProperty;
import org.eclipse.eodm.owl.owlbase.OWLClass;
import org.eclipse.eodm.owl.owlbase.OWLDataRange;
import org.eclipse.eodm.owl.owlbase.OWLDatatypeProperty;
import org.eclipse.eodm.owl.owlbase.OWLGraph;
import org.eclipse.eodm.owl.owlbase.OWLObjectProperty;
import org.eclipse.eodm.owl.owlbase.OWLOntology;
import org.eclipse.eodm.owl.owlbase.OWLOntologyProperty;
import org.eclipse.eodm.owl.owlbase.OWLRestriction;
import org.eclipse.eodm.owl.owlbase.Property;
import org.eclipse.eodm.owl.owlbase.SomeValuesFromRestriction;
import org.eclipse.eodm.owl.owlbase.Statement;
import org.eclipse.eodm.owl.owlbase.UnionClass;
import org.eclipse.eodm.owl.owlbase.Universe;
import org.eclipse.eodm.rdf.rdfbase.BlankNode;
import org.eclipse.eodm.rdf.rdfbase.PlainLiteral;
import org.eclipse.eodm.rdf.rdfbase.RDFGraph;
import org.eclipse.eodm.rdf.rdfbase.RDFProperty;
import org.eclipse.eodm.rdf.rdfbase.RDFSLiteral;
import org.eclipse.eodm.rdf.rdfbase.RDFSResource;
import org.eclipse.eodm.rdf.rdfbase.RDFStatement;
import org.eclipse.eodm.rdf.rdfbase.RDFXMLLiteral;
import org.eclipse.eodm.rdf.rdfbase.TypedLiteral;
import org.eclipse.eodm.rdf.rdfbase.URIReferenceNode;
import org.eclipse.eodm.rdf.rdfs.RDFAlt;
import org.eclipse.eodm.rdf.rdfs.RDFBag;
import org.eclipse.eodm.rdf.rdfs.RDFList;
import org.eclipse.eodm.rdf.rdfs.RDFSClass;
import org.eclipse.eodm.rdf.rdfs.RDFSContainer;
import org.eclipse.eodm.rdf.rdfs.RDFSContainerMembershipProperty;
import org.eclipse.eodm.rdf.rdfs.RDFSDatatype;
import org.eclipse.eodm.rdf.rdfs.RDFSeq;
import org.eclipse.eodm.rdf.rdfweb.Document;




/**
 * <!-- begin-user-doc -->
 * The <b>Adapter Factory</b> for the model.
 * It provides an adapter <code>createXXX</code> method for each class of the model.
 * <!-- end-user-doc -->
 * @see org.eclipse.eodm.impl.EODMImplPackage
 * @generated
 */
public class EODMImplAdapterFactory extends AdapterFactoryImpl {
	/**
	 * The cached model package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static EODMImplPackage modelPackage;

	/**
	 * Creates an instance of the adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EODMImplAdapterFactory() {
		if (modelPackage == null) {
			modelPackage = EODMImplPackage.eINSTANCE;
		}
	}

	/**
	 * Returns whether this factory is applicable for the type of the object.
	 * <!-- begin-user-doc -->
	 * This implementation returns <code>true</code> if the object is either the model's package or is an instance object of the model.
	 * <!-- end-user-doc -->
	 * @return whether this factory is applicable for the type of the object.
	 * @generated
	 */
	public boolean isFactoryForType(Object object) {
		if (object == modelPackage) {
			return true;
		}
		if (object instanceof EObject) {
			return ((EObject)object).eClass().getEPackage() == modelPackage;
		}
		return false;
	}

	/**
	 * The switch the delegates to the <code>createXXX</code> methods.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EODMImplSwitch modelSwitch =
		new EODMImplSwitch() {
			public Object caseInternalCore(InternalCore object) {
				return createInternalCoreAdapter();
			}
			public Object caseRDFSResource(RDFSResource object) {
				return createRDFSResourceAdapter();
			}
			public Object caseBlankNode(BlankNode object) {
				return createBlankNodeAdapter();
			}
			public Object caseRDFSLiteral(RDFSLiteral object) {
				return createRDFSLiteralAdapter();
			}
			public Object casePlainLiteral(PlainLiteral object) {
				return createPlainLiteralAdapter();
			}
			public Object caseRDFSClass(RDFSClass object) {
				return createRDFSClassAdapter();
			}
			public Object caseUniverse(Universe object) {
				return createUniverseAdapter();
			}
			public Object caseOWLClass(OWLClass object) {
				return createOWLClassAdapter();
			}
			public Object caseComplementClass(ComplementClass object) {
				return createComplementClassAdapter();
			}
			public Object caseTypedLiteral(TypedLiteral object) {
				return createTypedLiteralAdapter();
			}
			public Object caseRDFXMLLiteral(RDFXMLLiteral object) {
				return createRDFXMLLiteralAdapter();
			}
			public Object caseOWLAllDifferent(OWLAllDifferent object) {
				return createOWLAllDifferentAdapter();
			}
			public Object caseOWLRestriction(OWLRestriction object) {
				return createOWLRestrictionAdapter();
			}
			public Object caseCardinalityRestriction(CardinalityRestriction object) {
				return createCardinalityRestrictionAdapter();
			}
			public Object caseMinCardinalityRestriction(MinCardinalityRestriction object) {
				return createMinCardinalityRestrictionAdapter();
			}
			public Object caseSomeValuesFromRestriction(SomeValuesFromRestriction object) {
				return createSomeValuesFromRestrictionAdapter();
			}
			public Object caseIndividual(Individual object) {
				return createIndividualAdapter();
			}
			public Object caseRDFSContainer(RDFSContainer object) {
				return createRDFSContainerAdapter();
			}
			public Object caseRDFAlt(RDFAlt object) {
				return createRDFAltAdapter();
			}
			public Object caseRDFSeq(RDFSeq object) {
				return createRDFSeqAdapter();
			}
			public Object caseRDFList(RDFList object) {
				return createRDFListAdapter();
			}
			public Object caseRDFProperty(RDFProperty object) {
				return createRDFPropertyAdapter();
			}
			public Object caseOWLAnnotationProperty(OWLAnnotationProperty object) {
				return createOWLAnnotationPropertyAdapter();
			}
			public Object caseProperty(Property object) {
				return createPropertyAdapter();
			}
			public Object caseOWLDatatypeProperty(OWLDatatypeProperty object) {
				return createOWLDatatypePropertyAdapter();
			}
			public Object caseOWLOntology(OWLOntology object) {
				return createOWLOntologyAdapter();
			}
			public Object caseGraph(RDFGraph object) {
				return createGraphAdapter();
			}
			public Object caseOWLGraph(OWLGraph object) {
				return createOWLGraphAdapter();
			}
			public Object caseHasValueRestriction(HasValueRestriction object) {
				return createHasValueRestrictionAdapter();
			}
			public Object caseAllValuesFromRestriction(AllValuesFromRestriction object) {
				return createAllValuesFromRestrictionAdapter();
			}
			public Object caseMaxCardinalityRestriction(MaxCardinalityRestriction object) {
				return createMaxCardinalityRestrictionAdapter();
			}
			public Object caseIntersectionClass(IntersectionClass object) {
				return createIntersectionClassAdapter();
			}
			public Object caseEnumeratedClass(EnumeratedClass object) {
				return createEnumeratedClassAdapter();
			}
			public Object caseUnionClass(UnionClass object) {
				return createUnionClassAdapter();
			}
			public Object caseRDFSDatatype(RDFSDatatype object) {
				return createRDFSDatatypeAdapter();
			}
			public Object caseOWLDataRange(OWLDataRange object) {
				return createOWLDataRangeAdapter();
			}
			public Object caseRDFStatement(RDFStatement object) {
				return createRDFStatementAdapter();
			}
			public Object caseStatement(Statement object) {
				return createStatementAdapter();
			}
			public Object caseRDFBag(RDFBag object) {
				return createRDFBagAdapter();
			}
			public Object caseURIReferenceNode(URIReferenceNode object) {
				return createURIReferenceNodeAdapter();
			}
			public Object caseOWLOntologyProperty(OWLOntologyProperty object) {
				return createOWLOntologyPropertyAdapter();
			}
			public Object caseRDFSContainerMembershipProperty(RDFSContainerMembershipProperty object) {
				return createRDFSContainerMembershipPropertyAdapter();
			}
			public Object caseOWLObjectProperty(OWLObjectProperty object) {
				return createOWLObjectPropertyAdapter();
			}
			public Object caseDocument(Document object) {
				return createDocumentAdapter();
			}
			public Object defaultCase(EObject object) {
				return createEObjectAdapter();
			}
		};

	/**
	 * Creates an adapter for the <code>target</code>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param target the object to adapt.
	 * @return the adapter for the <code>target</code>.
	 * @generated
	 */
	public Adapter createAdapter(Notifier target) {
		return (Adapter)modelSwitch.doSwitch((EObject)target);
	}


	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.eodm.impl.InternalCore <em>Internal Core</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.eodm.impl.InternalCore
	 * @generated
	 */
	public Adapter createInternalCoreAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.eodm.rdf.rdfbase.RDFSResource <em>RDFS Resource</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.eodm.rdf.rdfbase.RDFSResource
	 * @generated
	 */
	public Adapter createRDFSResourceAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.eodm.rdf.rdfbase.BlankNode <em>Blank Node</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.eodm.rdf.rdfbase.BlankNode
	 * @generated
	 */
	public Adapter createBlankNodeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.eodm.rdf.rdfbase.RDFSLiteral <em>RDFS Literal</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.eodm.rdf.rdfbase.RDFSLiteral
	 * @generated
	 */
	public Adapter createRDFSLiteralAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.eodm.rdf.rdfbase.PlainLiteral <em>Plain Literal</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.eodm.rdf.rdfbase.PlainLiteral
	 * @generated
	 */
	public Adapter createPlainLiteralAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.eodm.rdf.rdfs.RDFSClass <em>RDFS Class</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.eodm.rdf.rdfs.RDFSClass
	 * @generated
	 */
	public Adapter createRDFSClassAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.eodm.owl.owlbase.Universe <em>Universe</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.eodm.owl.owlbase.Universe
	 * @generated
	 */
	public Adapter createUniverseAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.eodm.owl.owlbase.OWLClass <em>OWL Class</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.eodm.owl.owlbase.OWLClass
	 * @generated
	 */
	public Adapter createOWLClassAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.eodm.owl.owlbase.ComplementClass <em>Complement Class</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.eodm.owl.owlbase.ComplementClass
	 * @generated
	 */
	public Adapter createComplementClassAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.eodm.rdf.rdfbase.TypedLiteral <em>Typed Literal</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.eodm.rdf.rdfbase.TypedLiteral
	 * @generated
	 */
	public Adapter createTypedLiteralAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.eodm.rdf.rdfbase.RDFXMLLiteral <em>RDFXML Literal</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.eodm.rdf.rdfbase.RDFXMLLiteral
	 * @generated
	 */
	public Adapter createRDFXMLLiteralAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.eodm.owl.owlbase.OWLAllDifferent <em>OWL All Different</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.eodm.owl.owlbase.OWLAllDifferent
	 * @generated
	 */
	public Adapter createOWLAllDifferentAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.eodm.owl.owlbase.OWLRestriction <em>OWL Restriction</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.eodm.owl.owlbase.OWLRestriction
	 * @generated
	 */
	public Adapter createOWLRestrictionAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.eodm.owl.owlbase.CardinalityRestriction <em>Cardinality Restriction</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.eodm.owl.owlbase.CardinalityRestriction
	 * @generated
	 */
	public Adapter createCardinalityRestrictionAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.eodm.owl.owlbase.MinCardinalityRestriction <em>Min Cardinality Restriction</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.eodm.owl.owlbase.MinCardinalityRestriction
	 * @generated
	 */
	public Adapter createMinCardinalityRestrictionAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.eodm.owl.owlbase.SomeValuesFromRestriction <em>Some Values From Restriction</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.eodm.owl.owlbase.SomeValuesFromRestriction
	 * @generated
	 */
	public Adapter createSomeValuesFromRestrictionAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.eodm.owl.owlbase.Individual <em>Individual</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.eodm.owl.owlbase.Individual
	 * @generated
	 */
	public Adapter createIndividualAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.eodm.rdf.rdfs.RDFSContainer <em>RDFS Container</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.eodm.rdf.rdfs.RDFSContainer
	 * @generated
	 */
	public Adapter createRDFSContainerAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.eodm.rdf.rdfs.RDFAlt <em>RDF Alt</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.eodm.rdf.rdfs.RDFAlt
	 * @generated
	 */
	public Adapter createRDFAltAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.eodm.rdf.rdfs.RDFSeq <em>RDF Seq</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.eodm.rdf.rdfs.RDFSeq
	 * @generated
	 */
	public Adapter createRDFSeqAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.eodm.rdf.rdfs.RDFList <em>RDF List</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.eodm.rdf.rdfs.RDFList
	 * @generated
	 */
	public Adapter createRDFListAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.eodm.rdf.rdfbase.RDFProperty <em>RDF Property</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.eodm.rdf.rdfbase.RDFProperty
	 * @generated
	 */
	public Adapter createRDFPropertyAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.eodm.owl.owlbase.OWLAnnotationProperty <em>OWL Annotation Property</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.eodm.owl.owlbase.OWLAnnotationProperty
	 * @generated
	 */
	public Adapter createOWLAnnotationPropertyAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.eodm.owl.owlbase.Property <em>Property</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.eodm.owl.owlbase.Property
	 * @generated
	 */
	public Adapter createPropertyAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.eodm.owl.owlbase.OWLDatatypeProperty <em>OWL Datatype Property</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.eodm.owl.owlbase.OWLDatatypeProperty
	 * @generated
	 */
	public Adapter createOWLDatatypePropertyAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.eodm.owl.owlbase.OWLOntology <em>OWL Ontology</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.eodm.owl.owlbase.OWLOntology
	 * @generated
	 */
	public Adapter createOWLOntologyAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.eodm.rdf.rdfbase.RDFGraph <em>RDFGraph</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.eodm.rdf.rdfbase.RDFGraph
	 * @generated
	 */
	public Adapter createGraphAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.eodm.owl.owlbase.OWLGraph <em>OWL Graph</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.eodm.owl.owlbase.OWLGraph
	 * @generated
	 */
	public Adapter createOWLGraphAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.eodm.owl.owlbase.HasValueRestriction <em>Has Value Restriction</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.eodm.owl.owlbase.HasValueRestriction
	 * @generated
	 */
	public Adapter createHasValueRestrictionAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.eodm.owl.owlbase.AllValuesFromRestriction <em>All Values From Restriction</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.eodm.owl.owlbase.AllValuesFromRestriction
	 * @generated
	 */
	public Adapter createAllValuesFromRestrictionAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.eodm.owl.owlbase.MaxCardinalityRestriction <em>Max Cardinality Restriction</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.eodm.owl.owlbase.MaxCardinalityRestriction
	 * @generated
	 */
	public Adapter createMaxCardinalityRestrictionAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.eodm.owl.owlbase.IntersectionClass <em>Intersection Class</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.eodm.owl.owlbase.IntersectionClass
	 * @generated
	 */
	public Adapter createIntersectionClassAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.eodm.owl.owlbase.EnumeratedClass <em>Enumerated Class</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.eodm.owl.owlbase.EnumeratedClass
	 * @generated
	 */
	public Adapter createEnumeratedClassAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.eodm.owl.owlbase.UnionClass <em>Union Class</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.eodm.owl.owlbase.UnionClass
	 * @generated
	 */
	public Adapter createUnionClassAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.eodm.rdf.rdfs.RDFSDatatype <em>RDFS Datatype</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.eodm.rdf.rdfs.RDFSDatatype
	 * @generated
	 */
	public Adapter createRDFSDatatypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.eodm.owl.owlbase.OWLDataRange <em>OWL Data Range</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.eodm.owl.owlbase.OWLDataRange
	 * @generated
	 */
	public Adapter createOWLDataRangeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.eodm.rdf.rdfbase.RDFStatement <em>RDF Statement</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.eodm.rdf.rdfbase.RDFStatement
	 * @generated
	 */
	public Adapter createRDFStatementAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.eodm.owl.owlbase.Statement <em>Statement</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.eodm.owl.owlbase.Statement
	 * @generated
	 */
	public Adapter createStatementAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.eodm.rdf.rdfs.RDFBag <em>RDF Bag</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.eodm.rdf.rdfs.RDFBag
	 * @generated
	 */
	public Adapter createRDFBagAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.eodm.rdf.rdfbase.URIReferenceNode <em>URI Reference Node</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.eodm.rdf.rdfbase.URIReferenceNode
	 * @generated
	 */
	public Adapter createURIReferenceNodeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.eodm.owl.owlbase.OWLOntologyProperty <em>OWL Ontology Property</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.eodm.owl.owlbase.OWLOntologyProperty
	 * @generated
	 */
	public Adapter createOWLOntologyPropertyAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.eodm.rdf.rdfs.RDFSContainerMembershipProperty <em>RDFS Container Membership Property</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.eodm.rdf.rdfs.RDFSContainerMembershipProperty
	 * @generated
	 */
	public Adapter createRDFSContainerMembershipPropertyAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.eodm.owl.owlbase.OWLObjectProperty <em>OWL Object Property</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.eodm.owl.owlbase.OWLObjectProperty
	 * @generated
	 */
	public Adapter createOWLObjectPropertyAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.eodm.rdf.rdfweb.Document <em>Document</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.eodm.rdf.rdfweb.Document
	 * @generated
	 */
	public Adapter createDocumentAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for the default case.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @generated
	 */
	public Adapter createEObjectAdapter() {
		return null;
	}

} //EODMImplAdapterFactory
