/**
 * Copyright (c) 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   IBM - Initial API and implementation
 *
 * $Id: URIReferenceImpl.java,v 1.1 2007/03/18 08:10:12 lzhang Exp $
 */
package org.eclipse.eodm.rdf.rdfbase.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;

import org.eclipse.emf.ecore.util.EObjectWithInverseResolvingEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;

import org.eclipse.eodm.rdf.rdfbase.RDFSResource;
import org.eclipse.eodm.rdf.rdfbase.RDFStatement;
import org.eclipse.eodm.rdf.rdfbase.URIReference;
import org.eclipse.eodm.rdf.rdfbase.UniformResourceIdentifier;
import org.eclipse.eodm.rdf.rdfbase.util.RDFBasePackage;
import org.eclipse.eodm.rdf.rdfweb.LocalName;
import org.eclipse.eodm.rdf.rdfweb.Namespace;
import org.eclipse.eodm.rdf.rdfweb.util.RDFWebPackage;


/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>URI Reference</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.eodm.rdf.rdfbase.impl.URIReferenceImpl#getFragmentIdentifier <em>Fragment Identifier</em>}</li>
 *   <li>{@link org.eclipse.eodm.rdf.rdfbase.impl.URIReferenceImpl#getNamespace <em>Namespace</em>}</li>
 *   <li>{@link org.eclipse.eodm.rdf.rdfbase.impl.URIReferenceImpl#getResource <em>Resource</em>}</li>
 *   <li>{@link org.eclipse.eodm.rdf.rdfbase.impl.URIReferenceImpl#getReifiedStatement <em>Reified Statement</em>}</li>
 *   <li>{@link org.eclipse.eodm.rdf.rdfbase.impl.URIReferenceImpl#getUri <em>Uri</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class URIReferenceImpl extends EObjectImpl implements URIReference {
	
	/**
	 * Internal cache of the fully qualified URI string of this URIReference
	 */
	protected String fullyQualifiedURIString = null ;
	
	/**
	 * The cached value of the '{@link #getFragmentIdentifier() <em>Fragment Identifier</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getFragmentIdentifier()
	 * @generated
	 * @ordered
	 */
	protected LocalName fragmentIdentifier = null;

	/**
	 * The cached value of the '{@link #getNamespace() <em>Namespace</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getNamespace()
	 * @generated
	 * @ordered
	 */
	protected Namespace namespace = null;

	/**
	 * The cached value of the '{@link #getReifiedStatement() <em>Reified Statement</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getReifiedStatement()
	 * @generated
	 * @ordered
	 */
	protected EList reifiedStatement = null;

	/**
	 * The cached value of the '{@link #getUri() <em>Uri</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getUri()
	 * @generated
	 * @ordered
	 */
	protected UniformResourceIdentifier uri = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected URIReferenceImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return RDFBasePackage.eINSTANCE.getURIReference();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public LocalName getFragmentIdentifier() {
		if (fragmentIdentifier != null && fragmentIdentifier.eIsProxy()) {
			LocalName oldFragmentIdentifier = fragmentIdentifier;
			fragmentIdentifier = (LocalName)eResolveProxy((InternalEObject)fragmentIdentifier);
			if (fragmentIdentifier != oldFragmentIdentifier) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, RDFBasePackage.URI_REFERENCE__FRAGMENT_IDENTIFIER, oldFragmentIdentifier, fragmentIdentifier));
			}
		}
		return fragmentIdentifier;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public LocalName basicGetFragmentIdentifier() {
		return fragmentIdentifier;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetFragmentIdentifier(LocalName newFragmentIdentifier, NotificationChain msgs) {
		LocalName oldFragmentIdentifier = fragmentIdentifier;
		fragmentIdentifier = newFragmentIdentifier;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, RDFBasePackage.URI_REFERENCE__FRAGMENT_IDENTIFIER, oldFragmentIdentifier, newFragmentIdentifier);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setFragmentIdentifier(LocalName newFragmentIdentifier) {
		if (newFragmentIdentifier != fragmentIdentifier) {
			NotificationChain msgs = null;
			if (fragmentIdentifier != null)
				msgs = ((InternalEObject)fragmentIdentifier).eInverseRemove(this, RDFWebPackage.LOCAL_NAME__URI_REF, LocalName.class, msgs);
			if (newFragmentIdentifier != null)
				msgs = ((InternalEObject)newFragmentIdentifier).eInverseAdd(this, RDFWebPackage.LOCAL_NAME__URI_REF, LocalName.class, msgs);
			msgs = basicSetFragmentIdentifier(newFragmentIdentifier, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, RDFBasePackage.URI_REFERENCE__FRAGMENT_IDENTIFIER, newFragmentIdentifier, newFragmentIdentifier));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Namespace getNamespace() {
		if (namespace != null && namespace.eIsProxy()) {
			Namespace oldNamespace = namespace;
			namespace = (Namespace)eResolveProxy((InternalEObject)namespace);
			if (namespace != oldNamespace) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, RDFBasePackage.URI_REFERENCE__NAMESPACE, oldNamespace, namespace));
			}
		}
		return namespace;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Namespace basicGetNamespace() {
		return namespace;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setNamespace(Namespace newNamespace) {
		Namespace oldNamespace = namespace;
		namespace = newNamespace;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET, RDFBasePackage.URI_REFERENCE__NAMESPACE, oldNamespace, newNamespace));
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public RDFSResource getResource() {
		if (eContainerFeatureID != RDFBasePackage.URI_REFERENCE__RESOURCE) return null;
		return (RDFSResource)eContainer;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setResource(RDFSResource newResource) {
		if (newResource != eContainer || (eContainerFeatureID != RDFBasePackage.URI_REFERENCE__RESOURCE && newResource != null)) {
			if (EcoreUtil.isAncestor(this, newResource))
				throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
			NotificationChain msgs = null;
			if (eContainer != null)
				msgs = eBasicRemoveFromContainer(msgs);
			if (newResource != null)
				msgs = ((InternalEObject)newResource).eInverseAdd(this, RDFBasePackage.RDFS_RESOURCE__URI_REF, RDFSResource.class, msgs);
			msgs = eBasicSetContainer((InternalEObject)newResource, RDFBasePackage.URI_REFERENCE__RESOURCE, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, RDFBasePackage.URI_REFERENCE__RESOURCE, newResource, newResource));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getReifiedStatement() {
		if (reifiedStatement == null) {
			reifiedStatement = new EObjectWithInverseResolvingEList.ManyInverse(RDFStatement.class, this, RDFBasePackage.URI_REFERENCE__REIFIED_STATEMENT, RDFBasePackage.RDF_STATEMENT__NAME_FOR_REIFICATION);
		}
		return reifiedStatement;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public UniformResourceIdentifier getUri() {
		if (uri != null && uri.eIsProxy()) {
			UniformResourceIdentifier oldUri = uri;
			uri = (UniformResourceIdentifier)eResolveProxy((InternalEObject)uri);
			if (uri != oldUri) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, RDFBasePackage.URI_REFERENCE__URI, oldUri, uri));
			}
		}
		return uri;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public UniformResourceIdentifier basicGetUri() {
		return uri;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setUri(UniformResourceIdentifier newUri) {
		UniformResourceIdentifier oldUri = uri;
		uri = newUri;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, RDFBasePackage.URI_REFERENCE__URI, oldUri, uri));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case RDFBasePackage.URI_REFERENCE__FRAGMENT_IDENTIFIER:
					if (fragmentIdentifier != null)
						msgs = ((InternalEObject)fragmentIdentifier).eInverseRemove(this, RDFWebPackage.LOCAL_NAME__URI_REF, LocalName.class, msgs);
					return basicSetFragmentIdentifier((LocalName)otherEnd, msgs);
				case RDFBasePackage.URI_REFERENCE__RESOURCE:
					if (eContainer != null)
						msgs = eBasicRemoveFromContainer(msgs);
					return eBasicSetContainer(otherEnd, RDFBasePackage.URI_REFERENCE__RESOURCE, msgs);
				case RDFBasePackage.URI_REFERENCE__REIFIED_STATEMENT:
					return ((InternalEList)getReifiedStatement()).basicAdd(otherEnd, msgs);
				default:
					return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
			}
		}
		if (eContainer != null)
			msgs = eBasicRemoveFromContainer(msgs);
		return eBasicSetContainer(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case RDFBasePackage.URI_REFERENCE__FRAGMENT_IDENTIFIER:
					return basicSetFragmentIdentifier(null, msgs);
				case RDFBasePackage.URI_REFERENCE__RESOURCE:
					return eBasicSetContainer(null, RDFBasePackage.URI_REFERENCE__RESOURCE, msgs);
				case RDFBasePackage.URI_REFERENCE__REIFIED_STATEMENT:
					return ((InternalEList)getReifiedStatement()).basicRemove(otherEnd, msgs);
				default:
					return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
			}
		}
		return eBasicSetContainer(null, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eBasicRemoveFromContainer(NotificationChain msgs) {
		if (eContainerFeatureID >= 0) {
			switch (eContainerFeatureID) {
				case RDFBasePackage.URI_REFERENCE__RESOURCE:
					return eContainer.eInverseRemove(this, RDFBasePackage.RDFS_RESOURCE__URI_REF, RDFSResource.class, msgs);
				default:
					return eDynamicBasicRemoveFromContainer(msgs);
			}
		}
		return eContainer.eInverseRemove(this, EOPPOSITE_FEATURE_BASE - eContainerFeatureID, null, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case RDFBasePackage.URI_REFERENCE__FRAGMENT_IDENTIFIER:
				if (resolve) return getFragmentIdentifier();
				return basicGetFragmentIdentifier();
			case RDFBasePackage.URI_REFERENCE__NAMESPACE:
				if (resolve) return getNamespace();
				return basicGetNamespace();
			case RDFBasePackage.URI_REFERENCE__RESOURCE:
				return getResource();
			case RDFBasePackage.URI_REFERENCE__REIFIED_STATEMENT:
				return getReifiedStatement();
			case RDFBasePackage.URI_REFERENCE__URI:
				if (resolve) return getUri();
				return basicGetUri();
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case RDFBasePackage.URI_REFERENCE__FRAGMENT_IDENTIFIER:
				setFragmentIdentifier((LocalName)newValue);
				return;
			case RDFBasePackage.URI_REFERENCE__NAMESPACE:
				setNamespace((Namespace)newValue);
				return;
			case RDFBasePackage.URI_REFERENCE__RESOURCE:
				setResource((RDFSResource)newValue);
				return;
			case RDFBasePackage.URI_REFERENCE__REIFIED_STATEMENT:
				getReifiedStatement().clear();
				getReifiedStatement().addAll((Collection)newValue);
				return;
			case RDFBasePackage.URI_REFERENCE__URI:
				setUri((UniformResourceIdentifier)newValue);
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case RDFBasePackage.URI_REFERENCE__FRAGMENT_IDENTIFIER:
				setFragmentIdentifier((LocalName)null);
				return;
			case RDFBasePackage.URI_REFERENCE__NAMESPACE:
				setNamespace((Namespace)null);
				return;
			case RDFBasePackage.URI_REFERENCE__RESOURCE:
				setResource((RDFSResource)null);
				return;
			case RDFBasePackage.URI_REFERENCE__REIFIED_STATEMENT:
				getReifiedStatement().clear();
				return;
			case RDFBasePackage.URI_REFERENCE__URI:
				setUri((UniformResourceIdentifier)null);
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case RDFBasePackage.URI_REFERENCE__FRAGMENT_IDENTIFIER:
				return fragmentIdentifier != null;
			case RDFBasePackage.URI_REFERENCE__NAMESPACE:
				return namespace != null;
			case RDFBasePackage.URI_REFERENCE__RESOURCE:
				return getResource() != null;
			case RDFBasePackage.URI_REFERENCE__REIFIED_STATEMENT:
				return reifiedStatement != null && !reifiedStatement.isEmpty();
			case RDFBasePackage.URI_REFERENCE__URI:
				return uri != null;
		}
		return eDynamicIsSet(eFeature);
	}

	public String getURIString() {
		if ( fullyQualifiedURIString != null )
			return fullyQualifiedURIString ;
		
		if ( this.getUri() != null )
			return this.getUri().getName() ;
		else
		{
			String ns = this.getNamespace().getNamespaceURIRef().getURIString();
			String localname = this.getFragmentIdentifier().getName();
			fullyQualifiedURIString = ns + localname ;
			return fullyQualifiedURIString ;
		}
	}

} //URIReferenceImpl
