/**
 * Copyright (c) 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   IBM - Initial API and implementation
 *
 * $Id: URIReferenceNodeImpl.java,v 1.1 2007/03/18 08:10:12 lzhang Exp $
 */
package org.eclipse.eodm.rdf.rdfbase.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.util.InternalEList;

import org.eclipse.eodm.rdf.rdfbase.URIReferenceNode;
import org.eclipse.eodm.rdf.rdfbase.util.RDFBasePackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>URI Reference Node</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * </p>
 *
 * @generated
 */
public class URIReferenceNodeImpl extends RDFSResourceImpl implements URIReferenceNode {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected URIReferenceNodeImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return RDFBasePackage.eINSTANCE.getURIReferenceNode();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case RDFBasePackage.URI_REFERENCE_NODE__URI_REF:
					return ((InternalEList)getUriRef()).basicAdd(otherEnd, msgs);
				case RDFBasePackage.URI_REFERENCE_NODE__SUBJECT_STATEMENT:
					return ((InternalEList)getSubjectStatement()).basicAdd(otherEnd, msgs);
				default:
					return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
			}
		}
		if (eContainer != null)
			msgs = eBasicRemoveFromContainer(msgs);
		return eBasicSetContainer(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case RDFBasePackage.URI_REFERENCE_NODE__RDF_SCOMMENT:
					return ((InternalEList)getRDFScomment()).basicRemove(otherEnd, msgs);
				case RDFBasePackage.URI_REFERENCE_NODE__RDF_SLABEL:
					return ((InternalEList)getRDFSlabel()).basicRemove(otherEnd, msgs);
				case RDFBasePackage.URI_REFERENCE_NODE__URI_REF:
					return ((InternalEList)getUriRef()).basicRemove(otherEnd, msgs);
				case RDFBasePackage.URI_REFERENCE_NODE__SUBJECT_STATEMENT:
					return ((InternalEList)getSubjectStatement()).basicRemove(otherEnd, msgs);
				default:
					return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
			}
		}
		return eBasicSetContainer(null, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case RDFBasePackage.URI_REFERENCE_NODE__RDF_SIS_DEFINED_BY:
				return getRDFSisDefinedBy();
			case RDFBasePackage.URI_REFERENCE_NODE__RDF_SSEE_ALSO:
				return getRDFSseeAlso();
			case RDFBasePackage.URI_REFERENCE_NODE__RD_FTYPE:
				return getRDFtype();
			case RDFBasePackage.URI_REFERENCE_NODE__RDF_SMEMBER:
				return getRDFSmember();
			case RDFBasePackage.URI_REFERENCE_NODE__NODE_ID:
				return getNodeID();
			case RDFBasePackage.URI_REFERENCE_NODE__RDF_SCOMMENT:
				return getRDFScomment();
			case RDFBasePackage.URI_REFERENCE_NODE__RDF_SLABEL:
				return getRDFSlabel();
			case RDFBasePackage.URI_REFERENCE_NODE__URI_REF:
				return getUriRef();
			case RDFBasePackage.URI_REFERENCE_NODE__SUBJECT_STATEMENT:
				return getSubjectStatement();
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case RDFBasePackage.URI_REFERENCE_NODE__RDF_SIS_DEFINED_BY:
				getRDFSisDefinedBy().clear();
				getRDFSisDefinedBy().addAll((Collection)newValue);
				return;
			case RDFBasePackage.URI_REFERENCE_NODE__RDF_SSEE_ALSO:
				getRDFSseeAlso().clear();
				getRDFSseeAlso().addAll((Collection)newValue);
				return;
			case RDFBasePackage.URI_REFERENCE_NODE__RD_FTYPE:
				getRDFtype().clear();
				getRDFtype().addAll((Collection)newValue);
				return;
			case RDFBasePackage.URI_REFERENCE_NODE__RDF_SMEMBER:
				getRDFSmember().clear();
				getRDFSmember().addAll((Collection)newValue);
				return;
			case RDFBasePackage.URI_REFERENCE_NODE__NODE_ID:
				setNodeID((String)newValue);
				return;
			case RDFBasePackage.URI_REFERENCE_NODE__RDF_SCOMMENT:
				getRDFScomment().clear();
				getRDFScomment().addAll((Collection)newValue);
				return;
			case RDFBasePackage.URI_REFERENCE_NODE__RDF_SLABEL:
				getRDFSlabel().clear();
				getRDFSlabel().addAll((Collection)newValue);
				return;
			case RDFBasePackage.URI_REFERENCE_NODE__URI_REF:
				getUriRef().clear();
				getUriRef().addAll((Collection)newValue);
				return;
			case RDFBasePackage.URI_REFERENCE_NODE__SUBJECT_STATEMENT:
				getSubjectStatement().clear();
				getSubjectStatement().addAll((Collection)newValue);
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case RDFBasePackage.URI_REFERENCE_NODE__RDF_SIS_DEFINED_BY:
				getRDFSisDefinedBy().clear();
				return;
			case RDFBasePackage.URI_REFERENCE_NODE__RDF_SSEE_ALSO:
				getRDFSseeAlso().clear();
				return;
			case RDFBasePackage.URI_REFERENCE_NODE__RD_FTYPE:
				getRDFtype().clear();
				return;
			case RDFBasePackage.URI_REFERENCE_NODE__RDF_SMEMBER:
				getRDFSmember().clear();
				return;
			case RDFBasePackage.URI_REFERENCE_NODE__NODE_ID:
				setNodeID(NODE_ID_EDEFAULT);
				return;
			case RDFBasePackage.URI_REFERENCE_NODE__RDF_SCOMMENT:
				getRDFScomment().clear();
				return;
			case RDFBasePackage.URI_REFERENCE_NODE__RDF_SLABEL:
				getRDFSlabel().clear();
				return;
			case RDFBasePackage.URI_REFERENCE_NODE__URI_REF:
				getUriRef().clear();
				return;
			case RDFBasePackage.URI_REFERENCE_NODE__SUBJECT_STATEMENT:
				getSubjectStatement().clear();
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case RDFBasePackage.URI_REFERENCE_NODE__RDF_SIS_DEFINED_BY:
				return rdfSisDefinedBy != null && !rdfSisDefinedBy.isEmpty();
			case RDFBasePackage.URI_REFERENCE_NODE__RDF_SSEE_ALSO:
				return rdfSseeAlso != null && !rdfSseeAlso.isEmpty();
			case RDFBasePackage.URI_REFERENCE_NODE__RD_FTYPE:
				return rdFtype != null && !rdFtype.isEmpty();
			case RDFBasePackage.URI_REFERENCE_NODE__RDF_SMEMBER:
				return rdfSmember != null && !rdfSmember.isEmpty();
			case RDFBasePackage.URI_REFERENCE_NODE__NODE_ID:
				return NODE_ID_EDEFAULT == null ? nodeID != null : !NODE_ID_EDEFAULT.equals(nodeID);
			case RDFBasePackage.URI_REFERENCE_NODE__RDF_SCOMMENT:
				return rdfScomment != null && !rdfScomment.isEmpty();
			case RDFBasePackage.URI_REFERENCE_NODE__RDF_SLABEL:
				return rdfSlabel != null && !rdfSlabel.isEmpty();
			case RDFBasePackage.URI_REFERENCE_NODE__URI_REF:
				return uriRef != null && !uriRef.isEmpty();
			case RDFBasePackage.URI_REFERENCE_NODE__SUBJECT_STATEMENT:
				return subjectStatement != null && !subjectStatement.isEmpty();
		}
		return eDynamicIsSet(eFeature);
	}

} //URIReferenceNodeImpl
