/**
 * Copyright (c) 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   IBM - Initial API and implementation
 *
 * $Id: DocumentImpl.java,v 1.1 2007/03/18 08:10:12 lzhang Exp $
 */
package org.eclipse.eodm.rdf.rdfweb.impl;

import java.util.Collection;
import java.util.ArrayList;

import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.emf.ecore.util.EObjectWithInverseResolvingEList;
import org.eclipse.emf.ecore.util.InternalEList;

import org.eclipse.eodm.rdf.rdfbase.RDFGraph;
import org.eclipse.eodm.rdf.rdfbase.RDFStatement;
import org.eclipse.eodm.rdf.rdfbase.impl.RDFSResourceImpl;
import org.eclipse.eodm.rdf.rdfbase.util.RDFBasePackage;
import org.eclipse.eodm.rdf.rdfweb.Document;
import org.eclipse.eodm.rdf.rdfweb.LocalName;
import org.eclipse.eodm.rdf.rdfweb.Namespace;
import org.eclipse.eodm.rdf.rdfweb.NamespaceDefinition;
import org.eclipse.eodm.rdf.rdfweb.util.RDFWebPackage;




/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Document</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.eodm.rdf.rdfweb.impl.DocumentImpl#getStatement <em>Statement</em>}</li>
 *   <li>{@link org.eclipse.eodm.rdf.rdfweb.impl.DocumentImpl#getLocalName <em>Local Name</em>}</li>
 *   <li>{@link org.eclipse.eodm.rdf.rdfweb.impl.DocumentImpl#getXmlBase <em>Xml Base</em>}</li>
 *   <li>{@link org.eclipse.eodm.rdf.rdfweb.impl.DocumentImpl#getNamespaceDefinition <em>Namespace Definition</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class DocumentImpl extends RDFSResourceImpl implements Document {
	protected RDFGraph complementalGraph =  null;
	/**
	 * The cached value of the '{@link #getStatement() <em>Statement</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getStatement()
	 * @generated
	 * @ordered
	 */
	protected EList statement = null;

	/**
	 * The cached value of the '{@link #getLocalName() <em>Local Name</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLocalName()
	 * @generated
	 * @ordered
	 */
	protected EList localName = null;

	/**
	 * The cached value of the '{@link #getXmlBase() <em>Xml Base</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getXmlBase()
	 * @generated
	 * @ordered
	 */
	protected EList xmlBase = null;

	/**
	 * The cached value of the '{@link #getNamespaceDefinition() <em>Namespace Definition</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getNamespaceDefinition()
	 * @generated
	 * @ordered
	 */
	protected EList namespaceDefinition = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DocumentImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return RDFWebPackage.eINSTANCE.getDocument();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getStatement() {
		if (statement == null) {
			statement = new EObjectWithInverseResolvingEList.ManyInverse(RDFStatement.class, this, RDFWebPackage.DOCUMENT__STATEMENT, RDFBasePackage.RDF_STATEMENT__DOCUMENT);
		}
		return statement;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getLocalName() {
		if (localName == null) {
			localName = new EObjectContainmentEList(LocalName.class, this, RDFWebPackage.DOCUMENT__LOCAL_NAME);
		}
		return localName;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getXmlBase() {
		if (xmlBase == null) {
			xmlBase = new EObjectResolvingEList(Namespace.class, this, RDFWebPackage.DOCUMENT__XML_BASE);
		}
		return xmlBase;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getNamespaceDefinition() {
		if (namespaceDefinition == null) {
			namespaceDefinition = new EObjectContainmentEList(NamespaceDefinition.class, this, RDFWebPackage.DOCUMENT__NAMESPACE_DEFINITION);
		}
		return namespaceDefinition;
	}
	/**
	 * The value of the '<em><b>Graphs</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.eodm.rdf.rdfbase.RDFGraph}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * The Graphs EList of the Document can be operated to add, delete or retrieve RDFGraph.  
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Graphs</em>' containment reference list.
	 * @generated
	 */
	public ArrayList getGraphs()
	{
		return null;
	}
	/**
	 * The resources excluded from EList returned by {@link #getGraphs() getGraphs()}
	 * are included the complemental graph.
	 * @return the value of complemental graph
	 */
	
	
	public RDFGraph getComplementalGraph()
	{
		return this.complementalGraph;
	}

	
	public void setComplementalGraph(RDFGraph graph)
	{
		this.complementalGraph = graph; 
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case RDFWebPackage.DOCUMENT__URI_REF:
					return ((InternalEList)getUriRef()).basicAdd(otherEnd, msgs);
				case RDFWebPackage.DOCUMENT__SUBJECT_STATEMENT:
					return ((InternalEList)getSubjectStatement()).basicAdd(otherEnd, msgs);
				case RDFWebPackage.DOCUMENT__STATEMENT:
					return ((InternalEList)getStatement()).basicAdd(otherEnd, msgs);
				default:
					return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
			}
		}
		if (eContainer != null)
			msgs = eBasicRemoveFromContainer(msgs);
		return eBasicSetContainer(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case RDFWebPackage.DOCUMENT__RDF_SCOMMENT:
					return ((InternalEList)getRDFScomment()).basicRemove(otherEnd, msgs);
				case RDFWebPackage.DOCUMENT__RDF_SLABEL:
					return ((InternalEList)getRDFSlabel()).basicRemove(otherEnd, msgs);
				case RDFWebPackage.DOCUMENT__URI_REF:
					return ((InternalEList)getUriRef()).basicRemove(otherEnd, msgs);
				case RDFWebPackage.DOCUMENT__SUBJECT_STATEMENT:
					return ((InternalEList)getSubjectStatement()).basicRemove(otherEnd, msgs);
				case RDFWebPackage.DOCUMENT__STATEMENT:
					return ((InternalEList)getStatement()).basicRemove(otherEnd, msgs);
				case RDFWebPackage.DOCUMENT__LOCAL_NAME:
					return ((InternalEList)getLocalName()).basicRemove(otherEnd, msgs);
				case RDFWebPackage.DOCUMENT__NAMESPACE_DEFINITION:
					return ((InternalEList)getNamespaceDefinition()).basicRemove(otherEnd, msgs);
				default:
					return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
			}
		}
		return eBasicSetContainer(null, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case RDFWebPackage.DOCUMENT__RDF_SIS_DEFINED_BY:
				return getRDFSisDefinedBy();
			case RDFWebPackage.DOCUMENT__RDF_SSEE_ALSO:
				return getRDFSseeAlso();
			case RDFWebPackage.DOCUMENT__RD_FTYPE:
				return getRDFtype();
			case RDFWebPackage.DOCUMENT__RDF_SMEMBER:
				return getRDFSmember();
			case RDFWebPackage.DOCUMENT__NODE_ID:
				return getNodeID();
			case RDFWebPackage.DOCUMENT__RDF_SCOMMENT:
				return getRDFScomment();
			case RDFWebPackage.DOCUMENT__RDF_SLABEL:
				return getRDFSlabel();
			case RDFWebPackage.DOCUMENT__URI_REF:
				return getUriRef();
			case RDFWebPackage.DOCUMENT__SUBJECT_STATEMENT:
				return getSubjectStatement();
			case RDFWebPackage.DOCUMENT__STATEMENT:
				return getStatement();
			case RDFWebPackage.DOCUMENT__LOCAL_NAME:
				return getLocalName();
			case RDFWebPackage.DOCUMENT__XML_BASE:
				return getXmlBase();
			case RDFWebPackage.DOCUMENT__NAMESPACE_DEFINITION:
				return getNamespaceDefinition();
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case RDFWebPackage.DOCUMENT__RDF_SIS_DEFINED_BY:
				getRDFSisDefinedBy().clear();
				getRDFSisDefinedBy().addAll((Collection)newValue);
				return;
			case RDFWebPackage.DOCUMENT__RDF_SSEE_ALSO:
				getRDFSseeAlso().clear();
				getRDFSseeAlso().addAll((Collection)newValue);
				return;
			case RDFWebPackage.DOCUMENT__RD_FTYPE:
				getRDFtype().clear();
				getRDFtype().addAll((Collection)newValue);
				return;
			case RDFWebPackage.DOCUMENT__RDF_SMEMBER:
				getRDFSmember().clear();
				getRDFSmember().addAll((Collection)newValue);
				return;
			case RDFWebPackage.DOCUMENT__NODE_ID:
				setNodeID((String)newValue);
				return;
			case RDFWebPackage.DOCUMENT__RDF_SCOMMENT:
				getRDFScomment().clear();
				getRDFScomment().addAll((Collection)newValue);
				return;
			case RDFWebPackage.DOCUMENT__RDF_SLABEL:
				getRDFSlabel().clear();
				getRDFSlabel().addAll((Collection)newValue);
				return;
			case RDFWebPackage.DOCUMENT__URI_REF:
				getUriRef().clear();
				getUriRef().addAll((Collection)newValue);
				return;
			case RDFWebPackage.DOCUMENT__SUBJECT_STATEMENT:
				getSubjectStatement().clear();
				getSubjectStatement().addAll((Collection)newValue);
				return;
			case RDFWebPackage.DOCUMENT__STATEMENT:
				getStatement().clear();
				getStatement().addAll((Collection)newValue);
				return;
			case RDFWebPackage.DOCUMENT__LOCAL_NAME:
				getLocalName().clear();
				getLocalName().addAll((Collection)newValue);
				return;
			case RDFWebPackage.DOCUMENT__XML_BASE:
				getXmlBase().clear();
				getXmlBase().addAll((Collection)newValue);
				return;
			case RDFWebPackage.DOCUMENT__NAMESPACE_DEFINITION:
				getNamespaceDefinition().clear();
				getNamespaceDefinition().addAll((Collection)newValue);
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case RDFWebPackage.DOCUMENT__RDF_SIS_DEFINED_BY:
				getRDFSisDefinedBy().clear();
				return;
			case RDFWebPackage.DOCUMENT__RDF_SSEE_ALSO:
				getRDFSseeAlso().clear();
				return;
			case RDFWebPackage.DOCUMENT__RD_FTYPE:
				getRDFtype().clear();
				return;
			case RDFWebPackage.DOCUMENT__RDF_SMEMBER:
				getRDFSmember().clear();
				return;
			case RDFWebPackage.DOCUMENT__NODE_ID:
				setNodeID(NODE_ID_EDEFAULT);
				return;
			case RDFWebPackage.DOCUMENT__RDF_SCOMMENT:
				getRDFScomment().clear();
				return;
			case RDFWebPackage.DOCUMENT__RDF_SLABEL:
				getRDFSlabel().clear();
				return;
			case RDFWebPackage.DOCUMENT__URI_REF:
				getUriRef().clear();
				return;
			case RDFWebPackage.DOCUMENT__SUBJECT_STATEMENT:
				getSubjectStatement().clear();
				return;
			case RDFWebPackage.DOCUMENT__STATEMENT:
				getStatement().clear();
				return;
			case RDFWebPackage.DOCUMENT__LOCAL_NAME:
				getLocalName().clear();
				return;
			case RDFWebPackage.DOCUMENT__XML_BASE:
				getXmlBase().clear();
				return;
			case RDFWebPackage.DOCUMENT__NAMESPACE_DEFINITION:
				getNamespaceDefinition().clear();
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case RDFWebPackage.DOCUMENT__RDF_SIS_DEFINED_BY:
				return rdfSisDefinedBy != null && !rdfSisDefinedBy.isEmpty();
			case RDFWebPackage.DOCUMENT__RDF_SSEE_ALSO:
				return rdfSseeAlso != null && !rdfSseeAlso.isEmpty();
			case RDFWebPackage.DOCUMENT__RD_FTYPE:
				return rdFtype != null && !rdFtype.isEmpty();
			case RDFWebPackage.DOCUMENT__RDF_SMEMBER:
				return rdfSmember != null && !rdfSmember.isEmpty();
			case RDFWebPackage.DOCUMENT__NODE_ID:
				return NODE_ID_EDEFAULT == null ? nodeID != null : !NODE_ID_EDEFAULT.equals(nodeID);
			case RDFWebPackage.DOCUMENT__RDF_SCOMMENT:
				return rdfScomment != null && !rdfScomment.isEmpty();
			case RDFWebPackage.DOCUMENT__RDF_SLABEL:
				return rdfSlabel != null && !rdfSlabel.isEmpty();
			case RDFWebPackage.DOCUMENT__URI_REF:
				return uriRef != null && !uriRef.isEmpty();
			case RDFWebPackage.DOCUMENT__SUBJECT_STATEMENT:
				return subjectStatement != null && !subjectStatement.isEmpty();
			case RDFWebPackage.DOCUMENT__STATEMENT:
				return statement != null && !statement.isEmpty();
			case RDFWebPackage.DOCUMENT__LOCAL_NAME:
				return localName != null && !localName.isEmpty();
			case RDFWebPackage.DOCUMENT__XML_BASE:
				return xmlBase != null && !xmlBase.isEmpty();
			case RDFWebPackage.DOCUMENT__NAMESPACE_DEFINITION:
				return namespaceDefinition != null && !namespaceDefinition.isEmpty();
		}
		return eDynamicIsSet(eFeature);
	}

} //DocumentImpl
