/**
 * <copyright> 
 * 
 * Copyright (c) 2004-2005 IBM Corporation and others. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License - v 1.0 
 * which accompanies this distribution, and is available at 
 * http://opensource.org/licenses/eclipse-1.0.txt 
 * 
 * Contributors: 
 *   IBM - Initial API and implementation 
 * 
 * </copyright> 
 * 
 * $Id: XSD.java,v 1.1 2007/03/18 08:10:13 lzhang Exp $
 */

package org.eclipse.eodm.vocabulary;

/**
 * The XSD datatype. see http://www.w3.org/2001/XMLSchema#
 */
public class XSD {

    /** usually we use this shortname for this namespace */
    public static final String SHORTNAME = "xsd";

    /** full URI of this namespace */
    public static final String NAMESPACE = "http://www.w3.org/2001/XMLSchema#";

    public static final String ECORE_INSTANCE_CLASS_NAME = "EcoreInstanceClassName-";

    // Ecore URI
    public static final String ECORE_NAMESPACE = "http://org.eclipse.emf/ecor/EcorePackage/";

    //////////////////////////////////////////////////////////
    // localname of URI
    //////////////////////////////////////////////////////////
    /** RDFSResource for xsd:float */
    public static String sxfloat = "float";

    /** RDFSResource for xsd:double */
    public static String sxdouble = "double";

    /** RDFSResource for xsd:int */
    public static String sxint = "int";

    /** RDFSResource for xsd:long */
    public static String sxlong = "long";

    /** RDFSResource for xsd:short */
    public static String sxshort = "short";

    /** RDFSResource for xsd:byte */
    public static String sxbyte = "byte";

    /** RDFSResource for xsd:boolean */
    public static String sxboolean = "boolean";

    /** RDFSResource for xsd:string */
    public static String sxstring = "string";

    /** RDFSResource for xsd:unsignedByte */
    public static String sunsignedByte = "unsignedByte";

    /** RDFSResource for xsd:unsignedShort */
    public static String sunsignedShort = "unsignedShort";

    /** RDFSResource for xsd:unsignedInt */
    public static String sunsignedInt = "unsignedInt";

    /** RDFSResource for xsd:unsignedLong */
    public static String sunsignedLong = "unsignedLong";

    /** RDFSResource for xsd:decimal */
    public static String sdecimal = "decimal";

    /** RDFSResource for xsd:integer */
    public static String sinteger = "integer";

    /** RDFSResource for xsd:nonPositiveInteger */
    public static String snonPositiveInteger = "nonPositiveInteger";

    /** RDFSResource for xsd:nonNegativeInteger */
    public static String snonNegativeInteger = "nonNegativeInteger";

    /** RDFSResource for xsd:positiveInteger */
    public static String spositiveInteger = "positiveInteger";

    /** RDFSResource for xsd:negativeInteger */
    public static String snegativeInteger = "negativeInteger";

    /** RDFSResource for xsd:normalizedString */
    public static String snormalizedString = "normalizedString";

    /** RDFSResource for xsd:anyURI */
    public static String sanyURI = "anyURI";

    /** RDFSResource for xsd:token */
    public static String stoken = "token";

    /** RDFSResource for xsd:Name */
    public static String sName = "Name";

    /** RDFSResource for xsd:QName */
    public static String sQName = "QName";

    /** RDFSResource for xsd:language */
    public static String slanguage = "language";

    /** RDFSResource for xsd:NMTOKEN */
    public static String sNMTOKEN = "NMTOKEN";

    /** RDFSResource for xsd:ENTITIES */
    public static String sENTITIES = "ENTITIES";

    /** RDFSResource for xsd:NMTOKENS */
    public static String sNMTOKENS = "NMTOKENS";

    /** RDFSResource for xsd:ENTITY */
    public static String sENTITY = "ENTITY";

    /** RDFSResource for xsd:ID */
    public static String sID = "ID";

    /** RDFSResource for xsd:NCName */
    public static String sNCName = "NCName";

    /** RDFSResource for xsd:IDREF */
    public static String sIDREF = "IDREF";

    /** RDFSResource for xsd:IDREFS */
    public static String sIDREFS = "IDREFS";

    /** RDFSResource for xsd:NOTATION */
    public static String sNOTATION = "NOTATION";

    /** RDFSResource for xsd:hexBinary */
    public static String shexBinary = "hexBinary";

    /** RDFSResource for xsd:base64Binary */
    public static String sbase64Binary = "base64Binary";

    /** RDFSResource for xsd:date */
    public static String sdate = "date";

    /** RDFSResource for xsd:time */
    public static String stime = "time";

    /** RDFSResource for xsd:dateTime */
    public static String sdateTime = "dateTime";

    /** RDFSResource for xsd:duration */
    public static String sduration = "duration";

    /** RDFSResource for xsd:gDay */
    public static String sgDay = "gDay";

    /** RDFSResource for xsd:gMonth */
    public static String sgMonth = "gMonth";

    /** RDFSResource for xsd:gYear */
    public static String sgYear = "gYear";

    /** RDFSResource for xsd:gYearMonth */
    public static String sgYearMonth = "gYearMonth";

    /** RDFSResource for xsd:gMonthDay */
    public static String sgMonthDay = "gMonthDay";
}