/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.sequence.figures;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Layer;
import org.eclipse.draw2d.LayeredPane;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.uml2.diagram.common.layered.MultiLayeredContainer;
import org.eclipse.uml2.diagram.sequence.figures.InteractionContentsLayout;
import org.eclipse.uml2.diagram.sequence.figures.ShadowHelper;

public class MultiLayeredContentPane
extends LayeredPane
implements MultiLayeredContainer {
    private final Layer myDefaultLayerContentPane;
    private final Map<String, Layer> myLayerKeyToContentPane = new HashMap<String, Layer>(3);

    public MultiLayeredContentPane() {
        this.setBorder((Border)new MarginBorder(5));
        this.setOpaque(false);
        this.setLayoutManager((LayoutManager)new DebugStackLayout());
        this.addLayer("Background layer");
        this.myDefaultLayerContentPane = this.addLayer("Middle layer");
        this.addLayer("Foreground layer");
    }

    private Layer addLayer(String key) {
        LayerWithKey layer = new LayerWithKey(key);
        layer.setOpaque(false);
        if ("Middle layer".equals(key)) {
            layer.setOpaque(true);
        }
        this.add((IFigure)layer, key);
        Layer contentPane = ShadowHelper.addChildrenShadowLayer((IFigure)layer, key);
        contentPane.setLayoutManager((LayoutManager)new InteractionContentsLayout());
        this.myLayerKeyToContentPane.put(key, contentPane);
        return contentPane;
    }

    protected void paintFigure(Graphics graphics) {
    }

    public Layer getLayerContentPane(String key) {
        return this.myLayerKeyToContentPane.get(key);
    }

    public Layer getDefaultLayerContentPane() {
        return this.myDefaultLayerContentPane;
    }

    private static class DebugStackLayout
    extends StackLayout {
        private DebugStackLayout() {
        }

        public void layout(IFigure figure) {
            super.layout(figure);
        }
    }

    private static class LayerWithKey
    extends Layer {
        private final String myDebugKey;

        public LayerWithKey(String debugKey) {
            this.myDebugKey = debugKey;
        }

        public String toString() {
            return "Layer: [" + this.myDebugKey + "]";
        }
    }
}

