/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.uml.internal.operations;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.uml2.uml.BehavioredClassifier;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.RedefinableElement;
import org.eclipse.uml2.uml.Region;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.StateMachine;
import org.eclipse.uml2.uml.internal.operations.BehaviorOperations;
import org.eclipse.uml2.uml.internal.operations.RedefinableElementOperations;

public class StateMachineOperations
extends BehaviorOperations {
    protected StateMachineOperations() {
    }

    public static boolean validateClassifierContext(StateMachine stateMachine, DiagnosticChain diagnostics, Map context) {
        return true;
    }

    public static boolean validateContextClassifier(StateMachine stateMachine, DiagnosticChain diagnostics, Map context) {
        return true;
    }

    public static boolean validateConnectionPoints(StateMachine stateMachine, DiagnosticChain diagnostics, Map context) {
        return true;
    }

    public static boolean validateMethod(StateMachine stateMachine, DiagnosticChain diagnostics, Map context) {
        return true;
    }

    public static Namespace LCA(StateMachine stateMachine, State s1, State s2) {
        if (s1 == null || stateMachine.ancestor(s2, s1)) {
            return s1;
        }
        if (s2 == null || stateMachine.ancestor(s1, s2)) {
            return s2;
        }
        Region container1 = s1.getContainer();
        while (container1 != null) {
            State container1State = container1.getState();
            if (container1State == null) break;
            if (stateMachine.ancestor(s2, container1State)) {
                return container1;
            }
            container1 = container1State.getContainer();
        }
        Region container2 = s2.getContainer();
        while (container2 != null) {
            State container2State = container2.getState();
            if (container2State == null) break;
            if (stateMachine.ancestor(s1, container2State)) {
                return container2;
            }
            container2 = container2State.getContainer();
        }
        return null;
    }

    public static boolean ancestor(StateMachine stateMachine, State s1, State s2) {
        Region container1;
        if (s1 == s2) {
            return true;
        }
        Region region = container1 = s1 == null ? null : s1.getContainer();
        if (container1 == null) {
            return false;
        }
        State container1State = container1.getState();
        return container1State != null && stateMachine.ancestor(container1State, s2);
    }

    public static boolean isRedefinitionContextValid(StateMachine stateMachine, StateMachine redefined) {
        if (redefined != null) {
            BehavioredClassifier context = stateMachine.getContext();
            return context != null && context.allParents().contains((Object)redefined.getContext());
        }
        return false;
    }

    public static boolean isConsistentWith(StateMachine stateMachine, RedefinableElement redefinee) {
        if (redefinee != null && redefinee.isRedefinitionContextValid(stateMachine)) {
            StateMachine redefineeStateMachine = (StateMachine)redefinee;
            EList allRegions = StateMachineOperations.getAllRegions(stateMachine);
            Iterator redefineeRegions = redefineeStateMachine.getRegions().iterator();
            while (redefineeRegions.hasNext()) {
                Region redefineeRegion = (Region)redefineeRegions.next();
                Region extendedRegion = redefineeRegion.getExtendedRegion();
                if (!allRegions.contains((Object)extendedRegion) || extendedRegion.isConsistentWith(redefineeRegion)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected static EList getAllExtendedStateMachines(StateMachine stateMachine, EList allExtendedStateMachines) {
        Iterator extendedStateMachines = stateMachine.getExtendedStateMachines().iterator();
        while (extendedStateMachines.hasNext()) {
            StateMachine extendedStateMachine = (StateMachine)extendedStateMachines.next();
            if (!allExtendedStateMachines.add((Object)extendedStateMachine)) continue;
            StateMachineOperations.getAllExtendedStateMachines(extendedStateMachine, allExtendedStateMachines);
        }
        return allExtendedStateMachines;
    }

    protected static EList getAllExtendedStateMachines(StateMachine stateMachine) {
        return StateMachineOperations.getAllExtendedStateMachines(stateMachine, (EList)new UniqueEList.FastCompare());
    }

    protected static EList getAllRegions(StateMachine stateMachine) {
        UniqueEList.FastCompare allRegions = new UniqueEList.FastCompare((Collection)stateMachine.getRegions());
        Iterator allExtendedStateMachines = StateMachineOperations.getAllExtendedStateMachines(stateMachine).iterator();
        while (allExtendedStateMachines.hasNext()) {
            allRegions.addAll((Collection)((StateMachine)allExtendedStateMachines.next()).getRegions());
        }
        return RedefinableElementOperations.excludeRedefinedElements((EList)allRegions);
    }
}

