/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.uml.internal.operations;

import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.uml2.uml.AggregationKind;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Extension;
import org.eclipse.uml2.uml.ExtensionEnd;
import org.eclipse.uml2.uml.Image;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.internal.operations.ClassOperations;

public class StereotypeOperations
extends ClassOperations {
    protected StereotypeOperations() {
    }

    public static boolean validateNameNotClash(Stereotype stereotype, DiagnosticChain diagnostics, Map context) {
        return true;
    }

    public static boolean validateGeneralize(Stereotype stereotype, DiagnosticChain diagnostics, Map context) {
        return true;
    }

    public static Extension createExtension(Stereotype stereotype, Class metaclass, boolean isRequired) {
        String name = stereotype.getName();
        if (StereotypeOperations.isEmpty((String)name)) {
            throw new IllegalStateException();
        }
        Profile profile = stereotype.getProfile();
        if (profile == null) {
            throw new IllegalStateException();
        }
        if (metaclass == null || !metaclass.isMetaclass() || stereotype.getExtendedMetaclasses().contains((Object)metaclass)) {
            throw new IllegalArgumentException(String.valueOf(metaclass));
        }
        if (!profile.getReferencedMetaclasses().contains((Object)metaclass) && !profile.getReferencedMetamodels().contains((Object)metaclass.getModel())) {
            throw new IllegalArgumentException(String.valueOf(metaclass));
        }
        String metaclassName = metaclass.getName();
        Extension extension = (Extension)profile.createOwnedType(String.valueOf(metaclassName) + '_' + name, UMLPackage.Literals.EXTENSION);
        ExtensionEnd extensionEnd = (ExtensionEnd)extension.createOwnedEnd("extension_" + name, stereotype, UMLPackage.Literals.EXTENSION_END);
        extensionEnd.setAggregation(AggregationKind.COMPOSITE_LITERAL);
        if (isRequired) {
            extensionEnd.setLower(1);
        }
        Property property = stereotype.createOwnedAttribute("base_" + metaclassName, metaclass);
        property.setAssociation(extension);
        return extension;
    }

    public static Profile getProfile(Stereotype stereotype) {
        Package package_ = stereotype.getPackage();
        return package_ instanceof Profile ? (Profile)package_ : null;
    }

    public static String getKeyword(Stereotype stereotype) {
        return stereotype.getKeyword(true);
    }

    public static String getKeyword(Stereotype stereotype, boolean localize) {
        String keyword = StereotypeOperations.getString((EObject)stereotype, (String)StereotypeOperations.getValidJavaIdentifier((String)stereotype.getQualifiedName().replace(':', '_')), (String)"", (boolean)localize);
        if (StereotypeOperations.isEmpty((String)keyword)) {
            String identifier = StereotypeOperations.getValidJavaIdentifier((String)stereotype.getName());
            keyword = identifier.length() > 0 ? String.valueOf(Character.toLowerCase(identifier.charAt(0))) + identifier.substring(1) : identifier;
        }
        return keyword;
    }

    protected static EList getExtendedMetaclasses(Stereotype stereotype, EList extendedMetaclasses) {
        Iterator ownedAttributes = stereotype.getOwnedAttributes().iterator();
        while (ownedAttributes.hasNext()) {
            Type type;
            Property property = (Property)ownedAttributes.next();
            if (!(property.getAssociation() instanceof Extension) || !((type = property.getType()) instanceof Class)) continue;
            extendedMetaclasses.add((Object)type);
        }
        return extendedMetaclasses;
    }

    public static EList getExtendedMetaclasses(Stereotype stereotype) {
        return ECollections.unmodifiableEList((EList)StereotypeOperations.getExtendedMetaclasses(stereotype, (EList)new UniqueEList.FastCompare()));
    }

    public static EList getAllExtendedMetaclasses(Stereotype stereotype) {
        EList allExtendedMetaclasses = StereotypeOperations.getExtendedMetaclasses(stereotype, (EList)new UniqueEList.FastCompare());
        Iterator allParents = stereotype.allParents().iterator();
        while (allParents.hasNext()) {
            Object parent = allParents.next();
            if (!(parent instanceof Stereotype)) continue;
            StereotypeOperations.getExtendedMetaclasses((Stereotype)parent, allExtendedMetaclasses);
        }
        return ECollections.unmodifiableEList((EList)allExtendedMetaclasses);
    }

    public static EClass getDefinition(Stereotype stereotype) {
        Profile profile = stereotype.getProfile();
        return profile == null ? null : (EClass)profile.getDefinition(stereotype);
    }

    public static Image createIcon(Stereotype stereotype, String location) {
        Image icon = stereotype.createIcon();
        icon.setLocation(location);
        return icon;
    }

    public static Image createIcon(Stereotype stereotype, String format, String content) {
        Image icon = stereotype.createIcon();
        icon.setFormat(format);
        icon.setContent(content);
        return icon;
    }
}

