/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.exporter.ui.contribution.base;

import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.converter.ModelConverter;
import org.eclipse.emf.converter.ui.contribution.base.ModelConverterPackagePage;
import org.eclipse.emf.converter.util.ConverterUIUtil;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.exporter.ExporterPlugin;
import org.eclipse.emf.exporter.ModelExporter;
import org.eclipse.emf.exporter.ui.contribution.ModelExporterDescriptor;
import org.eclipse.emf.exporter.ui.contribution.ModelExporterManager;
import org.eclipse.emf.exporter.ui.contribution.base.IModelExporterPage;
import org.eclipse.emf.exporter.util.ExporterUIUtil;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelExporterPackagePage
extends ModelConverterPackagePage
implements IModelExporterPage {
    public ModelExporterPackagePage(ModelExporter modelExporter, String pageName) {
        super((ModelConverter)modelExporter, pageName);
        this.setDescription(ExporterPlugin.INSTANCE.getString("_UI_PackageSelection_description"));
    }

    @Override
    public ModelExporter getModelExporter() {
        return (ModelExporter)this.getModelConverter();
    }

    protected void adjustEPackagesTableViewer(CheckboxTableViewer ePackagesTableViewer) {
        super.adjustEPackagesTableViewer(ePackagesTableViewer);
        this.createEPackagesTableEditor();
    }

    protected boolean validateEPackageData(EPackage ePackage, String data) {
        Diagnostic diagnostic = this.getModelExporter().checkEPackageArtifactLocation(data, this.getLabel(ePackage));
        this.handleDiagnostic(diagnostic);
        return diagnostic.getSeverity() == 0;
    }

    protected void setEPackageData(EPackage ePackage, String data) {
        ModelExporter.EPackageExportInfo ePackageInfo = this.getModelExporter().getEPackageExportInfo(ePackage);
        ePackageInfo.setArtifactLocation(data);
    }

    protected String getEPackageData(EPackage ePackage) {
        return this.getModelExporter().getEPackageExportInfo(ePackage).getArtifactLocation();
    }

    protected String getEPackageDataColumnLabel() {
        return ExporterPlugin.INSTANCE.getString("_UI_ArtifactName_label");
    }

    protected void addReferencedGenModelsTreeColumns(CheckboxTreeViewer referencedGenModelsTreeViewer) {
        Tree tree = referencedGenModelsTreeViewer.getTree();
        tree.setHeaderVisible(true);
        TreeColumn genObjectColumn = new TreeColumn(tree, 0);
        genObjectColumn.setText(ExporterPlugin.INSTANCE.getString("_UI_GenObjectsColumn_title"));
        genObjectColumn.setResizable(true);
        genObjectColumn.setWidth(250);
        TreeColumn artifactColumn = new TreeColumn(tree, 0);
        artifactColumn.setText(ExporterPlugin.INSTANCE.getString("_UI_ExporterAndArtifactColumn_title"));
        artifactColumn.setResizable(true);
        artifactColumn.setWidth(200);
        ReferencedGenPackageTreeEditorHelper treeEditorHelper = new ReferencedGenPackageTreeEditorHelper(tree);
        treeEditorHelper.setColumn(1);
    }

    protected void addReferencedGenModelsTreeCheckStateManager(Tree tree) {
        new ConverterUIUtil.TreeCheckStateManager(tree){

            protected void setCheck(TreeItem item, boolean check) {
                Object data = item.getData();
                if (!(data instanceof GenPackage) || ModelExporterPackagePage.this.getModelExporter().getReferencedGenPackageExportInfo((GenPackage)data).isValidReference()) {
                    super.setCheck(item, check);
                }
            }
        };
    }

    protected void referencedGenModelsCheckboxTreeViewerCheckStateChanged(CheckStateChangedEvent event) {
        Object element;
        if (event != null && event.getChecked() && (element = event.getElement()) instanceof GenPackage) {
            GenPackage genPackage = (GenPackage)element;
            ModelExporter.ReferencedGenPackageExportInfo genPackageInfo = this.getModelExporter().getReferencedGenPackageExportInfo(genPackage);
            if (!genPackageInfo.isValidReference()) {
                ((CheckboxTreeViewer)event.getSource()).setChecked((Object)genPackage, false);
                return;
            }
        }
        super.referencedGenModelsCheckboxTreeViewerCheckStateChanged(event);
    }

    protected boolean supportsNestedPackages() {
        return true;
    }

    protected ILabelProvider getReferencedGenModelsTreeViewerLabelProvider(AdapterFactory adapterFactory) {
        return new AdapterFactoryLabelProvider(adapterFactory){

            public String getColumnText(Object object, int columnIndex) {
                if (columnIndex == 0) {
                    return ModelExporterPackagePage.this.getLabel(object, super.getColumnText(object, 0));
                }
                if (object instanceof GenPackage) {
                    GenPackage genPackage = (GenPackage)object;
                    ModelExporter.ReferencedGenPackageExportInfo genPackageInfo = ModelExporterPackagePage.this.getModelExporter().getReferencedGenPackageExportInfo(genPackage);
                    if (genPackageInfo.isValidReference()) {
                        return ModelExporterPackagePage.this.getArtifactText(genPackageInfo.getModelExporterID(), genPackageInfo.getArtifactURI());
                    }
                    return ExporterPlugin.INSTANCE.getString("_UI_NotAvailable_text");
                }
                return "";
            }

            public Image getColumnImage(Object object, int columnIndex) {
                return columnIndex == 0 ? super.getColumnImage(object, columnIndex) : null;
            }
        };
    }

    protected String getArtifactText(String modelExporterId, URI artifactURI) {
        if (artifactURI != null) {
            String modelExporterLabel = artifactURI.toString();
            if (modelExporterId != null) {
                ModelExporterDescriptor modelExporterDescriptor = ModelExporterManager.INSTANCE.getModelExporterDescriptor(modelExporterId);
                modelExporterLabel = String.valueOf(modelExporterDescriptor != null ? modelExporterDescriptor.getName() : modelExporterId) + " - " + modelExporterLabel;
            }
            return modelExporterLabel;
        }
        return "";
    }

    protected void validate() {
        super.validate();
        if (this.getErrorMessage() == null) {
            List tableCheckedEPackages = this.getCheckedEPackages();
            for (EPackage ePackage : tableCheckedEPackages) {
                if (this.validateEPackageData(ePackage, this.getModelExporter().getEPackageExportInfo(ePackage).getArtifactLocation())) continue;
                return;
            }
            List tableCheckedGenPackages = this.getCheckedReferencedGenPackages();
            for (GenPackage genPackage : tableCheckedGenPackages) {
                if (this.getModelExporter().getReferencedGenPackageExportInfo(genPackage).getArtifactURI() != null) continue;
                this.setErrorMessage(ExporterPlugin.INSTANCE.getString("_UI_ReferencedGenPackageNoArtifact_error"));
                return;
            }
        }
    }

    protected List<GenPackage> getReferencedGenPackagesToCheck(List<GenPackage> genPackages, boolean reloadReferencedGenPackagesTable) {
        if (reloadReferencedGenPackagesTable) {
            Iterator<GenPackage> i = genPackages.iterator();
            while (i.hasNext()) {
                GenPackage genPackage = i.next();
                if (this.getModelExporter().getReferencedGenPackageExportInfo(genPackage).getArtifactURI() != null) continue;
                i.remove();
            }
        }
        return genPackages;
    }

    public class ReferencedGenPackageTreeEditorHelper
    extends ExporterUIUtil.TreeEditorHelper {
        public ReferencedGenPackageTreeEditorHelper(Tree tree) {
            super(tree);
        }

        public void handleEvent(Event event) {
            if (event.widget instanceof CCombo) {
                this.comboSelected(event);
            } else {
                super.handleEvent(event);
            }
        }

        protected void comboSelected(Event event) {
            CCombo combo = (CCombo)event.widget;
            TreeItem treeItem = ((TreeEditor)this.compositeEditor).getItem();
            String text = combo.getItem(combo.getSelectionIndex());
            treeItem.setText(this.getColumn(), text);
            boolean validate = true;
            Object[] itemData = (Object[])combo.getData(text);
            if (itemData != null) {
                String exporterID = (String)itemData[0];
                URI artifactURI = (URI)itemData[1];
                GenPackage genPackage = (GenPackage)combo.getData();
                ModelExporter.ReferencedGenPackageExportInfo genPackageInfo = ModelExporterPackagePage.this.getModelExporter().getReferencedGenPackageExportInfo(genPackage);
                genPackageInfo.setModelExporterID(exporterID);
                genPackageInfo.setArtifactURI(artifactURI);
                if (treeItem.getChecked() != (artifactURI != null)) {
                    ModelExporterPackagePage.this.referencedGenModelsCheckboxTreeViewerCheckStateChanged(null);
                    validate = false;
                }
            }
            if (validate) {
                ModelExporterPackagePage.this.validate();
                ModelExporterPackagePage.this.getContainer().updateButtons();
            }
        }

        protected Control createEditorControl(Widget item) {
            Object data;
            TreeItem treeItem = (TreeItem)item;
            if (treeItem != null && (data = treeItem.getData()) instanceof GenPackage) {
                GenPackage genPackage = (GenPackage)data;
                ModelExporter.ReferencedGenPackageExportInfo genPackageInfo = ModelExporterPackagePage.this.getModelExporter().getReferencedGenPackageExportInfo(genPackage);
                if (genPackageInfo.isValidReference()) {
                    CCombo combo = new CCombo((Composite)treeItem.getParent(), 0x800008);
                    combo.addListener(13, (Listener)this);
                    this.initializeCombo(combo, genPackage);
                    return combo;
                }
            }
            return null;
        }

        protected void initializeCombo(CCombo combo, GenPackage genPackage) {
            combo.setData((Object)genPackage);
            String exporterID = ModelExporterPackagePage.this.getModelExporter().getID();
            for (URI uri : ModelExporterPackagePage.this.getModelExporter().getArtifactURIs(genPackage)) {
                String item = ModelExporterPackagePage.this.getArtifactText(exporterID, uri);
                combo.setData(item, (Object)new Object[]{exporterID, uri});
                combo.add(item);
            }
            ModelExporter.ReferencedGenPackageExportInfo genPackageInfo = ModelExporterPackagePage.this.getModelExporter().getReferencedGenPackageExportInfo(genPackage);
            if (genPackageInfo.getArtifactURI() != null) {
                combo.setText(ModelExporterPackagePage.this.getArtifactText(genPackageInfo.getModelExporterID(), genPackageInfo.getArtifactURI()));
            }
        }
    }
}

