/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.debug.ui.pages;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.ocl.examples.debug.vm.core.VMLineBreakpoint;
import org.eclipse.qvtd.debug.ui.QVTdDebugUIPlugin;
import org.eclipse.qvtd.debug.ui.messages.DebugUIMessages;
import org.eclipse.qvtd.debug.ui.pages.BreakpointConditionEditor;
import org.eclipse.qvtd.debug.ui.pages.QVTiBreakpointPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class QVTiLineBreakpointPage
extends QVTiBreakpointPage {
    private Button fEnableConditionButton;
    private BreakpointConditionEditor fConditionEditor;
    private Button fConditionIsTrue;
    private Button fConditionHasChanged;
    private Label fSuspendWhenLabel;

    @Override
    protected void doStore() throws CoreException {
        VMLineBreakpoint breakpoint = this.getBreakpoint();
        super.doStore();
        if (this.fConditionEditor != null) {
            boolean enableCondition = this.fEnableConditionButton.getSelection();
            String condition = this.fConditionEditor.getCondition();
            boolean suspendOnTrue = this.fConditionIsTrue.getSelection();
            if (breakpoint.isConditionEnabled() != enableCondition) {
                breakpoint.setConditionEnabled(enableCondition);
            }
            if (!condition.equals(breakpoint.getCondition())) {
                breakpoint.setCondition(condition);
            }
            if (breakpoint.isConditionSuspendOnTrue() != suspendOnTrue) {
                breakpoint.setConditionSuspendOnTrue(suspendOnTrue);
            }
        }
    }

    @Override
    protected void createTypeSpecificLabels(Composite parent) {
        VMLineBreakpoint breakpoint = this.getBreakpoint();
        StringBuffer lineNumber = new StringBuffer(4);
        try {
            int lNumber = breakpoint.getLineNumber();
            if (lNumber > 0) {
                lineNumber.append(lNumber);
            }
        }
        catch (CoreException ce) {
            QVTdDebugUIPlugin.log(ce);
        }
        if (lineNumber.length() > 0) {
            this.createLabel(parent, DebugUIMessages.QVTiLineBreakpointPage_LineNumber);
            Text text = SWTFactory.createText((Composite)parent, (int)8, (int)1, (String)lineNumber.toString());
            text.setBackground(parent.getBackground());
        }
    }

    @Override
    protected void createTypeSpecificEditors(Composite parent) throws CoreException {
        this.setTitle(DebugUIMessages.QVTiLineBreakpointPage_LineBreakpoint);
        VMLineBreakpoint breakpoint = this.getBreakpoint();
        if (breakpoint.supportsCondition()) {
            this.createConditionEditor(parent);
        }
    }

    private void createConditionEditor(Composite parent) throws CoreException {
        VMLineBreakpoint breakpoint = this.getBreakpoint();
        String label = DebugUIMessages.QVTiLineBreakpointPage_EnableCondition;
        Group conditionComposite = SWTFactory.createGroup((Composite)parent, (String)"", (int)1, (int)1, (int)1808);
        this.fEnableConditionButton = this.createCheckButton((Composite)conditionComposite, label);
        this.fEnableConditionButton.setSelection(breakpoint.isConditionEnabled());
        this.fEnableConditionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                QVTiLineBreakpointPage.this.setConditionEnabled(QVTiLineBreakpointPage.this.fEnableConditionButton.getSelection());
            }
        });
        this.fConditionEditor = new BreakpointConditionEditor((Composite)conditionComposite, this);
        this.fSuspendWhenLabel = this.createLabel((Composite)conditionComposite, DebugUIMessages.QVTiLineBreakpointPage_SuspendCondition);
        this.fConditionIsTrue = this.createRadioButton((Composite)conditionComposite, DebugUIMessages.QVTiLineBreakpointPage_ConditionTrue);
        this.fConditionHasChanged = this.createRadioButton((Composite)conditionComposite, DebugUIMessages.QVTiLineBreakpointPage_ConditionValueChange);
        if (breakpoint.isConditionSuspendOnTrue()) {
            this.fConditionIsTrue.setSelection(true);
        } else {
            this.fConditionHasChanged.setSelection(true);
        }
        this.setConditionEnabled(this.fEnableConditionButton.getSelection());
    }

    private void setConditionEnabled(boolean enabled) {
        this.fConditionEditor.setEnabled(enabled);
        this.fSuspendWhenLabel.setEnabled(enabled);
        this.fConditionIsTrue.setEnabled(enabled);
        this.fConditionHasChanged.setEnabled(enabled);
    }

    public int convertHeightInCharsToPixels(int chars) {
        return super.convertHeightInCharsToPixels(chars);
    }

    public int convertWidthInCharsToPixels(int chars) {
        return super.convertWidthInCharsToPixels(chars);
    }

    public void dispose() {
        if (this.fConditionEditor != null) {
            this.fConditionEditor.dispose();
        }
        super.dispose();
    }

    @Override
    public void createControl(Composite parent) {
        super.createControl(parent);
    }
}

