/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.util.Visitable;
import org.eclipse.ocl.pivot.util.Visitor;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.qvtd.compiler.internal.qvtm2qvts.RegionHelper;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.AbstractPartition;
import org.eclipse.qvtd.pivot.qvtschedule.Edge;
import org.eclipse.qvtd.pivot.qvtschedule.MappingRegion;
import org.eclipse.qvtd.pivot.qvtschedule.MicroMappingRegion;
import org.eclipse.qvtd.pivot.qvtschedule.NavigableEdge;
import org.eclipse.qvtd.pivot.qvtschedule.Node;
import org.eclipse.qvtd.pivot.qvtschedule.Region;
import org.eclipse.qvtd.pivot.qvtschedule.Role;
import org.eclipse.qvtd.pivot.qvtschedule.VariableNode;
import org.eclipse.qvtd.pivot.qvtschedule.util.AbstractExtendingQVTscheduleVisitor;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleUtil;

class PartitioningVisitor
extends AbstractExtendingQVTscheduleVisitor<Element, Object> {
    protected final @NonNull RegionHelper regionHelper;
    protected final @NonNull MicroMappingRegion partialRegion;
    protected final @NonNull AbstractPartition partition;
    private final @NonNull Map<@NonNull Node, @NonNull Node> oldNode2partialNode = new HashMap<Node, Node>();

    protected PartitioningVisitor(@NonNull RegionHelper regionHelper, @NonNull AbstractPartition partition) {
        super(null);
        this.regionHelper = regionHelper;
        this.partialRegion = (MicroMappingRegion)regionHelper.getRegion();
        this.partition = partition;
    }

    protected void addNode(@NonNull Node fullNode, @NonNull Node partialNode) {
        this.oldNode2partialNode.put(fullNode, partialNode);
        partialNode.setUtility(fullNode.getUtility());
        partialNode.setContained(fullNode.isContained());
        for (TypedElement typedElement : fullNode.getTypedElements()) {
            partialNode.addTypedElement(typedElement);
        }
    }

    public @NonNull Node getNode(@NonNull Node node) {
        return (Node)ClassUtil.nonNullState((Object)this.oldNode2partialNode.get(node));
    }

    public @NonNull MicroMappingRegion getRegion() {
        return this.partialRegion;
    }

    public @Nullable Edge visitEdge(@NonNull Edge edge) {
        if (edge.isSecondary()) {
            return null;
        }
        Node partialSourceNode = this.oldNode2partialNode.get(edge.getEdgeSource());
        if (partialSourceNode == null) {
            return null;
        }
        Node partialTargetNode = this.oldNode2partialNode.get(edge.getEdgeTarget());
        if (partialTargetNode == null) {
            return null;
        }
        Role edgeRole = this.partition.getEdgeRole(edge);
        if (edgeRole == null) {
            return null;
        }
        return edge.createEdge(edgeRole, partialSourceNode, partialTargetNode);
    }

    public @NonNull MappingRegion visitMappingRegion(@NonNull MappingRegion mappingRegion) {
        for (Node node : QVTscheduleUtil.getOwnedNodes((Region)mappingRegion)) {
            node.accept((Visitor)this);
        }
        for (Edge edge : QVTscheduleUtil.getOwnedEdges((Region)mappingRegion)) {
            edge.accept((Visitor)this);
        }
        return this.partialRegion;
    }

    public @Nullable NavigableEdge visitNavigableEdge(@NonNull NavigableEdge navigableEdge) {
        if (navigableEdge.isSecondary()) {
            return null;
        }
        Node partialSourceNode = this.oldNode2partialNode.get(navigableEdge.getEdgeSource());
        if (partialSourceNode == null) {
            return null;
        }
        Node partialTargetNode = this.oldNode2partialNode.get(navigableEdge.getEdgeTarget());
        if (partialTargetNode == null) {
            return null;
        }
        Role edgeRole = this.partition.getEdgeRole((Edge)navigableEdge);
        if (edgeRole == null) {
            return null;
        }
        return (NavigableEdge)navigableEdge.createEdge(edgeRole, partialSourceNode, partialTargetNode);
    }

    public @Nullable Node visitNode(@NonNull Node node) {
        Role nodeRole = this.partition.getNodeRole(node);
        if (nodeRole == null) {
            return null;
        }
        Node partialNode = null;
        if (node.isOperation()) {
            for (Edge edge : QVTscheduleUtil.getIncomingEdges((Node)node)) {
                Role edgeRole;
                if (!edge.isNavigation() || !edge.isRealized() || (edgeRole = this.partition.getEdgeRole(edge)) == null || edgeRole != Role.PREDICATED) continue;
                partialNode = this.regionHelper.createPredicatedStepNode(node, node.isMatched());
                break;
            }
        }
        if (partialNode == null) {
            partialNode = node.createNode(nodeRole, (Region)this.partialRegion);
        }
        this.addNode(node, partialNode);
        return partialNode;
    }

    public @Nullable Node visitVariableNode(@NonNull VariableNode variableNode) {
        Role nodeRole = this.partition.getNodeRole((Node)variableNode);
        if (nodeRole == null) {
            return null;
        }
        Node partialNode = variableNode.createNode(nodeRole, (Region)this.partialRegion);
        this.oldNode2partialNode.put((Node)variableNode, partialNode);
        partialNode.setUtility(variableNode.getUtility());
        partialNode.setContained(variableNode.isContained());
        for (TypedElement typedElement : variableNode.getTypedElements()) {
            partialNode.addTypedElement(typedElement);
        }
        return partialNode;
    }

    public @Nullable Element visiting(@NonNull Visitable visitable) {
        throw new UnsupportedOperationException(String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + ": " + visitable.getClass().getSimpleName());
    }
}

