/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.contentassist.antlr;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.Alternatives;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.EnumLiteralDeclaration;
import org.eclipse.xtext.EnumRule;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.Group;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.TerminalRule;
import org.eclipse.xtext.UnorderedGroup;
import org.eclipse.xtext.XtextFactory;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.parsetree.AbstractNode;
import org.eclipse.xtext.parsetree.CompositeNode;
import org.eclipse.xtext.parsetree.LeafNode;
import org.eclipse.xtext.parsetree.NodeAdapter;
import org.eclipse.xtext.parsetree.NodeUtil;
import org.eclipse.xtext.parsetree.ParseTreeUtil;
import org.eclipse.xtext.parsetree.util.ParsetreeSwitch;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.contentassist.AbstractContentAssistContextFactory;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.IFollowElementAcceptor;
import org.eclipse.xtext.ui.editor.contentassist.PrefixMatcher;
import org.eclipse.xtext.ui.editor.contentassist.antlr.FollowElement;
import org.eclipse.xtext.ui.editor.contentassist.antlr.IContentAssistParser;
import org.eclipse.xtext.util.XtextSwitch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParserBasedContentAssistContextFactory
extends AbstractContentAssistContextFactory {
    @Inject
    private IContentAssistParser parser;
    @Inject
    private Provider<ContentAssistContext> contentAssistContextProvider;
    @Inject
    private PrefixMatcher matcher;

    @Override
    public ContentAssistContext[] create(ITextViewer viewer, int offset, XtextResource resource) {
        try {
            String completeInput;
            String prefix;
            AbstractNode currentNode;
            CompositeNode rootNode;
            AbstractNode lastCompleteNode;
            IParseResult parseResult = resource.getParseResult();
            if (parseResult == null) {
                throw new NullPointerException("parseResult is null");
            }
            ITextSelection selection = (ITextSelection)viewer.getSelectionProvider().getSelection();
            int completionOffset = offset;
            if (selection.getOffset() + selection.getLength() == offset) {
                completionOffset = selection.getOffset();
            }
            if ((lastCompleteNode = (AbstractNode)new LeafNodeFinder(completionOffset, true).doSwitch((EObject)(rootNode = parseResult.getRootNode()))) == null) {
                lastCompleteNode = rootNode;
            }
            if ((currentNode = (AbstractNode)new LeafNodeFinder(completionOffset, false).doSwitch((EObject)rootNode)) == null) {
                currentNode = lastCompleteNode;
            }
            AbstractNode lastVisibleNode = ParseTreeUtil.getLastCompleteNodeByOffset((AbstractNode)rootNode, (int)completionOffset);
            EObject currentModel = NodeUtil.getNearestSemanticObject((AbstractNode)lastVisibleNode);
            ArrayList result = Lists.newArrayList();
            AbstractNode datatypeNode = this.getContainingDatatypeRuleNode(lastCompleteNode);
            if (datatypeNode != lastCompleteNode) {
                prefix = this.getPrefix(datatypeNode, completionOffset);
                completeInput = viewer.getDocument().get(0, datatypeNode.getOffset());
                Collection<FollowElement> followElements = this.parser.getFollowElements(completeInput);
                AbstractNode lastCompleteNodeBeforeDatatype = ParseTreeUtil.getLastCompleteNodeByOffset((AbstractNode)rootNode, (int)datatypeNode.getTotalOffset());
                this.createContexts(viewer, parseResult, completionOffset, rootNode, lastCompleteNodeBeforeDatatype, datatypeNode, result, prefix, currentModel, followElements);
            }
            if (datatypeNode == lastCompleteNode && completionOffset != lastCompleteNode.getOffset()) {
                List<ContentAssistContext> newContexts;
                boolean wasValid;
                prefix = this.getPrefix(lastCompleteNode, completionOffset);
                completeInput = viewer.getDocument().get(0, lastCompleteNode.getOffset());
                AbstractNode previousNode = ParseTreeUtil.getLastCompleteNodeByOffset((AbstractNode)rootNode, (int)lastCompleteNode.getOffset());
                EObject previousModel = NodeUtil.getNearestSemanticObject((AbstractNode)previousNode);
                AbstractNode currentDatatypeNode = this.getContainingDatatypeRuleNode(currentNode);
                Collection<FollowElement> followElements = this.parser.getFollowElements(completeInput);
                int prevSize = result.size();
                this.createContexts(viewer, parseResult, completionOffset, rootNode, previousNode, currentDatatypeNode, result, prefix, previousModel, followElements);
                if (lastCompleteNode instanceof LeafNode && lastCompleteNode.getGrammarElement() == null && (wasValid = this.isLikelyToBeValidProposal(lastCompleteNode, newContexts = result.subList(prevSize, result.size()))) && (!(lastCompleteNode instanceof LeafNode) || !((LeafNode)lastCompleteNode).isHidden())) {
                    this.createContexts(viewer, parseResult, completionOffset, rootNode, lastCompleteNode, currentNode, currentModel, result);
                }
            }
            if (!(lastCompleteNode instanceof LeafNode && lastCompleteNode.getGrammarElement() == null || lastCompleteNode instanceof LeafNode && ((LeafNode)lastCompleteNode).isHidden())) {
                this.createContexts(viewer, parseResult, completionOffset, rootNode, lastCompleteNode, currentNode, currentModel, result);
            }
            return result.toArray(new ContentAssistContext[result.size()]);
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e);
        }
    }

    protected boolean isLikelyToBeValidProposal(AbstractNode lastCompleteNode, List<ContentAssistContext> contexts) {
        for (ContentAssistContext context : contexts) {
            for (AbstractElement element : context.getFirstSetGrammarElements()) {
                String lastText;
                String keywordValue;
                if (!(element instanceof Keyword) || !(keywordValue = ((Keyword)element).getValue()).equals(lastText = ((LeafNode)lastCompleteNode).getText())) continue;
                return true;
            }
        }
        return false;
    }

    protected void createContexts(ITextViewer viewer, IParseResult parseResult, int completionOffset, CompositeNode rootNode, AbstractNode lastCompleteNode, AbstractNode currentNode, EObject currentModel, List<ContentAssistContext> result) throws BadLocationException {
        String prefix = "";
        String completeInput = viewer.getDocument().get(0, completionOffset);
        Collection<FollowElement> followElements = this.parser.getFollowElements(completeInput);
        this.createContexts(viewer, parseResult, completionOffset, rootNode, lastCompleteNode, currentNode, result, prefix, currentModel, followElements);
    }

    protected void createContexts(ITextViewer viewer, IParseResult parseResult, int completionOffset, CompositeNode rootNode, AbstractNode lastCompleteNode, AbstractNode currentNode, List<ContentAssistContext> result, String prefix, EObject previousModel, Collection<FollowElement> followElements) {
        LinkedHashSet followElementAsAbstractElements = Sets.newLinkedHashSet();
        this.computeFollowElements(followElements, followElementAsAbstractElements);
        Multimap<EObject, AbstractElement> contextMap = this.computeCurrentModel(previousModel, lastCompleteNode, followElementAsAbstractElements);
        currentNode = this.getContainingDatatypeRuleNode(currentNode);
        for (Map.Entry entry : contextMap.asMap().entrySet()) {
            ContentAssistContext context = this.createContext(viewer, completionOffset, parseResult, rootNode, lastCompleteNode, (EObject)entry.getKey(), currentNode, prefix);
            for (AbstractElement element : (Collection)entry.getValue()) {
                context.accept(element);
            }
            result.add(context);
        }
    }

    protected Multimap<EObject, AbstractElement> computeCurrentModel(EObject currentModel, AbstractNode lastCompleteNode, Collection<AbstractElement> followElements) {
        LinkedHashMultimap result = Multimaps.newLinkedHashMultimap();
        NodeAdapter adapter = NodeUtil.getNodeAdapter((EObject)currentModel);
        if (adapter == null || adapter.getParserNode() == null) {
            result.putAll((Object)currentModel, followElements);
            return result;
        }
        CompositeNode currentParserNode = adapter.getParserNode();
        EObject currentGrammarElement = currentParserNode.getGrammarElement();
        AbstractRule currentRule = this.getRule(currentGrammarElement);
        for (AbstractElement grammarElement : followElements) {
            EObject loopGrammarElement = currentGrammarElement;
            AbstractRule rule = currentRule;
            CompositeNode loopParserNode = currentParserNode;
            EObject loopLastGrammarElement = lastCompleteNode.getGrammarElement();
            while (!this.canBeCalledAfter(rule, loopLastGrammarElement, (EObject)grammarElement) && loopParserNode.getParent() != null) {
                loopLastGrammarElement = loopParserNode.getGrammarElement();
                loopParserNode = loopParserNode.getParent();
                while (loopParserNode.getGrammarElement() == null && loopParserNode.getParent() != null) {
                    loopParserNode = loopParserNode.getParent();
                }
                loopGrammarElement = loopParserNode.getGrammarElement();
                rule = this.getRule(loopGrammarElement);
            }
            EObject context = NodeUtil.getNearestSemanticObject((AbstractNode)loopParserNode);
            result.put((Object)context, (Object)grammarElement);
        }
        return result;
    }

    protected boolean canBeCalledAfter(AbstractRule rule, EObject previousGrammarElement, final EObject nextGrammarElement) {
        return (Boolean)new XtextSwitch<Boolean>(previousGrammarElement){
            private Set<AbstractRule> visiting = new HashSet<AbstractRule>();
            private Map<AbstractRule, Boolean> visited = Maps.newHashMapWithExpectedSize((int)4);
            private EObject grammarElement;
            private EObject queuedGrammarElement;
            private Boolean result;
            {
                this.grammarElement = eObject;
                this.queuedGrammarElement = eObject2;
                this.result = Boolean.FALSE;
            }

            public Boolean caseAbstractRule(AbstractRule object) {
                if (!this.checkFurther((EObject)object)) {
                    return this.result;
                }
                if (!this.visiting.add(object)) {
                    return Boolean.FALSE;
                }
                if (this.visited.containsKey(object)) {
                    this.visiting.remove(object);
                    return this.visited.get(object);
                }
                EObject wasGrammarElement = this.grammarElement;
                Boolean result = (Boolean)this.doSwitch((EObject)object.getAlternatives());
                this.visiting.remove(object);
                if (wasGrammarElement == this.grammarElement) {
                    this.visited.put(object, result);
                }
                return result;
            }

            private boolean checkFurther(EObject object) {
                if (object == this.grammarElement) {
                    if (this.queuedGrammarElement != null) {
                        this.grammarElement = this.queuedGrammarElement;
                        this.queuedGrammarElement = null;
                        this.visited.clear();
                        this.visiting.clear();
                        return true;
                    }
                    this.result = Boolean.TRUE;
                    return false;
                }
                return true;
            }

            public Boolean caseTerminalRule(TerminalRule object) {
                this.checkFurther((EObject)object);
                return this.result;
            }

            public Boolean caseGroup(Group object) {
                if (!this.checkFurther((EObject)object)) {
                    return this.result;
                }
                for (AbstractElement token : object.getElements()) {
                    if (!((Boolean)this.doSwitch((EObject)token)).booleanValue()) continue;
                    return true;
                }
                if (GrammarUtil.isMultipleCardinality((AbstractElement)object)) {
                    if (!this.checkFurther((EObject)object)) {
                        return this.result;
                    }
                    for (AbstractElement token : object.getElements()) {
                        if (!((Boolean)this.doSwitch((EObject)token)).booleanValue()) continue;
                        return true;
                    }
                }
                return false;
            }

            public Boolean caseUnorderedGroup(UnorderedGroup object) {
                if (!this.checkFurther((EObject)object)) {
                    return this.result;
                }
                if (this.caseAlternatives((List<AbstractElement>)object.getElements()).booleanValue()) {
                    return true;
                }
                if (!this.checkFurther((EObject)object)) {
                    return this.result;
                }
                return this.caseAlternatives((List<AbstractElement>)object.getElements());
            }

            public Boolean caseAlternatives(Alternatives object) {
                if (!this.checkFurther((EObject)object)) {
                    return this.result;
                }
                if (this.caseAlternatives((List<AbstractElement>)object.getElements()).booleanValue()) {
                    return true;
                }
                if (GrammarUtil.isMultipleCardinality((AbstractElement)object)) {
                    if (!this.checkFurther((EObject)object)) {
                        return this.result;
                    }
                    return this.caseAlternatives((List<AbstractElement>)object.getElements());
                }
                return Boolean.FALSE;
            }

            public Boolean caseAlternatives(List<AbstractElement> elements) {
                EObject wasGrammarElement = this.grammarElement;
                HashSet visiting = Sets.newHashSet(this.visiting);
                boolean foundSomething = false;
                for (AbstractElement group : elements) {
                    this.grammarElement = wasGrammarElement;
                    this.visiting = Sets.newHashSet((Iterable)visiting);
                    if (((Boolean)this.doSwitch((EObject)group)).booleanValue()) {
                        return true;
                    }
                    if (wasGrammarElement == this.grammarElement) continue;
                    foundSomething = true;
                }
                if (foundSomething) {
                    this.grammarElement = nextGrammarElement;
                    this.visiting.clear();
                }
                return Boolean.FALSE;
            }

            public Boolean caseAbstractElement(AbstractElement object) {
                if (!this.checkFurther((EObject)object)) {
                    return this.result;
                }
                if (GrammarUtil.isMultipleCardinality((AbstractElement)object) && !this.checkFurther((EObject)object)) {
                    return this.result;
                }
                return Boolean.FALSE;
            }

            public Boolean caseAssignment(Assignment object) {
                if (!this.checkFurther((EObject)object)) {
                    return this.result;
                }
                if (((Boolean)this.doSwitch((EObject)object.getTerminal())).booleanValue()) {
                    return true;
                }
                if (GrammarUtil.isMultipleCardinality((AbstractElement)object)) {
                    if (!this.checkFurther((EObject)object)) {
                        return this.result;
                    }
                    if (((Boolean)this.doSwitch((EObject)object.getTerminal())).booleanValue()) {
                        return true;
                    }
                }
                return Boolean.FALSE;
            }

            public Boolean caseCrossReference(CrossReference object) {
                if (!this.checkFurther((EObject)object)) {
                    return this.result;
                }
                if (((Boolean)this.doSwitch((EObject)object.getTerminal())).booleanValue()) {
                    return true;
                }
                if (GrammarUtil.isMultipleCardinality((AbstractElement)object)) {
                    if (!this.checkFurther((EObject)object)) {
                        return this.result;
                    }
                    if (((Boolean)this.doSwitch((EObject)object.getTerminal())).booleanValue()) {
                        return true;
                    }
                }
                return Boolean.FALSE;
            }

            public Boolean caseRuleCall(RuleCall object) {
                if (!this.checkFurther((EObject)object)) {
                    return this.result;
                }
                if (((Boolean)this.doSwitch((EObject)object.getRule())).booleanValue()) {
                    return true;
                }
                if (GrammarUtil.isMultipleCardinality((AbstractElement)object)) {
                    if (!this.checkFurther((EObject)object)) {
                        return this.result;
                    }
                    if (((Boolean)this.doSwitch((EObject)object.getRule())).booleanValue()) {
                        return true;
                    }
                }
                return Boolean.FALSE;
            }

            public Boolean caseEnumLiteralDeclaration(EnumLiteralDeclaration object) {
                if (!this.checkFurther((EObject)object)) {
                    return this.result;
                }
                Boolean result = (Boolean)this.doSwitch((EObject)object.getLiteral());
                return result;
            }
        }.doSwitch((EObject)rule);
    }

    protected AbstractRule getRule(EObject currentGrammarElement) {
        AbstractRule rule = null;
        if (currentGrammarElement instanceof RuleCall) {
            rule = ((RuleCall)currentGrammarElement).getRule();
        }
        if (currentGrammarElement instanceof AbstractRule) {
            rule = (AbstractRule)currentGrammarElement;
        }
        if (currentGrammarElement instanceof Action) {
            rule = (AbstractRule)EcoreUtil2.getContainerOfType((EObject)currentGrammarElement, AbstractRule.class);
        }
        if (rule == null) {
            throw new IllegalStateException();
        }
        return rule;
    }

    protected void computeFollowElements(Collection<FollowElement> followElements, final Collection<AbstractElement> result) {
        FollowElementCalculator calculator = new FollowElementCalculator();
        calculator.acceptor = new IFollowElementAcceptor(){

            public void accept(AbstractElement element) {
                ParserRule rule = GrammarUtil.containingParserRule((EObject)element);
                if (rule == null || !GrammarUtil.isDatatypeRule((ParserRule)rule)) {
                    result.add(element);
                }
            }
        };
        for (FollowElement element : followElements) {
            this.computeFollowElements(calculator, element);
        }
    }

    protected void computeFollowElements(FollowElementCalculator calculator, FollowElement element) {
        HashMultimap visited = Multimaps.newHashMultimap();
        this.computeFollowElements(calculator, element, (Multimap<Integer, List<AbstractElement>>)visited);
    }

    protected void computeFollowElements(FollowElementCalculator calculator, FollowElement element, Multimap<Integer, List<AbstractElement>> visited) {
        ArrayList currentState = Lists.newArrayList(element.getLocalTrace());
        currentState.add(element.getGrammarElement());
        if (!visited.put((Object)element.getLookAhead(), (Object)currentState)) {
            return;
        }
        if (element.getLookAhead() <= 1) {
            ParserRule parserRule;
            for (AbstractElement abstractElement : currentState) {
                Assignment ass = (Assignment)EcoreUtil2.getContainerOfType((EObject)abstractElement, Assignment.class);
                if (ass != null) {
                    calculator.doSwitch((EObject)ass);
                    continue;
                }
                if (abstractElement instanceof UnorderedGroup && abstractElement == element.getGrammarElement()) {
                    calculator.doSwitch((UnorderedGroup)abstractElement, element.getHandledUnorderedGroupElements());
                    continue;
                }
                calculator.doSwitch((EObject)abstractElement);
            }
            if (element.getTrace().equals(element.getLocalTrace()) && (parserRule = GrammarUtil.containingParserRule((EObject)element.getGrammarElement())) != null) {
                RuleCall ruleCall = XtextFactory.eINSTANCE.createRuleCall();
                ruleCall.setRule((AbstractRule)parserRule);
                calculator.doSwitch((EObject)ruleCall);
            }
            return;
        }
        Collection<FollowElement> followElements = this.parser.getFollowElements(element);
        for (FollowElement newElement : followElements) {
            if (newElement.getLookAhead() == element.getLookAhead() && newElement.getGrammarElement() == element.getGrammarElement()) continue;
            this.computeFollowElements(calculator, newElement, visited);
        }
    }

    public AbstractNode getContainingDatatypeRuleNode(AbstractNode node) {
        AbstractNode result = node;
        EObject grammarElement = result.getGrammarElement();
        if (grammarElement != null) {
            ParserRule parserRule = GrammarUtil.containingParserRule((EObject)grammarElement);
            while (parserRule != null && GrammarUtil.isDatatypeRule((ParserRule)parserRule)) {
                result = result.getParent();
                grammarElement = result.getGrammarElement();
                parserRule = GrammarUtil.containingParserRule((EObject)grammarElement);
            }
        }
        return result;
    }

    public ContentAssistContext createContext(ITextViewer viewer, int offset, IParseResult parseResult, CompositeNode rootNode, AbstractNode lastCompleteNode, EObject currentModel, AbstractNode currentNode, String prefix) {
        ITextSelection selection = (ITextSelection)viewer.getSelectionProvider().getSelection();
        ContentAssistContext context = (ContentAssistContext)this.contentAssistContextProvider.get();
        context.setRootNode(rootNode);
        context.setLastCompleteNode(lastCompleteNode);
        context.setCurrentNode(currentNode);
        context.setRootModel(parseResult.getRootASTElement());
        context.setCurrentModel(currentModel);
        context.setOffset(offset);
        context.setViewer(viewer);
        context.setPrefix(prefix);
        int regionLength = prefix.length();
        if (selection.getLength() > 0) {
            regionLength += selection.getLength();
        }
        Region region = new Region(offset - prefix.length(), regionLength);
        context.setReplaceRegion(region);
        context.setSelectedText(selection.getText());
        context.setMatcher(this.matcher);
        return context;
    }

    public String getPrefix(AbstractNode prefixNode, int offset) {
        if (prefixNode instanceof LeafNode) {
            if (((LeafNode)prefixNode).isHidden() && prefixNode.getGrammarElement() != null) {
                return "";
            }
            return this.getNodeText(prefixNode, offset);
        }
        StringBuilder result = new StringBuilder(prefixNode.getTotalLength());
        this.doComputePrefix((CompositeNode)prefixNode, result, offset);
        return result.toString();
    }

    public String getNodeText(AbstractNode currentNode, int offset) {
        String text;
        int startOffset = currentNode.getOffset();
        int length = offset - startOffset;
        String result = length > (text = ((LeafNode)currentNode).getText()).length() ? text : text.substring(0, length);
        return result;
    }

    public boolean doComputePrefix(CompositeNode node, StringBuilder result, int offset) {
        ArrayList<LeafNode> hiddens = new ArrayList<LeafNode>(2);
        for (AbstractNode child : node.getChildren()) {
            if (child instanceof CompositeNode) {
                if (this.doComputePrefix((CompositeNode)child, result, offset)) continue;
                return false;
            }
            LeafNode leaf = (LeafNode)child;
            if (leaf.getOffset() > offset) {
                return false;
            }
            if (leaf.isHidden()) {
                if (result.length() == 0) continue;
                hiddens.add((LeafNode)child);
                continue;
            }
            Iterator iter = hiddens.iterator();
            while (iter.hasNext()) {
                result.append(((LeafNode)iter.next()).getText());
            }
            hiddens.clear();
            result.append(this.getNodeText((AbstractNode)leaf, offset));
            if (leaf.getOffset() + leaf.getLength() <= offset) continue;
            return false;
        }
        return true;
    }

    public void setParser(IContentAssistParser parser) {
        this.parser = parser;
    }

    public IContentAssistParser getParser() {
        return this.parser;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FollowElementCalculator
    extends XtextSwitch<Boolean> {
        protected IFollowElementAcceptor acceptor;
        private List<AbstractElement> handledAlternatives;
        private UnorderedGroup group;
        private Collection<RuleCall> visitedRuleCalls = Sets.newHashSet();

        public void doSwitch(UnorderedGroup group, List<AbstractElement> handledAlternatives) {
            this.group = group;
            this.handledAlternatives = handledAlternatives;
            try {
                this.doSwitch((EObject)group);
            }
            finally {
                this.handledAlternatives = null;
                this.group = null;
            }
        }

        public Boolean caseAlternatives(Alternatives object) {
            boolean more = false;
            for (AbstractElement element : object.getElements()) {
                boolean bl = more = (Boolean)this.doSwitch((EObject)element) != false || more;
            }
            if (!more && !this.isOptional((AbstractElement)object)) {
                return false;
            }
            return true;
        }

        public Boolean caseUnorderedGroup(UnorderedGroup object) {
            if (object == this.group) {
                boolean more = true;
                for (AbstractElement element : object.getElements()) {
                    if (this.handledAlternatives != null && this.handledAlternatives.contains(element)) continue;
                    this.group = null;
                    more = (Boolean)this.doSwitch((EObject)element) != false && more;
                    this.group = object;
                }
                if (more && GrammarUtil.isMultipleCardinality((AbstractElement)object)) {
                    this.handledAlternatives = null;
                    this.group = null;
                    return this.caseUnorderedGroup(object);
                }
                if (!more && !this.isOptional((AbstractElement)object)) {
                    return false;
                }
                return true;
            }
            boolean more = true;
            for (AbstractElement element : object.getElements()) {
                boolean bl = more = (Boolean)this.doSwitch((EObject)element) != false && more;
            }
            if (!more && !this.isOptional((AbstractElement)object)) {
                return false;
            }
            return true;
        }

        public Boolean caseGroup(Group object) {
            boolean more = true;
            for (AbstractElement element : object.getElements()) {
                boolean bl = more = more && (Boolean)this.doSwitch((EObject)element) != false;
            }
            if (!more && !this.isOptional((AbstractElement)object)) {
                return false;
            }
            return true;
        }

        public Boolean caseAction(Action object) {
            return true;
        }

        public Boolean caseAssignment(Assignment object) {
            this.acceptor.accept((AbstractElement)object);
            if (!((Boolean)this.doSwitch((EObject)object.getTerminal())).booleanValue() && !this.isOptional((AbstractElement)object)) {
                return false;
            }
            return true;
        }

        public Boolean caseCrossReference(CrossReference object) {
            return Boolean.FALSE;
        }

        public Boolean caseParserRule(ParserRule object) {
            if (GrammarUtil.isDatatypeRule((ParserRule)object)) {
                return Boolean.FALSE;
            }
            return (Boolean)this.doSwitch((EObject)object.getAlternatives());
        }

        public Boolean caseEnumRule(EnumRule object) {
            return (Boolean)this.doSwitch((EObject)object.getAlternatives());
        }

        public Boolean caseEnumLiteralDeclaration(EnumLiteralDeclaration object) {
            return (Boolean)this.doSwitch((EObject)object.getLiteral());
        }

        public Boolean caseRuleCall(RuleCall object) {
            if (!this.visitedRuleCalls.add(object)) {
                return this.isOptional((AbstractElement)object);
            }
            this.acceptor.accept((AbstractElement)object);
            Boolean result = (Boolean)this.doSwitch((EObject)object.getRule()) != false || this.isOptional((AbstractElement)object);
            this.visitedRuleCalls.remove(object);
            return result;
        }

        public Boolean caseTerminalRule(TerminalRule object) {
            return Boolean.FALSE;
        }

        public Boolean caseKeyword(Keyword object) {
            this.acceptor.accept((AbstractElement)object);
            return this.isOptional((AbstractElement)object);
        }

        public boolean isOptional(AbstractElement element) {
            return GrammarUtil.isOptionalCardinality((AbstractElement)element);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LeafNodeFinder
    extends ParsetreeSwitch<LeafNode> {
        private final int offset;
        private final boolean leading;

        public LeafNodeFinder(int offset, boolean leading) {
            this.offset = offset;
            this.leading = leading;
        }

        public LeafNode caseCompositeNode(CompositeNode object) {
            block4: {
                block3: {
                    if (!this.leading) break block3;
                    if (object.getTotalOffset() >= this.offset || object.getTotalLength() + object.getTotalOffset() < this.offset) break block4;
                    for (AbstractNode node : object.getChildren()) {
                        LeafNode result = (LeafNode)this.doSwitch((EObject)node);
                        if (result == null) continue;
                        return result;
                    }
                    break block4;
                }
                if (object.getTotalOffset() <= this.offset && object.getTotalLength() + object.getTotalOffset() > this.offset) {
                    for (AbstractNode node : object.getChildren()) {
                        LeafNode result = (LeafNode)this.doSwitch((EObject)node);
                        if (result == null) continue;
                        return result;
                    }
                }
            }
            return null;
        }

        public LeafNode caseLeafNode(LeafNode object) {
            if (this.leading ? object.getTotalOffset() < this.offset && object.getTotalLength() + object.getTotalOffset() >= this.offset : object.getTotalOffset() <= this.offset && object.getTotalLength() + object.getTotalOffset() > this.offset) {
                return object;
            }
            return null;
        }
    }
}

