/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.folding;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.xtext.parsetree.CompositeNode;
import org.eclipse.xtext.parsetree.NodeAdapter;
import org.eclipse.xtext.parsetree.NodeUtil;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.folding.DefaultFoldingRegion;
import org.eclipse.xtext.ui.editor.folding.IFoldingRegion;
import org.eclipse.xtext.ui.editor.folding.IFoldingRegionProvider;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultFoldingRegionProvider
implements IFoldingRegionProvider {
    private static final Logger log = Logger.getLogger(DefaultFoldingRegionProvider.class);

    @Override
    public List<IFoldingRegion> getFoldingRegions(final IXtextDocument xtextDocument) {
        return (List)xtextDocument.readOnly((IUnitOfWork)new IUnitOfWork<List<IFoldingRegion>, XtextResource>(){

            public List<IFoldingRegion> exec(XtextResource xtextResource) throws Exception {
                if (xtextResource == null) {
                    return Collections.emptyList();
                }
                return DefaultFoldingRegionProvider.this.doGetFoldingRegions(xtextDocument, xtextResource);
            }
        });
    }

    protected List<IFoldingRegion> doGetFoldingRegions(IXtextDocument xtextDocument, XtextResource xtextResource) {
        ArrayList foldingRegions = Lists.newArrayList();
        TreeIterator allContents = xtextResource.getAllContents();
        while (allContents.hasNext()) {
            EObject eObject = (EObject)allContents.next();
            if (!this.isHandled(eObject)) continue;
            this.addFoldingRegions(xtextDocument, eObject, foldingRegions);
        }
        return foldingRegions;
    }

    protected void addFoldingRegions(IXtextDocument xtextDocument, EObject eObject, List<IFoldingRegion> foldingRegions) {
        Assert.isNotNull((Object)eObject, (String)"parameter 'eObject' must not be null");
        CompositeNode compositeNode = this.getCompositeNode(eObject);
        if (compositeNode != null) {
            Position position = this.getPosition(xtextDocument, compositeNode);
            if (position != null) {
                List<IFoldingRegion> newFoldingRegions = this.createFoldingRegions(eObject, position);
                Assert.isNotNull(newFoldingRegions, (String)"'newFoldingRegions' must not be null");
                foldingRegions.addAll(newFoldingRegions);
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("No position for eObject '" + eObject + "' with compositeNode '" + compositeNode + "' provided"));
            }
        }
    }

    protected CompositeNode getCompositeNode(EObject eObject) {
        NodeAdapter nodeAdapter = NodeUtil.getNodeAdapter((EObject)eObject);
        return nodeAdapter != null ? nodeAdapter.getParserNode() : null;
    }

    protected Position getPosition(IXtextDocument xtextDocument, CompositeNode compositeNode) {
        Assert.isNotNull((Object)compositeNode, (String)"parameter 'compositeNode' must not be null");
        Position position = null;
        try {
            int startLine = xtextDocument.getLineOfOffset(compositeNode.getOffset());
            int endLine = xtextDocument.getLineOfOffset(compositeNode.getOffset() + compositeNode.getLength());
            if (startLine < endLine) {
                int start = xtextDocument.getLineOffset(startLine);
                int end = xtextDocument.getLineOffset(endLine) + xtextDocument.getLineLength(endLine);
                position = new Position(start, end - start);
            }
        }
        catch (BadLocationException e) {
            log.error((Object)e);
        }
        return position;
    }

    protected boolean isHandled(EObject eObject) {
        return eObject.eContainer() != null;
    }

    protected List<IFoldingRegion> createFoldingRegions(EObject eObject, Position position) {
        IFoldingRegion foldingRegion = this.newFoldingRegion(eObject, position);
        return Lists.newArrayList((Object[])new IFoldingRegion[]{foldingRegion});
    }

    protected IFoldingRegion newFoldingRegion(EObject eObject, Position position) {
        return new DefaultFoldingRegion(position);
    }

    protected IFoldingRegion newFoldingRegion(EObject eObject, Position position, StyledString styledString) {
        return new DefaultFoldingRegion(position, styledString);
    }
}

