/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.access.jdt;

import java.util.List;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.xtext.common.types.access.TypeResource;
import org.eclipse.xtext.common.types.access.impl.AbstractClassMirror;
import org.eclipse.xtext.common.types.access.impl.ITypeFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdtTypeMirror
extends AbstractClassMirror
implements IElementChangedListener,
Adapter {
    private final IType mirroredType;
    private final ITypeFactory<IType> typeFactory;
    private TypeResource typeResource;

    public JdtTypeMirror(IType type, ITypeFactory<IType> typeFactory) {
        this.mirroredType = type;
        this.typeFactory = typeFactory;
    }

    public void initialize(TypeResource typeResource) {
        typeResource.getContents().add((Object)this.typeFactory.createType((Object)this.mirroredType));
        this.typeResource = typeResource;
        JavaCore.addElementChangedListener((IElementChangedListener)this);
        typeResource.getResourceSet().eAdapters().add((Object)this);
    }

    protected String getTypeName() {
        return this.mirroredType.getFullyQualifiedName();
    }

    public IType getMirroredType() {
        return this.mirroredType;
    }

    public void elementChanged(ElementChangedEvent event) {
        if (this.isAffectedBy(event.getDelta())) {
            this.unloadResource();
        }
    }

    private boolean isAffectedBy(IJavaElementDelta delta) {
        IJavaElement element = delta.getElement();
        if (this.mirroredType.equals(element)) {
            return true;
        }
        if (element.getElementType() > 7) {
            return false;
        }
        IJavaElementDelta[] iJavaElementDeltaArray = delta.getAffectedChildren();
        int n = iJavaElementDeltaArray.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElementDelta child = iJavaElementDeltaArray[n2];
            if (this.isAffectedBy(child)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected void unloadResource() {
        if (this.typeResource.getResourceSet() != null) {
            this.typeResource.getResourceSet().eAdapters().remove((Object)this);
        }
        JavaCore.removeElementChangedListener((IElementChangedListener)this);
        this.typeResource.unload();
        if (this.typeResource.getResourceSet() != null) {
            this.typeResource.getResourceSet().getResources().remove((Object)this.typeResource);
        }
    }

    public Notifier getTarget() {
        return null;
    }

    public boolean isAdapterForType(Object object) {
        return false;
    }

    public void notifyChanged(Notification notification) {
        if (notification.isTouch()) {
            return;
        }
        switch (notification.getEventType()) {
            case 4: {
                if (notification.getOldValue() != this.typeResource) break;
                this.unloadResource();
                ResourceSet resourceSet = (ResourceSet)notification.getNotifier();
                resourceSet.eAdapters().remove((Object)this);
                break;
            }
            case 6: {
                if (!((List)notification.getOldValue()).contains(this.typeResource)) break;
                this.unloadResource();
                ResourceSet resourceSet = (ResourceSet)notification.getNotifier();
                resourceSet.eAdapters().remove((Object)this);
            }
        }
    }

    public void setTarget(Notifier notifier) {
    }
}

