/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.autoedit;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.List;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.xtext.ui.editor.ISourceViewerAware;
import org.eclipse.xtext.ui.editor.autoedit.MultiLineTerminalsEditStrategy;
import org.eclipse.xtext.ui.editor.autoedit.SameTerminalsEditStrategy;
import org.eclipse.xtext.ui.editor.autoedit.ShortCutEditStrategy;
import org.eclipse.xtext.ui.editor.autoedit.SingleLineTerminalsStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultAutoEditStrategy
implements IAutoEditStrategy,
ISourceViewerAware {
    private List<IAutoEditStrategy> strategies = Lists.newArrayList();
    private Provider<SameTerminalsEditStrategy> sameTerminal;
    private Provider<SingleLineTerminalsStrategy> singleLineTerminals;
    private Provider<MultiLineTerminalsEditStrategy> multiLineTerminals;
    private Provider<ShortCutEditStrategy> shortCuts;

    public MultiLineTerminalsEditStrategy newMultiLineTerminals(String start, String indentation, String end) {
        return ((MultiLineTerminalsEditStrategy)this.multiLineTerminals.get()).configure(start, indentation, end);
    }

    public SameTerminalsEditStrategy newSameTerminal(char terminal) {
        return ((SameTerminalsEditStrategy)this.sameTerminal.get()).configure(terminal);
    }

    public ShortCutEditStrategy newShortCuts(String shortcut, String replacement) {
        return ((ShortCutEditStrategy)this.shortCuts.get()).configure(shortcut, replacement);
    }

    public SingleLineTerminalsStrategy newSingleLineTerminals(char start, char end) {
        return ((SingleLineTerminalsStrategy)this.singleLineTerminals.get()).configure(start, end);
    }

    @Inject
    public void initialize(Provider<SameTerminalsEditStrategy> sameTerminal, Provider<SingleLineTerminalsStrategy> singleLineTerminals, Provider<MultiLineTerminalsEditStrategy> multiLineTerminals, Provider<ShortCutEditStrategy> shortCuts) {
        this.sameTerminal = sameTerminal;
        this.singleLineTerminals = singleLineTerminals;
        this.multiLineTerminals = multiLineTerminals;
        this.shortCuts = shortCuts;
    }

    public void customizeDocumentCommand(IDocument document, DocumentCommand command) {
        for (IAutoEditStrategy strategy : this.strategies) {
            strategy.customizeDocumentCommand(document, command);
        }
    }

    protected void configure(IEditStrategyAcceptor acceptor) {
        this.configureStringLiteral(acceptor);
        this.configureParenthesis(acceptor);
        this.configureSquareBrackets(acceptor);
        this.configureCurlyBracesBlock(acceptor);
        this.configureMultilineComments(acceptor);
    }

    protected void configureMultilineComments(IEditStrategyAcceptor acceptor) {
        acceptor.accept(this.newMultiLineTerminals("/*", " * ", " */"));
    }

    protected void configureCurlyBracesBlock(IEditStrategyAcceptor acceptor) {
        acceptor.accept(this.newMultiLineTerminals("{", null, "}"));
    }

    protected void configureSquareBrackets(IEditStrategyAcceptor acceptor) {
        acceptor.accept(this.newSingleLineTerminals('[', ']'));
    }

    protected void configureParenthesis(IEditStrategyAcceptor acceptor) {
        acceptor.accept(this.newSingleLineTerminals('(', ')'));
    }

    protected void configureStringLiteral(IEditStrategyAcceptor acceptor) {
        acceptor.accept(this.newSameTerminal('\"'));
        acceptor.accept(this.newSameTerminal('\''));
    }

    @Override
    public void setSourceViewer(final ISourceViewer sourceViewer) {
        this.configure(new IEditStrategyAcceptor(){

            public void accept(IAutoEditStrategy strategy) {
                if (strategy instanceof ISourceViewerAware) {
                    ((ISourceViewerAware)strategy).setSourceViewer(sourceViewer);
                }
                DefaultAutoEditStrategy.this.strategies.add(strategy);
            }
        });
    }

    public static interface IEditStrategyAcceptor {
        public void accept(IAutoEditStrategy var1);
    }
}

