/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Nullable;
import com.google.common.collect.EnumBiMap;
import com.google.common.collect.Serialization;
import com.google.common.collect.StandardBiMap;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EnumHashBiMap<K extends Enum<K>, V>
extends StandardBiMap<K, V> {
    private transient Class<K> keyType;
    private static final long serialVersionUID = 0L;

    public EnumHashBiMap(Class<K> keyType) {
        super(new EnumMap(keyType), new HashMap(((Enum[])keyType.getEnumConstants()).length * 3 / 2));
        this.keyType = keyType;
    }

    public EnumHashBiMap(Map<K, ? extends V> map) {
        this(EnumBiMap.inferKeyType(map));
        this.putAll(map);
    }

    @Override
    public V put(K key, @Nullable V value) {
        return super.put(key, value);
    }

    @Override
    public V forcePut(K key, @Nullable V value) {
        return super.forcePut(key, value);
    }

    public Class<K> keyType() {
        return this.keyType;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeObject(this.keyType);
        Serialization.writeMap(this, stream);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.keyType = (Class)stream.readObject();
        this.setDelegates(new EnumMap(this.keyType), new HashMap(((Enum[])this.keyType.getEnumConstants()).length * 3 / 2));
        Serialization.populateMap(this, stream);
    }
}

