/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.autoedit;

import org.apache.log4j.Logger;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.xtext.ui.editor.autoedit.AbstractEditStrategy;

public class SameTerminalsEditStrategy
extends AbstractEditStrategy {
    private static final Logger log = Logger.getLogger(SameTerminalsEditStrategy.class);
    private String terminal;

    public SameTerminalsEditStrategy configure(char terminal) {
        this.terminal = String.valueOf(terminal);
        return this;
    }

    public void customizeDocumentCommand(IDocument document, DocumentCommand command) {
        try {
            String documentContent;
            int count;
            if (command.text.equals(this.terminal) && !this.isIdentifierPart(document, command.offset + command.length) && (count = this.count(this.terminal, documentContent = this.getDocumentContent(document, command))) % 2 == 0) {
                if (command.offset + command.length < document.getLength()) {
                    String nextChar = String.valueOf(document.getChar(command.offset + command.length));
                    if (this.terminal.equals(nextChar)) {
                        if (command.length == 0) {
                            command.length = 1;
                        }
                    } else {
                        this.appendClosingTerminal(documentContent, count, command);
                    }
                } else {
                    this.appendClosingTerminal(documentContent, count, command);
                }
            }
            if (command.text.equals("") && command.length == this.terminal.length()) {
                if (command.offset + 2 * this.terminal.length() > document.getLength()) {
                    return;
                }
                if (command.offset + command.length - this.terminal.length() < 0) {
                    return;
                }
                String string = document.get(command.offset, 2 * this.terminal.length());
                if (string.equals(String.valueOf(this.terminal) + this.terminal)) {
                    command.length *= 2;
                }
            }
        }
        catch (BadLocationException ex) {
            log.error((Object)"Exception in AutoEditStrategy", (Throwable)ex);
        }
    }

    protected void appendClosingTerminal(String documentContent, int occurenceCount, DocumentCommand command) throws BadLocationException {
        String leadingContent;
        int leadingCount;
        if (documentContent.length() > command.offset && (leadingCount = this.count(this.terminal, leadingContent = documentContent.substring(0, command.offset))) % 2 == 1) {
            return;
        }
        command.text = String.valueOf(this.terminal) + this.terminal;
        command.caretOffset = command.offset + this.terminal.length();
        command.shiftsCaret = false;
    }
}

