/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.autoedit;

import org.apache.log4j.Logger;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.xtext.ui.editor.autoedit.AbstractEditStrategy;

public class SingleLineTerminalsStrategy
extends AbstractEditStrategy {
    private static final Logger log = Logger.getLogger(SingleLineTerminalsStrategy.class);
    private String left;
    private String right;

    public SingleLineTerminalsStrategy configure(char left, char right) {
        this.left = String.valueOf(left);
        this.right = String.valueOf(right);
        return this;
    }

    public void customizeDocumentCommand(IDocument document, DocumentCommand command) {
        try {
            this.handleInsertLeftTerminal(document, command);
            this.handleInsertRightTerminal(document, command);
            this.handleDeletion(document, command);
        }
        catch (BadLocationException ex) {
            log.error((Object)"Exception in AutoEditStrategy", (Throwable)ex);
        }
    }

    protected void handleInsertLeftTerminal(IDocument document, DocumentCommand command) throws BadLocationException {
        int closing;
        String documentContent;
        int opening;
        int occurences;
        if (command.text.equals(this.left) && !this.isIdentifierPart(document, command.offset + command.length) && (occurences = (opening = this.count(this.left, documentContent = this.getDocumentContent(document, command))) + (closing = this.count(this.right, documentContent))) % 2 == 0) {
            command.text = String.valueOf(this.left) + this.right;
            command.caretOffset = command.offset + this.left.length();
            command.shiftsCaret = false;
        }
    }

    protected void handleDeletion(IDocument document, DocumentCommand command) throws BadLocationException {
        if (command.text.equals("") && command.length == 1) {
            if (command.offset + this.right.length() + this.left.length() > document.getLength()) {
                return;
            }
            if (command.offset + command.length - this.left.length() < 0) {
                return;
            }
            if (command.length != this.left.length()) {
                return;
            }
            String string = document.get(command.offset, this.left.length() + this.right.length());
            if (string.equals(String.valueOf(this.left) + this.right)) {
                command.length = this.left.length() + this.right.length();
            }
        }
    }

    protected void handleInsertRightTerminal(IDocument document, DocumentCommand command) throws BadLocationException {
        if (command.text.equals(this.right) && command.length == 0) {
            int closing;
            if (command.offset + this.right.length() > document.getLength()) {
                return;
            }
            String documentContent = this.getDocumentContent(document, command);
            int opening = this.count(this.left, documentContent);
            if (opening <= (closing = this.count(this.right, documentContent)) && this.right.equals(document.get(command.offset, command.text.length()))) {
                command.length += this.right.length();
            }
        }
    }
}

