/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.bracketmatching;

import com.google.common.collect.BiMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.parsetree.AbstractNode;
import org.eclipse.xtext.parsetree.CompositeNode;
import org.eclipse.xtext.parsetree.NodeUtil;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.bracketmatching.IBracketMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBracketMatcher
implements IBracketMatcher {
    private BiMap<AbstractElement, AbstractElement> pairs = null;

    public abstract void configure(IBracketPairAcceptor var1);

    @Override
    public IRegion computeMatchingRegion(XtextResource state, int offset) {
        AbstractNode correspondingNode;
        if (state == null || state.getContents() == null || state.getContents().isEmpty()) {
            return null;
        }
        CompositeNode rootNode = NodeUtil.getRootNode((EObject)((EObject)state.getContents().get(0)));
        if (rootNode == null) {
            return null;
        }
        AbstractNode node = NodeUtil.findLeafNodeAtOffset((CompositeNode)rootNode, (int)offset);
        if (node == null) {
            return null;
        }
        AbstractElement element = this.findElement(node, (Map<AbstractElement, AbstractElement>)this.getPairs());
        boolean forwardSearch = true;
        if (element == null) {
            forwardSearch = false;
            element = this.findElement(node, (Map<AbstractElement, AbstractElement>)this.getPairs().inverse());
        }
        if (element != null && (correspondingNode = this.findMatchingNode(node, element, forwardSearch)) != null) {
            return new Region(correspondingNode.getOffset(), correspondingNode.getLength());
        }
        return null;
    }

    protected BiMap<AbstractElement, AbstractElement> getPairs() {
        if (this.pairs == null) {
            this.pairs = Maps.newHashBiMap();
            this.configure(new IBracketPairAcceptor(){

                public void accept(AbstractElement left, AbstractElement right) {
                    AbstractBracketMatcher.this.pairs.put((Object)left, (Object)right);
                }
            });
        }
        return this.pairs;
    }

    protected AbstractElement findElement(AbstractNode node, Map<AbstractElement, AbstractElement> map) {
        EObject grammarElement = node.getGrammarElement();
        return map.get(grammarElement);
    }

    protected AbstractNode findMatchingNode(AbstractNode node, AbstractElement element, boolean forwardSearch) {
        CompositeNode node2 = this.findRuleCallNode(node);
        if (node2 == null) {
            return null;
        }
        List<AbstractNode> children = this.getAllNodesInRule((List<AbstractNode>)node2.getChildren());
        boolean match = !forwardSearch;
        for (AbstractNode abstractNode : children) {
            if (abstractNode == node) {
                match = !match;
                continue;
            }
            if (!match || abstractNode.getGrammarElement() != element) continue;
            return abstractNode;
        }
        return null;
    }

    protected List<AbstractNode> getAllNodesInRule(List<AbstractNode> nodes) {
        ArrayList result = Lists.newArrayList();
        for (AbstractNode n : nodes) {
            if (n.getGrammarElement() instanceof RuleCall) continue;
            result.add(n);
            if (!(n instanceof CompositeNode)) continue;
            result.addAll(this.getAllNodesInRule((List<AbstractNode>)((CompositeNode)n).getChildren()));
        }
        return result;
    }

    protected CompositeNode findRuleCallNode(AbstractNode node) {
        while (node != null && !(node.getGrammarElement() instanceof RuleCall)) {
            node = (AbstractNode)node.eContainer();
        }
        return (CompositeNode)node;
    }

    public static interface IBracketPairAcceptor {
        public void accept(AbstractElement var1, AbstractElement var2);
    }
}

